/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.basic;

import jmarkov.basic.Event;
import jmarkov.basic.PropertiesElement;

public class PropertiesEvent
extends Event
implements PropertiesElement {
    private final int[] prop;

    public PropertiesEvent(int[] status) {
        this.prop = status;
    }

    @Override
    public String label() {
        String localName = "(";
        int i = 0;
        while (i < this.prop.length - 1) {
            localName = String.valueOf(localName) + this.prop[i] + ",";
            ++i;
        }
        return String.valueOf(localName) + this.prop[this.prop.length - 1] + ")";
    }

    public PropertiesEvent(int size) {
        this(new int[size]);
    }

    @Override
    public int getNumProps() {
        return this.prop.length;
    }

    @Override
    public final int compareTo(PropertiesEvent e1) {
        int i = 0;
        while (i < this.prop.length) {
            if (this.prop[i] < e1.prop[i]) {
                return 1;
            }
            if (this.prop[i] > e1.prop[i]) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public final int compareTo(Event e) {
        if (!(e instanceof PropertiesEvent)) {
            return -1;
        }
        return this.compareTo((PropertiesEvent)e);
    }

    public final boolean equals(PropertiesEvent e) {
        return this.compareTo(e) == 0;
    }

    @Override
    public final int[] getProperties() {
        int[] newProp = new int[this.prop.length];
        System.arraycopy(this.prop, 0, newProp, 0, this.prop.length);
        return newProp;
    }

    @Override
    public int getProperty(int index) {
        return this.prop[index];
    }

    protected void setProperty(int index, int value) {
        this.prop[index] = value;
    }

    @Override
    public PropertiesEvent clone() {
        return new PropertiesEvent(this.prop);
    }
}

