/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.basic;

import java.io.PrintWriter;
import java.io.StringWriter;
import jmarkov.basic.Action;
import jmarkov.basic.DecisionRule;
import jmarkov.basic.State;

public final class Policy<S extends State, A extends Action> {
    DecisionRule<S, A>[] decisionRulesP;
    boolean stationary = false;

    public Policy(int stages) {
        this.decisionRulesP = new DecisionRule[stages];
        this.stationary = false;
    }

    public Policy(DecisionRule d) {
        this.decisionRulesP = new DecisionRule[1];
        this.setDecisionRule(d);
        this.stationary = true;
    }

    public int getHorizon() {
        if (this.stationary) {
            return Integer.MAX_VALUE;
        }
        return this.decisionRulesP.length;
    }

    public void setDecisionRule(DecisionRule<S, A> dr, int t) {
        this.decisionRulesP[t] = dr;
    }

    public void setDecisionRule(DecisionRule<S, A> pol) {
        this.decisionRulesP[0] = pol;
        this.stationary = true;
    }

    public DecisionRule<S, A> getDecisionRule() {
        assert (this.stationary);
        if (this.decisionRulesP.length > 1) {
            return null;
        }
        return this.decisionRulesP[0];
    }

    public DecisionRule<S, A> getDecisionRule(int t) {
        return this.decisionRulesP[t];
    }

    public A getAction(S i, int t) {
        DecisionRule<S, A> decisionR = this.getDecisionRule(t);
        return decisionR.getAction(i);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.print(pw);
        return sw.toString();
    }

    public void print() {
        this.print(new PrintWriter(System.out, true));
    }

    public void print(PrintWriter pw) {
        pw.println("********* Best Policy *********\n");
        int n = this.decisionRulesP.length;
        int t = 0;
        while (t < n) {
            if (!this.stationary) {
                pw.println("Stage: " + t);
            } else {
                pw.println("In every stage do: ");
            }
            this.getDecisionRule(t).print(pw);
            ++t;
        }
    }
}

