/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import Jama.Matrix;
import junit.framework.Assert;

public class Utils
extends Assert {
    private static int top_n = 0;
    private static double[][] L = new double[100][];

    public static void assertArrayEquals(double[] a1, double[] a2) {
        Utils.assertArrayEquals(a1, a2, 1.0E-8);
    }

    public static void assertArrayEquals(double[] a1, double[] a2, double epsilon) {
        Utils.assertArrayEquals("", a1, a2, epsilon);
    }

    public static void assertArrayEquals(String msg, double[] a1, double[] a2, double epsilon) {
        String formatted = "";
        boolean result = true;
        if (a1 == null) {
            result = false;
        } else if (a2 == null) {
            result = false;
        } else if (a1.length != a2.length) {
            result = false;
            formatted = " Diferent array dimensions. Expected: " + a1.length + ", but was :" + a2.length;
        } else {
            int n = a1.length;
            int i = 0;
            while (i < n && result) {
                result = result && Math.abs(a1[i] - a2[i]) < epsilon;
                formatted = " Diferent arrays at component " + i + ". Expected: " + a1[i] + ", but was :" + a2[i];
                ++i;
            }
        }
        if (!result) {
            Utils.fail((String)(String.valueOf(msg) + ":" + formatted));
        }
    }

    public static void assertArrayEquals(String msg, int[] a1, int[] a2) {
        String formatted = "";
        boolean result = true;
        if (a1 == null) {
            result = false;
        } else if (a2 == null) {
            result = false;
        } else if (a1.length != a2.length) {
            result = false;
            formatted = " Diferent array dimensions. Expected: " + a1.length + ", but was :" + a2.length;
        } else {
            int n = a1.length;
            int i = 0;
            while (i < n && result) {
                result = result && a1[i] == a2[i];
                formatted = " Diferent arrays at component " + i + ". Expected: " + a1[i] + ", but was :" + a2[i];
                ++i;
            }
        }
        if (!result) {
            Utils.fail((String)(String.valueOf(msg) + ":" + formatted));
        }
    }

    public static void assertArrayEquals(double[][] a1, double[][] a2) {
        Utils.assertArrayEquals(a1, a2, 1.0E-8);
    }

    public static void assertArrayEquals(double[][] a1, double[][] a2, double epsilon) {
        Utils.assertArrayEquals("", a1, a2, epsilon);
    }

    public static void assertArrayEquals(String msg, double[][] a1, double[][] a2, double epsilon) {
        boolean result = true;
        String formatted = "";
        if (a1 == null) {
            result = false;
        } else if (a2 == null) {
            result = false;
        } else if (a1.length != a2.length) {
            result = false;
        } else if (a1[1].length != a2[1].length) {
            result = false;
            formatted = " Diferent array dimensions. Expected: " + a1.length + ", but was :" + a2.length;
        } else {
            int n = a1.length;
            int m = a1[1].length;
            int i = 0;
            while (i < n && result) {
                int j = 0;
                while (j < m && result) {
                    result = result && Math.abs(a1[i][j] - a2[i][j]) < epsilon;
                    formatted = " Diferent arrays at component (" + i + "," + "). Expected: " + a1[i][j] + ", but was :" + a2[i][j];
                    ++j;
                }
                ++i;
            }
        }
        if (!result) {
            Utils.fail((String)(String.valueOf(msg) + ":" + formatted));
        }
    }

    public static double[][] flowProb(int M) {
        double[][] pr = new double[M][M];
        int i = 0;
        while (i < M - 1) {
            pr[i][i + 1] = 1.0;
            ++i;
        }
        pr[M - 1][0] = 1.0;
        return pr;
    }

    public static double[] getMVAthruput(int N, int M, double[] mu) {
        return Utils.getMVAthruput(N, M, mu, Utils.flowProb(M));
    }

    public static double[] getMVAthruput(int N, int M, double[] mu, double[] alpha) {
        double[] lam = new double[M];
        if (N < top_n || top_n == 0) {
            top_n = 0;
            L = new double[100][];
            Utils.L[0] = new double[M];
        }
        int n = top_n + 1;
        while (n <= N) {
            Utils.L[n] = new double[M];
            lam = Utils.getMVAthruput(n, M, mu, L[n - 1], L[n], alpha);
            ++n;
        }
        top_n = N;
        return lam;
    }

    public static double[] getMVAthruput(int N, int M, double[] mu, double[][] prob) {
        return Utils.getMVAthruput(N, M, mu, Utils.getSS(prob));
    }

    public static void resetMVA() {
        top_n = 0;
        L = new double[100][];
    }

    private static double[] getMVAthruput(int n, int M, double[] mu, double[] L_old, double[] L, double[] alpha) {
        double[] W = new double[M];
        double[] lam = new double[M];
        double sum = 0.0;
        int m = 0;
        while (m < M) {
            W[m] = (1.0 + L_old[m]) * (1.0 / mu[m]);
            sum += alpha[m] * W[m];
            ++m;
        }
        m = 0;
        while (m < M) {
            L[m] = (double)n * W[m] * alpha[m] / sum;
            lam[m] = L[m] / W[m];
            ++m;
        }
        return lam;
    }

    public static double[][] getProb(int M) {
        double[][] prob = new double[M][M];
        int i = 0;
        while (i < M) {
            double sum = 0.0;
            int j = 0;
            while (j < M - 1) {
                double d = 1.0 / (double)(2 * M);
                prob[i][j] = d;
                sum += d;
                ++j;
            }
            prob[i][M - 1] = 1.0 - sum;
            ++i;
        }
        return prob;
    }

    public static double[] getSS(double[][] prob) {
        int n = prob.length;
        Matrix matA = Matrix.identity((int)n, (int)n).minus(new Matrix(prob));
        int i = 0;
        while (i < n) {
            matA.set(i, n - 1, 1.0);
            ++i;
        }
        Matrix oneVec = new Matrix(1, prob.length);
        oneVec.set(0, n - 1, 1.0);
        return matA.solveTranspose(oneVec).getColumnPackedCopy();
    }
}

