/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import examples.jmarkov.DriveThru;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import jmarkov.basic.State;
import jmarkov.solvers.JamaTransientSolver;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class TransientTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(TransientTest.class);
    }

    public static void testTransientProbs() throws IOException {
        DriveThru theDT = new DriveThru(80.0, 120.0, 30.0, 4, 2, 1);
        JamaTransientSolver Transient2 = new JamaTransientSolver(theDT);
        theDT.setMaxStates(Integer.MAX_VALUE);
        theDT.setDebugLevel(0);
        double[] tiempos = new double[]{0.05, 0.1, 0.2, 0.3};
        State[] sts = theDT.getStates().toStateArray();
        State s0 = sts[0];
        double[][] trans = Transient2.getTransientProbs(tiempos, s0);
        URL url = TransientTest.class.getResource("TransientTest.class");
        try {
            File classFile = new File(url.toURI());
            String fileName = String.valueOf(classFile.getParent()) + System.getProperty("file.separator") + "DTResults.txt";
            File outputFile = new File(fileName);
            PrintWriter outF = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            int filas = trans.length;
            int columnas = trans[0].length;
            System.out.println("filas" + filas);
            System.out.println("Columnas" + columnas);
            int i = 0;
            while (i < trans.length) {
                int j = 0;
                while (j < trans[0].length) {
                    outF.print(String.valueOf(trans[i][j]) + "  ");
                    System.out.print(String.valueOf(trans[i][j]) + "  ");
                    ++j;
                }
                outF.println("  ");
                System.out.println("  ");
                ++i;
            }
            outF.close();
        }
        catch (IOException e) {
            return;
        }
        catch (URISyntaxException e) {
            return;
        }
        theDT.printAll();
        theDT.printMOPs();
    }
}

