/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.Event;
import jmarkov.basic.EventsSet;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.Transitions;
import jmarkov.basic.TransitionsSet;

public abstract class SimpleMarkovProcess<S extends State, E extends Event>
extends MarkovProcess<S, E> {
    public SimpleMarkovProcess(S i0, EventsSet<E> eSet, String name) {
        super(i0, eSet, name);
    }

    public SimpleMarkovProcess(S i0, EventsSet<E> eSet) {
        super(i0, eSet);
    }

    public SimpleMarkovProcess() {
    }

    public abstract boolean active(S var1, E var2);

    public abstract States<S> dests(S var1, E var2);

    public abstract double rate(S var1, S var2, E var3);

    @Override
    public final Transitions<S> activeTransitions(S i, E e) {
        TransitionsSet<State> trans = new TransitionsSet<State>();
        boolean isActive = this.active(i, e);
        if (isActive) {
            this.debug(3, "Event " + e + (isActive ? " is " : " is not") + " active");
            States<S> dests = this.dests(i, e);
            if (dests == null || dests.size() == 0) {
                this.debug(0, "WARNNING: Event [" + e + "] in state " + i + "has no destinations!");
            } else {
                for (State j : dests) {
                    Thread.yield();
                    assert (j.isConsistent());
                    boolean result = trans.add(j, this.rate(i, j, e));
                    assert (result);
                }
            }
        }
        return trans;
    }
}

