/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import examples.jmarkov.QueueMH2k1;
import jmarkov.Utils;
import jmarkov.basic.exceptions.NotUnichainException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrix;

public class QueueMH2k1Test
extends TestCase {
    private QueueMH2k1 model = null;
    double[][] matrixR = new double[][]{{0.6419753084348551, 0.44444444430105357}, {0.19753086409800832, 0.44444444437554426}};
    private double[] arrayA0 = new double[]{4.0, 0.0, 0.0, 4.0};
    private double[] arrayA1 = new double[]{-13.0, 0.0, 9.0, -13.0};
    private double[] arrayA2 = new double[]{0.0, 9.0, 0.0, 0.0};
    private double[] arrayB00 = new double[]{-7.0};
    private double[] arrayB01 = new double[]{7.0, 0.0};
    private double[] arrayB10 = new double[]{0.0, 9.0};
    private double[] pi0 = new double[]{0.0666858472473757};
    private double[] pi1 = new double[]{0.074914784737818, 0.0583356184930964};
    private double[] pi1mod = new double[]{0.4666666665986373, 0.4666666665986373};
    private double[] mopsAvg = new double[]{6.533333320037249, 0.933314152752624, 0.466657099381307, 0.466657053371318};
    private double[] eventRates = new double[]{0.46680093073163, 3.7332566110105, 4.19991389443176, 4.19991348034186};

    public static void main(String[] args) {
        TestRunner.run(QueueMH2k1Test.class);
    }

    public QueueMH2k1Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.model = new QueueMH2k1(7, 4, 9.0, 9.0);
        this.model.generate();
        this.model.setDebugLevel(0);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.model = null;
    }

    public void testGetAMatrices() {
        Matrix[] A = this.model.getAMatrices();
        double[] A0 = new DenseMatrix(A[0]).getData();
        double[] A1 = new DenseMatrix(A[1]).getData();
        double[] A2 = new DenseMatrix(A[2]).getData();
        Utils.assertArrayEquals("A0 different", this.arrayA0, A0, 1.0E-4);
        Utils.assertArrayEquals("A1 different", this.arrayA1, A1, 1.0E-4);
        Utils.assertArrayEquals("A2 different", this.arrayA2, A2, 1.0E-4);
    }

    public void testIsStable() {
        boolean stable = this.model.isStable();
        QueueMH2k1Test.assertTrue((String)"Stability test failed", (boolean)stable);
    }

    public void testGetRmatrix() throws NotUnichainException {
        double[][] newR = this.model.matrixRtoArray();
        Utils.assertArrayEquals("matrix R is not equal", this.matrixR, newR, 0.1);
    }

    public void testGetBMatrices() {
        Matrix[] B = this.model.getBMatrices();
        double[] B00 = new DenseMatrix(B[0]).getData();
        double[] B01 = new DenseMatrix(B[1]).getData();
        double[] B10 = new DenseMatrix(B[2]).getData();
        Utils.assertArrayEquals("B00 different", this.arrayB00, B00, 1.0E-4);
        Utils.assertArrayEquals("B01 different", this.arrayB01, B01, 1.0E-4);
        Utils.assertArrayEquals("B10 different", this.arrayB10, B10, 1.0E-4);
    }

    public void testGetVectorPi1() throws NotUnichainException {
        double[] vectorPi1 = this.model.getVectorPi1();
        Utils.assertArrayEquals("Pi1 vectors are not equal", vectorPi1, this.pi1, 0.01);
    }

    public void testGetVectorPi1Mod() throws NotUnichainException {
        double[] vectorPi1mod = this.model.getVectorPi1Mod();
        Utils.assertArrayEquals("Pi1 vectors are not equal", vectorPi1mod, this.pi1mod, 0.01);
    }

    public void testGetVectorPi0() throws NotUnichainException {
        double[] vectorPi0 = this.model.getVectorPi0();
        Utils.assertArrayEquals("Pi0 vectors are not equal", vectorPi0, this.pi0, 0.1);
    }

    public void testGetMOPsAvg() throws Exception {
        double[] averageMOPs = this.model.getMOPsAvg();
        Utils.assertArrayEquals("The MOPS average are not equal", this.mopsAvg, averageMOPs, 0.1);
    }

    public void testGetEventsRates() throws Exception {
        double[] rates = this.model.getEventsRates();
        Utils.assertArrayEquals("The rates are not equal", this.eventRates, rates, 0.1);
    }
}

