/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import jmarkov.DebugReporter;
import jmarkov.basic.Event;
import jmarkov.basic.EventsSet;
import jmarkov.basic.JMarkovElement;
import jmarkov.basic.State;
import jmarkov.basic.StatesSet;
import jmarkov.basic.Transition;
import jmarkov.basic.Transitions;
import jmarkov.basic.TransitionsSet;
import jmarkov.basic.exceptions.NotUnichainException;
import jmarkov.gui.MarkovGUI;
import jmarkov.solvers.JamaTransientSolver;
import jmarkov.solvers.MtjSolver;
import jmarkov.solvers.SteadyStateSolver;
import jmarkov.solvers.TransientSolver;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;

public abstract class MarkovProcess<S extends State, E extends Event>
implements JMarkovElement {
    private S i0;
    protected int cnt = 0;
    protected StatesSet<S> theStates = new StatesSet();
    SortedSet<S> uncheckedStates = new TreeSet<S>();
    private SortedMap<S, S> foundStates = new TreeMap<S, S>();
    private SortedMap<S, Transitions<S>> rates = new TreeMap<S, Transitions<S>>();
    private int numE;
    boolean generated = false;
    private long maxStates = 1000L;
    private double[][] ratesMatrix = null;
    private double[][] genMatrix = null;
    private double[] thePi = null;
    protected String name = "";
    E[] theEvents = null;
    DebugReporter reporter = new DebugReporter(1);
    SteadyStateSolver steadyStateSolver = null;
    TransientSolver transientSolver = null;
    protected SteadyStateSolver defaultSteadyStateSolver = null;
    protected TransientSolver defaultTransientSolver = null;
    private Status _status = Status.IDLE;
    private Matrix mtRatesMatrix = null;
    private PrintWriter out;
    private List<String> mopsNames = new ArrayList<String>();
    private MarkovGUI theGUI = null;

    public MarkovProcess(S i0, EventsSet<E> eSet, String name) {
        this.clearMOPs();
        this.setInitialState(i0);
        this.setEventSet(eSet);
        this.name = name;
    }

    public MarkovProcess(S i0, EventsSet<E> eSet) {
        this(i0, eSet, "");
    }

    protected MarkovProcess() {
        this.reset(false);
    }

    protected void setEventSet(EventsSet<E> eSet) {
        this.theEvents = eSet.toEventArray();
        this.reset(false);
    }

    protected void setInitialState(S i0) {
        this.i0 = i0;
        this.uncheckedStates = new TreeSet<S>();
        this.clearMOPs();
        if (i0 != null) {
            this.uncheckedStates.add(i0);
        }
        this.reset(false);
    }

    protected S getInitialState() {
        return this.i0;
    }

    public synchronized void reset() {
        this.reset(false);
    }

    protected synchronized void reset(boolean resetEvents) {
        this.uncheckedStates = new TreeSet<S>();
        this.clearMOPs();
        if (this.i0 != null) {
            this.uncheckedStates.add(this.i0);
        }
        if (resetEvents) {
            this.theEvents = null;
        }
        this.theStates = null;
        this.generated = false;
        this.ratesMatrix = null;
        this.genMatrix = null;
        this.foundStates = new TreeMap<S, S>();
        this.theStates = new StatesSet();
        this.rates = new TreeMap<S, Transitions<S>>();
        this.resetResults();
        this.setStatus(Status.IDLE);
    }

    public synchronized void resetResults() {
        this.thePi = null;
        this.cnt = 0;
        this.setStatus(Status.IDLE);
    }

    public abstract Transitions<S> activeTransitions(S var1, E var2);

    public void generate() {
        if (this.getStatus() == Status.IDLE) {
            this.debug(1, "MODEL: " + this.label());
            if (this.getDebugLevel() >= 2) {
                EventsSet eSet = new EventsSet(this.theEvents);
                this.debug(2, "Events Set: " + eSet);
            }
            this.debug(1, "Generating model ...");
        } else {
            this.debug(1, "Continuing model generation ...");
        }
        this.setStatus(Status.RUNNING);
        while (!this.uncheckedStates.isEmpty() && (long)this.cnt < this.maxStates && this.canGo()) {
            this.generateStep();
        }
        this.setEndStatus();
    }

    private void setEndStatus() {
        this.generated = this.uncheckedStates.isEmpty();
        this.debug(1, "");
        if (this.generated) {
            this.debug(1, "DONE. " + this.cnt + " states found.");
            this.theStates.numerateStates();
            this.setStatus(Status.GENERATED);
        } else {
            if ((long)this.cnt == this.maxStates) {
                this.setStatus(Status.ERROR);
                this.debug(0, "Maximum Number of States Reached! (" + this.cnt + ")");
                throw new RuntimeException("Maximum Number of States Reached! (" + this.cnt + ")");
            }
            this.debug(0, "PROCESS INTERRUPTED");
            this.setStatus(Status.SUSPENDED);
        }
    }

    private void updateRates(S i, Transitions<S> currentRates, S j, double rate) {
        double curVal = currentRates.addRate(j, rate);
        double newVal = curVal + rate;
        this.debug(5, "Rate(" + i + "," + j + ") = " + newVal + " (It was " + curVal + ")");
    }

    private void generateStep() {
        State i = (State)this.uncheckedStates.first();
        if (this.reporter.getDebugLevel() == 1) {
            if (this.cnt % 100 == 0) {
                this.debug(1, "", true);
                this.debug(1, "", false, true);
            }
            this.debug(1, ".", false);
        }
        ++this.cnt;
        this.debug(2, "Building State " + i);
        this.debug(5, "S = " + this.theStates);
        this.debug(5, "U = " + this.uncheckedStates);
        this.uncheckedStates.remove(i);
        this.theStates.add(i);
        this.foundStates.put(i, i);
        i.computeMOPs(this);
        TransitionsSet totalRates = new TransitionsSet();
        this.rates.put(i, totalRates);
        E[] EArray = this.theEvents;
        int n = this.theEvents.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            Transitions<State> trans = this.activeTransitions(i, e);
            if (trans == null) break;
            for (Transition transition : trans) {
                Thread.yield();
                Object j = transition.getState();
                State curj = (State)this.foundStates.get(j);
                if (curj == null) {
                    this.debug(5, "New state found j = " + j);
                    this.uncheckedStates.add(j);
                    this.foundStates.put(j, j);
                    assert (((State)j).isConsistent());
                } else {
                    j = curj;
                }
                double rate = transition.getRate();
                this.debug(4, "Event [" + e + "]: Transition " + i + " ---> " + j + " with rate " + rate);
                this.updateRates(i, totalRates, j, rate);
            }
            ++n2;
        }
        Thread.yield();
    }

    public int getNumStates() {
        StatesSet<S> stts = this.getStates();
        return stts.size();
    }

    public StatesSet<S> getStates() {
        return this.getStates(true);
    }

    public StatesSet<S> getStates(boolean causesGeneration) {
        if (!this.generated && causesGeneration) {
            this.generate();
        }
        if (this.theStates != null) {
            return this.theStates;
        }
        this.debug(1, "Building States...");
        this.theStates.numerateStates();
        return this.theStates;
    }

    public E[] getEvents() {
        return this.theEvents;
    }

    public synchronized Transitions<S> getRates(S i) {
        return (Transitions)this.rates.get(i);
    }

    public synchronized double getRate(S i, S j) {
        if (!this.generated) {
            this.generate();
        }
        return ((Transitions)this.rates.get(i)).getRate(j);
    }

    public synchronized double getFinalRate(S i, S j) {
        if (!this.generated) {
            this.generate();
        }
        return ((Transitions)this.rates.get(i)).getRate(j);
    }

    public synchronized double[][] getRates() {
        if (!this.generated) {
            this.generate();
        }
        if (this.ratesMatrix != null) {
            return this.ratesMatrix;
        }
        this.setStatus(Status.RUNNING);
        this.debug(1, "Building dense Rates Matrix ..");
        int n = this.getNumStates();
        this.ratesMatrix = new double[n][n];
        this.cnt = 0;
        for (Map.Entry<S, Transitions<S>> entry : this.rates.entrySet()) {
            this.debug(3, "Row " + this.cnt + ", State: " + entry.getKey());
            Transitions<S> trans = entry.getValue();
            for (Transition transition : trans) {
                double valObj = transition.getRate();
                Object s2 = transition.getState();
                int j = ((State)s2).getIndex();
                this.debug(4, "Col " + j + ", State: " + s2);
                this.ratesMatrix[this.cnt][j] = valObj;
                assert (this.cnt == ((State)entry.getKey()).getIndex());
            }
            ++this.cnt;
        }
        this.setStatus(Status.GENERATED);
        return this.ratesMatrix;
    }

    public synchronized Matrix getMtjRates() {
        if (!this.generated) {
            this.generate();
        }
        if (this.mtRatesMatrix != null) {
            return this.mtRatesMatrix;
        }
        this.setStatus(Status.RUNNING);
        this.debug(1, "Building Rates Matrix ..");
        int n = this.getNumStates();
        int[] nz = new int[n];
        int i = 0;
        for (Transitions<S> transitions : this.rates.values()) {
            nz[i] = transitions.size();
            ++i;
        }
        this.mtRatesMatrix = new FlexCompRowMatrix(n, n);
        i = 0;
        for (Map.Entry entry : this.rates.entrySet()) {
            this.cnt = i;
            Transitions trans = (Transitions)entry.getValue();
            this.debug(3, "Row " + i + ", State: " + entry.getKey());
            for (Transition tr : trans) {
                Object s = tr.getState();
                double rate = tr.getRate();
                int j = ((State)s).getIndex();
                this.debug(4, "Col " + j + ", State: " + s);
                this.mtRatesMatrix.set(i, j, rate);
            }
            ++i;
        }
        this.debug(3, "The Rates matrix is: \n" + this.mtRatesMatrix);
        this.setStatus(Status.GENERATED);
        return this.mtRatesMatrix;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public double[][] getGenerator() {
        if (this.genMatrix != null) {
            return this.genMatrix;
        }
        this.debug(1, "Building Generator Matrix ...");
        double[][] R = this.getRates();
        int n = R.length;
        double[][] Q = new double[n][n];
        int i = 0;
        while (i < n) {
            double sum = 0.0;
            int j = 0;
            while (j < n) {
                if (i != j) {
                    Q[i][j] = R[i][j];
                    sum += R[i][j];
                }
                ++j;
            }
            Q[i][i] = -sum;
            ++i;
        }
        this.genMatrix = Q;
        return Q;
    }

    public Matrix getMtjGenerator() {
        MtjSolver sol = this.steadyStateSolver instanceof MtjSolver ? (MtjSolver)this.steadyStateSolver : new MtjSolver(this);
        return sol.getGenerator();
    }

    public double[] getSteadyState() throws NotUnichainException {
        if (!this.generated) {
            this.generate();
        }
        if (this.thePi != null) {
            return this.thePi;
        }
        this.thePi = this.getSteadyStateSolver().getSteadyState();
        return this.thePi;
    }

    public Class getStateClass() {
        return this.i0.getClass();
    }

    public Class getEventClass() {
        return this.theEvents.length > 0 ? this.theEvents[0].getClass() : Event.class;
    }

    public boolean addMOP(String mopName) {
        return this.mopsNames.add(mopName);
    }

    public void clearMOPs() {
        this.mopsNames = new ArrayList<String>();
    }

    public void setMOPs(String[] mopNames) {
        int i = 0;
        while (i < mopNames.length) {
            this.addMOP(mopNames[i]);
            ++i;
        }
    }

    public String[] getMOPNames() {
        return this.mopsNames.toArray(new String[1]);
    }

    public double[] getMOPsAvg() throws NotUnichainException {
        return this.getMOPsMoment(1);
    }

    public double[] getMOPsMoment(int m) throws NotUnichainException {
        this.debug(1, "Computing MOPs moment " + m);
        if (!this.generated) {
            this.generate();
        }
        String[] mopNames = this.getMOPNames();
        int M = mopNames.length;
        double[] result = new double[M];
        int idx = 0;
        while (idx < M) {
            result[idx] = this.getMOPsMoment(idx, m);
            ++idx;
        }
        return result;
    }

    public int getMOPIndex(String name) {
        return this.mopsNames.indexOf(name);
    }

    public int numMOPs() {
        return this.mopsNames.size();
    }

    public double getMOPsAvg(int mopNum) throws NotUnichainException {
        return this.getMOPsMoment(mopNum, 1);
    }

    public double getMOPsAvg(String mopName) throws NotUnichainException {
        return this.getMOPsMoment(mopName, 1);
    }

    public double getMOPsMoment(int mopNum, int m) throws NotUnichainException {
        this.thePi = this.getSteadyState();
        this.theStates = this.getStates();
        String mopName = this.getMOPNames(mopNum);
        this.debug(1, "Computing moment " + m + " for MOP " + mopName);
        double sum = 0.0;
        int i = 0;
        for (State s : this.theStates) {
            double mopVal = s.getMOP(mopNum);
            if (m == 1) {
                sum += this.thePi[i++] * mopVal;
                continue;
            }
            if (m == 2) {
                sum += this.thePi[i++] * mopVal * mopVal;
                continue;
            }
            sum += this.thePi[i++] * Math.pow(mopVal, m);
        }
        return sum;
    }

    public double getMOPsMoment(String mopName, int m) throws NotUnichainException {
        int idx = this.getMOPIndex(mopName);
        return this.getMOPsMoment(idx, m);
    }

    public String getMOPNames(int mopNum) {
        return this.mopsNames.get(mopNum).toString();
    }

    public String MOPsToString() {
        StringWriter stw = new StringWriter();
        this.printMOPs(new PrintWriter(stw));
        return stw.toString();
    }

    public String MOPsToString(int width, int decimals) {
        StringWriter stw = new StringWriter();
        this.printMOPs(new PrintWriter(stw), width, decimals);
        return stw.toString();
    }

    public String eventsRatesToString() {
        return this.eventRatesToString(10, 5);
    }

    public String eventRatesToString(int width, int decimals) {
        StringWriter stw = new StringWriter();
        this.printEventsRates(new PrintWriter(stw), width, decimals);
        return stw.toString();
    }

    public void printEventsRates(PrintWriter out) {
        this.printEventsRates(out, 10, 5);
    }

    public void printEventsRates(PrintWriter out, int width, int decimals) {
        this.debug(1, "Printing Rates...");
        out.println("EVENTS OCCURANCE RATES");
        out.println();
        try {
            double[] means = this.getEventsRates();
            int M = means.length;
            String[] names = new String[M];
            int nameWidth = 0;
            int k = 0;
            while (k < M) {
                names[k] = ((Event)this.theEvents[k]).toString();
                nameWidth = Math.max(nameWidth, names[k].length());
                ++k;
            }
            nameWidth = Math.max(nameWidth + 1, 7);
            out.println(String.valueOf(this.pad("NAME", nameWidth, false)) + this.pad("MEAN RATE", width));
            k = 0;
            while (k < M) {
                out.println(String.valueOf(this.pad(names[k], nameWidth, false)) + this.pad(means[k], width, decimals));
                ++k;
            }
        }
        catch (NotUnichainException e) {
            out.println(e);
        }
        out.flush();
    }

    public String[] getEventNames() {
        int numE = this.theEvents.length;
        String[] names = new String[numE];
        int i = 1;
        while (i < numE) {
            names[i] = ((Event)this.theEvents[i]).toString();
            ++i;
        }
        return names;
    }

    public double getEventRate(int eNum) throws NotUnichainException {
        E e = this.theEvents[eNum];
        this.debug(1, "Computing Events Rate for Event " + e);
        double sumRate = 0.0;
        double[] pi = this.getSteadyState();
        this.cnt = 0;
        for (State s : this.theStates) {
            Transitions<State> trans = this.activeTransitions(s, this.theEvents[eNum]);
            for (Transition transition : trans) {
                sumRate += pi[this.cnt] * transition.getRate();
            }
            ++this.cnt;
        }
        return sumRate;
    }

    public double[] getEventsRates() throws NotUnichainException {
        this.debug(1, "Computing Events Rates");
        int M = this.theEvents.length;
        double[] result = new double[M];
        int k = 0;
        while (k < this.theEvents.length) {
            result[k] = this.getEventRate(k);
            ++k;
        }
        return result;
    }

    public final void printMOPs() {
        this.printMOPs(new PrintWriter(System.out, true));
    }

    public final void printMOPs(PrintWriter out) {
        this.printMOPs(out, 10, 5);
    }

    public int printMOPs(PrintWriter out, int width, int decimals) {
        if (this.numMOPs() == 0) {
            return 0;
        }
        out.println("MEASURES OF PERFORMANCE");
        out.println();
        int namesWidth = 0;
        try {
            double[] means = this.getMOPsMoment(1);
            double[] mom2 = this.getMOPsMoment(2);
            String[] names = this.getMOPNames();
            int M = means.length;
            int k = 0;
            while (k < M) {
                namesWidth = Math.max(namesWidth, names[k].length());
                ++k;
            }
            out.println(String.valueOf(this.pad("NAME", ++namesWidth, false)) + this.pad("MEAN", width) + this.pad("SDEV", width) + "\n");
            k = 0;
            while (k < M) {
                double mean = means[k];
                double dif = mom2[k] - mean * mean;
                if (dif < 0.0 && dif >= -1.0E-4) {
                    dif = 0.0;
                }
                assert (dif >= 0.0);
                double sdev = Math.sqrt(dif);
                out.println(String.valueOf(this.pad(names[k], namesWidth, false)) + this.pad(means[k], width, decimals) + this.pad(sdev, width, decimals));
                ++k;
            }
        }
        catch (NotUnichainException e) {
            out.print(e);
        }
        out.flush();
        return namesWidth;
    }

    @Override
    public String toString() {
        return this.label();
    }

    public String allToString() {
        StringWriter stw = new StringWriter();
        this.printAll(new PrintWriter(stw));
        return stw.toString();
    }

    public void printAll() {
        PrintWriter pw = new PrintWriter(System.out, true);
        this.printAll(pw);
    }

    public void printAll(PrintWriter out) {
        int N = this.getNumStates();
        out.println(String.valueOf(this.description()) + "\n");
        out.println("System has " + N + " States.\n");
        if (N < 100) {
            this.printStates(out);
            this.printDenseMatrix(out);
        }
        out.println();
        this.printMOPs(out);
        out.println();
        this.printEventsRates(out);
        out.println();
    }

    public String denseMatrixToString() {
        StringWriter stw = new StringWriter();
        this.printDenseMatrix(new PrintWriter(stw));
        return stw.toString();
    }

    public String denseMatrixToString(int width, int rateDecimals, boolean printZeros, boolean useGenerator) {
        StringWriter stw = new StringWriter();
        this.printDenseMatrix(new PrintWriter(stw), width, rateDecimals, printZeros, useGenerator);
        return stw.toString();
    }

    public void printDenseMatrix(PrintWriter out) {
        this.printDenseMatrix(out, 10, 4, false, false);
    }

    public void printDenseMatrix(PrintWriter out, int width, int rateDecimals, boolean printZeros, boolean useGenerator) {
        this.printDenseMatrix(out, width, rateDecimals, printZeros, useGenerator, null);
    }

    protected void printDenseMatrix(PrintWriter out, int width, int rateDecimals, boolean printZeros, boolean useGenerator, int[] idx) {
        double[][] theMat;
        this.setStatus(Status.WRITING);
        if (useGenerator) {
            out.println("GENERATOR MATRIX: ");
            theMat = this.getGenerator();
        } else {
            out.println("RATES MATRIX: ");
            theMat = this.getRates();
        }
        StatesSet<S> stts = this.getStates();
        int n = this.getNumStates();
        if (idx == null) {
            int[] nArray = new int[1];
            idx = nArray;
            nArray[0] = n + 1;
        }
        int w = this.statesLableMaxWidth(width);
        out.print(String.valueOf(this.pad(" ", w)) + this.vLine());
        Iterator itr = stts.iterator();
        int i = 0;
        int k1 = 0;
        while (i < n) {
            out.print(this.pad(((State)itr.next()).toString(), w));
            if (i == idx[k1]) {
                out.print(this.vLine());
                ++k1;
            }
            ++i;
        }
        String hLine = "\n" + this.hLine(w * (n + 1) + idx.length);
        out.print(hLine);
        itr = stts.iterator();
        k1 = 0;
        int i2 = 0;
        while (i2 < n) {
            this.cnt = i2;
            out.println();
            out.print(String.valueOf(this.pad(((State)itr.next()).toString(), w)) + this.vLine());
            int j = 0;
            int k2 = 0;
            while (j < n) {
                if (theMat[i2][j] == 0.0 && !printZeros) {
                    out.print(this.pad("", w));
                } else {
                    out.print(this.pad(theMat[i2][j], w, rateDecimals));
                }
                if (j == idx[k2]) {
                    out.print(this.vLine());
                    ++k2;
                }
                ++j;
            }
            if (i2 == idx[k1]) {
                out.print(hLine);
                ++k1;
            }
            ++i2;
        }
        out.flush();
        this.setStatus(Status.GENERATED);
    }

    public String statesToString() {
        StringWriter stw = new StringWriter();
        this.printStates(new PrintWriter(stw), 10, 5);
        return stw.toString();
    }

    public void printStates(PrintWriter out) {
        this.printStates(out, 10, 5);
    }

    public void printStates(PrintWriter out, int width, int probDecimals) {
        this.out = out;
        StatesSet<S> stts = this.getStates();
        this.debug(1, "Printing States...");
        int maxL = 9;
        try {
            double[] pi = this.getSteadyState();
            for (State s : stts) {
                maxL = Math.max(maxL, s.label().length());
            }
            int w = maxL + 3;
            int w2 = width + 3;
            out.println(String.valueOf(this.pad("", w)) + this.pad("EQUILIBRUM", w2, false));
            out.println(String.valueOf(this.pad("STATE", w, false)) + this.pad("PROBAB.", w2, false) + "DESCRIPTION");
            out.println();
            int i = 0;
            for (State s : stts) {
                out.println(String.valueOf(this.pad(s.label(), w, false)) + this.pad(pi[i++], w, probDecimals, false) + (s.description() != "" ? s.description() : ""));
            }
        }
        catch (NotUnichainException e) {
            out.println(e);
        }
        out.println();
    }

    @Override
    public abstract String description();

    protected String pad(String s, int w) {
        return this.pad(s, w, true);
    }

    protected String pad(String s, int w, boolean right) {
        String stg = "";
        int padding = Math.max(1, w - s.length());
        int k = 0;
        while (k < padding) {
            stg = String.valueOf(stg) + ' ';
            ++k;
        }
        return right ? String.valueOf(stg) + s : String.valueOf(s) + stg;
    }

    protected String pad(double v, int w) {
        return this.pad(v, w, true);
    }

    protected String pad(double v, int w, boolean right) {
        int d = 3;
        return this.pad(v, w, d, right);
    }

    protected String pad(double v, int w, int d) {
        return this.pad(v, w, d, true);
    }

    protected String pad(double v, int w, int d, boolean right) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(d);
        format.setMinimumFractionDigits(d);
        format.setGroupingUsed(false);
        String s = format.format(v);
        return this.pad(s, w, right);
    }

    public int statesLableMaxWidth(int width) {
        StatesSet<S> stts = this.getStates();
        int maxL = 0;
        for (State s : stts) {
            maxL = Math.max(maxL, s.label().length());
        }
        return Math.max(maxL + 1, width);
    }

    protected String hLine(int length) {
        StringBuilder bl = new StringBuilder();
        int j = 0;
        while (j < length) {
            bl.append("\u2014");
            ++j;
        }
        return bl.toString();
    }

    protected String vLine() {
        return "|";
    }

    public void setDebugReporter(DebugReporter reporter) {
        this.reporter = reporter;
    }

    public DebugReporter getDebugReporter() {
        return this.reporter;
    }

    public void debug(int level, String s) {
        this.reporter.debug(level, s, true);
    }

    public void debug(int level, String s, boolean newline) {
        this.reporter.debug(level, s, newline);
    }

    public void debug(int level, String s, boolean newline, boolean indent) {
        this.reporter.debug(level, s, newline, indent);
    }

    public int getDebugLevel() {
        return this.reporter.getCurLevel();
    }

    public void setDebugLevel(int level) {
        this.reporter.setCurLevel(level);
    }

    public void loadGUI() {
        if (this.theGUI == null) {
            this.debug(1, "Loading Graphic User Interface...");
            this.theGUI = new MarkovGUI(this);
        }
    }

    public void showGUI() {
        if (this.theGUI == null) {
            this.loadGUI();
        }
        if (this.theGUI != null) {
            this.theGUI.setVisible(true);
        }
    }

    public void hideGUI() {
        if (this.theGUI != null) {
            this.theGUI.setVisible(false);
        }
    }

    public void killGUI() {
        if (this.theGUI != null) {
            this.theGUI.setVisible(false);
            this.theGUI = null;
        }
    }

    public boolean canGo() {
        return this.theGUI == null ? true : this.theGUI.isAllowedToRun();
    }

    public void pause() {
        this.setStatus(Status.SUSPENDED);
    }

    public synchronized void go() {
        this.setStatus(Status.RUNNING);
        this.generate();
    }

    public synchronized void goStep() {
        if (!this.uncheckedStates.isEmpty() && (long)this.cnt < this.maxStates) {
            this.setStatus(Status.RUNNING);
            this.generateStep();
        }
        this.setEndStatus();
    }

    public Status getStatus() {
        return this._status;
    }

    public long getProgress() {
        return this.cnt;
    }

    public String getStatusMsg() {
        String stg = "";
        switch (this._status) {
            case IDLE: {
                stg = "Model has not been generated. ";
                break;
            }
            case RUNNING: {
                stg = "Model is running. ";
                break;
            }
            case SUSPENDED: {
                stg = "Model is suspended. ";
                break;
            }
            case ERROR: {
                stg = "Model generation caused an ERROR. ";
                break;
            }
            case GENERATED: {
                stg = "Model was succesfully generated. It has " + this.getNumStates() + " states.";
                break;
            }
            case WRITING: {
                stg = String.valueOf(stg) + "Writing information";
            }
        }
        return stg;
    }

    private void setStatus(Status status) {
        this._status = status;
        if (this.theGUI != null) {
            this.theGUI.updateStatus();
        }
    }

    public long getMaxStates() {
        return this.maxStates;
    }

    public void setMaxStates(long num) {
        this.maxStates = num;
    }

    protected final SteadyStateSolver getDefaultSteadyStateSolver() {
        if (this.defaultSteadyStateSolver == null) {
            this.defaultSteadyStateSolver = new MtjSolver(this);
        }
        return this.defaultSteadyStateSolver;
    }

    public SteadyStateSolver getSteadyStateSolver() {
        if (this.steadyStateSolver == null) {
            this.steadyStateSolver = this.getDefaultSteadyStateSolver();
        }
        return this.steadyStateSolver;
    }

    public void setSteadyStateSolver(SteadyStateSolver steadyStateSolver) {
        this.steadyStateSolver = steadyStateSolver;
        this.resetResults();
        this.debug(1, "New steady state solver set: " + steadyStateSolver);
    }

    protected TransientSolver getDefaultTransientSolver() {
        if (this.defaultTransientSolver == null) {
            this.defaultTransientSolver = new JamaTransientSolver(this);
        }
        return this.transientSolver;
    }

    public TransientSolver getTransientSolver() {
        if (this.transientSolver == null) {
            this.transientSolver = this.getDefaultTransientSolver();
        }
        return this.transientSolver;
    }

    public void setTransientSolver(TransientSolver transientSolver) {
        this.transientSolver = transientSolver;
        this.resetResults();
        this.debug(1, "New transient solver set: " + transientSolver);
    }

    @Override
    public String label() {
        if (this.name == "") {
            this.name = this.getClass().getSimpleName();
        }
        return this.name;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.debug(1, "Model " + this.label() + " unloaded from memory.");
    }

    public static enum Status {
        IDLE,
        RUNNING,
        GENERATED,
        SUSPENDED,
        WRITING,
        ERROR,
        NoModel;

    }
}

