/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import examples.jmarkov.Kanban;
import jmarkov.Utils;
import jmarkov.basic.exceptions.NotUnichainException;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class KanbanTest
extends TestCase {
    private Kanban kaby = new Kanban();

    public static void main(String[] args) {
        TestRunner.run(KanbanTest.class);
    }

    public KanbanTest(String name) {
        super(name);
        this.kaby.setDebugLevel(0);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public final void testGenerate() {
        this.kaby.generate();
        KanbanTest.assertTrue((boolean)this.kaby.isGenerated());
    }

    public final void testGetMOPsAvg() throws Exception {
        double[] mops = this.kaby.getMOPsAvg();
        double[] expMops = new double[]{0.7003166576899312, 0.7003166613086502, 0.7003166718329953, 0.6714510596567259, 0.6634469869009703, 1.6282322852477127, 0.6362363535199593};
        Utils.assertArrayEquals("Error in MOPS", expMops, mops, 1.0E-4);
    }

    public final void testGetRates() throws NotUnichainException {
        double[] ratesAvg = this.kaby.getEventsRates();
        double[] expRates = new double[]{1.4006333153798625, 1.4006333226173004, 1.4006333436659906};
        Utils.assertArrayEquals("Error in rates.", expRates, ratesAvg, 1.0E-4);
    }
}

