/*
 * Decompiled with CFR 0.152.
 */
package examples.jphase;

import examples.jphase.RealSystemEvent;
import examples.jphase.RealSystemState;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jphase.ContPhaseVar;
import jphase.fit.MomentsECCompleteFit;
import no.uib.cipr.matrix.Matrix;

public class PhaseSystem
extends SimpleMarkovProcess<RealSystemState, RealSystemEvent> {
    double lambda;
    int Max;
    ContPhaseVar[] Distributions;
    static final int ARRIVAL = 1;
    static final int DEPARTURE = 2;
    static final int PHASECHANGE = 3;

    public PhaseSystem(ContPhaseVar[] Distributions, double lambda, int Max) {
        super(new RealSystemState(), RealSystemEvent.getAllEvents());
        this.lambda = lambda;
        this.Max = Max;
        this.Distributions = Distributions;
    }

    @Override
    public boolean active(RealSystemState i, RealSystemEvent e) {
        boolean result = false;
        switch (e.type) {
            case 1: {
                if (i.getQ1Size() + i.getQ2Size() >= this.Max) break;
                result = true;
                break;
            }
            case 2: {
                if (i.getProp(e.server) == 0) break;
                result = true;
                break;
            }
            case 3: {
                if (i.getProp(e.server) == 0) break;
                result = true;
            }
        }
        return result;
    }

    @Override
    public States<RealSystemState> dests(RealSystemState i, RealSystemEvent e) {
        StatesSet<RealSystemState> set = new StatesSet<RealSystemState>();
        int[] props = new int[2];
        double[] alpha1 = this.Distributions[0].getVectorArray();
        double[] alpha2 = this.Distributions[1].getVectorArray();
        int Q1 = i.getQ1Size();
        int Q2 = i.getQ2Size();
        int k = 0;
        while (k < 2) {
            props[k] = i.getProp(k);
            ++k;
        }
        switch (e.type) {
            case 1: {
                if (i.getProp(0) == 0) {
                    k = 1;
                    while (k <= this.Distributions[0].getNumPhases()) {
                        if (alpha1[k - 1] > 0.0) {
                            props[0] = k;
                            set.add(new RealSystemState(props, Q1, Q2));
                        }
                        ++k;
                    }
                }
                if (i.getProp(0) == 0) break;
                set.add(new RealSystemState(props, ++Q1, Q2));
                break;
            }
            case 2: {
                if (e.server == 0) {
                    if (i.getQ1Size() == 0 && i.getProp(1) == 0) {
                        props[e.server] = 0;
                        k = 1;
                        while (k <= this.Distributions[1].getNumPhases()) {
                            if (alpha2[k - 1] > 0.0) {
                                props[1] = k;
                                set.add(new RealSystemState(props, Q1, Q2));
                            }
                            ++k;
                        }
                    }
                    if (i.getQ1Size() == 0 && i.getProp(1) != 0) {
                        props[e.server] = 0;
                        set.add(new RealSystemState(props, Q1, ++Q2));
                    }
                    if (i.getQ1Size() != 0 && i.getProp(1) == 0) {
                        --Q1;
                        k = 1;
                        while (k <= this.Distributions[0].getNumPhases()) {
                            int u = 1;
                            while (u <= this.Distributions[1].getNumPhases()) {
                                if (alpha1[k - 1] > 0.0 && alpha2[u - 1] > 0.0) {
                                    props[0] = k;
                                    props[1] = u;
                                    set.add(new RealSystemState(props, Q1, Q2));
                                }
                                ++u;
                            }
                            ++k;
                        }
                    }
                    if (i.getQ1Size() == 0 || i.getProp(1) == 0) break;
                    --Q1;
                    ++Q2;
                    k = 1;
                    while (k <= this.Distributions[0].getNumPhases()) {
                        if (alpha1[k - 1] > 0.0) {
                            props[0] = k;
                            set.add(new RealSystemState(props, Q1, Q2));
                        }
                        ++k;
                    }
                } else {
                    if (i.getQ2Size() == 0) {
                        props[e.server] = 0;
                        set.add(new RealSystemState(props, Q1, Q2));
                        break;
                    }
                    --Q2;
                    k = 1;
                    while (k <= this.Distributions[1].getNumPhases()) {
                        if (alpha2[k - 1] > 0.0) {
                            props[1] = k;
                            set.add(new RealSystemState(props, Q1, Q2));
                        }
                        ++k;
                    }
                }
                break;
            }
            case 3: {
                int aux = props[e.server];
                int k2 = 1;
                while (k2 <= this.Distributions[e.server].getNumPhases()) {
                    if (k2 != aux) {
                        props[e.server] = k2;
                        set.add(new RealSystemState(props, Q1, Q2));
                    }
                    ++k2;
                }
                break;
            }
        }
        return set;
    }

    @Override
    public double rate(RealSystemState i, RealSystemState j, RealSystemEvent e) {
        double rate = 0.0;
        Matrix A = this.Distributions[e.server].getMatrix();
        switch (e.type) {
            case 1: {
                double[] prob = this.Distributions[e.server].getVectorArray();
                if (i.getProp(0) == 0) {
                    rate = this.lambda * prob[j.getProp(0) - 1];
                    break;
                }
                rate = this.lambda;
                break;
            }
            case 2: {
                double[] a = this.Distributions[e.server].getMat0Array();
                rate = a[i.getProp(e.server) - 1];
                break;
            }
            case 3: {
                rate = A.get(i.getProp(e.server) - 1, j.getProp(e.server) - 1);
            }
        }
        return rate;
    }

    @Override
    public String description() {
        return "Real system with phase distributions";
    }

    public static void main(String[] s) {
        double[] data1 = new double[]{0.28, 0.19, 0.19, 0.31, 0.26, 0.24, 0.34, 0.18, 0.12, 0.26, 0.13, 0.27, 0.35, 0.2, 0.27, 0.55, 0.19, 0.19, 0.08, 1.03, 0.22, 0.14, 0.38, 0.25, 0.15, 0.17, 0.24, 0.11, 0.11, 0.17, 0.13, 0.3, 0.15, 0.2, 2.09, 0.21, 0.28, 0.15, 0.22, 0.21, 0.18, 0.38, 0.14, 0.21, 0.07, 0.11, 0.35, 0.07, 0.25, 0.3, 0.21, 0.18, 0.16, 0.12, 0.18, 0.28, 0.14, 0.25, 0.33, 0.15, 0.45, 0.13, 0.37, 0.27, 0.26, 0.17, 0.15, 0.43, 0.22, 0.33, 0.41, 0.31, 0.23, 0.15, 0.31};
        double[] data2 = new double[]{0.29, 0.23, 0.23, 0.04, 0.04, 0.19, 0.08, 0.03, 0.03, 0.04, 0.1, 0.08, 0.08, 0.11, 0.21, 0.08, 0.14, 1.03, 0.08, 0.52, 0.59, 0.1, 0.1, 0.2, 0.22, 0.29, 0.11, 0.32, 0.1, 0.08, 0.05, 0.06, 0.19, 0.06, 0.11, 0.07, 0.09, 0.06, 0.21, 0.11, 0.04, 0.18, 0.16, 0.09, 0.06, 0.11, 0.55, 0.08, 0.12, 0.04, 0.12, 0.1, 0.14, 0.11, 0.09, 0.07, 0.13, 0.11, 0.57, 0.05, 0.07, 0.08, 0.25, 0.03};
        MomentsECCompleteFit fitter1 = new MomentsECCompleteFit(data1);
        MomentsECCompleteFit fitter2 = new MomentsECCompleteFit(data2);
        ContPhaseVar Servicios1 = fitter1.fit();
        ContPhaseVar Servicios2 = fitter2.fit();
        ContPhaseVar[] Distributions = new ContPhaseVar[]{Servicios1, Servicios2};
        double lambda = 2.63;
        int Max = 11;
        PhaseSystem TheModel = new PhaseSystem(Distributions, lambda, Max);
        TheModel.printAll();
        TheModel.showGUI();
    }
}

