/*
 * Decompiled with CFR 0.152.
 */
package examples.jphase;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jphase.ContPhaseVar;
import jphase.DenseContPhaseVar;
import jphase.fit.EMHyperErlangFit;
import jphase.fit.MomentsACPHFit;
import jphase.generator.NeutsContPHGenerator;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;

public class BasicExamples {
    public static void main(String[] args) {
        BasicExamples myExample = new BasicExamples();
        myExample.example0();
        myExample.example1();
        myExample.example2();
        myExample.example3();
        myExample.example4();
        myExample.example5();
        myExample.example6();
    }

    private void example0() {
        System.out.println("\nEXAMPLE 0");
        DenseContPhaseVar v1 = DenseContPhaseVar.expo(3.0);
        DenseContPhaseVar v2 = DenseContPhaseVar.Erlang(1.5, 2);
        ContPhaseVar v3 = v1.max(v2);
        System.out.println("P( v3 <= 2.0 ):\t" + v3.cdf(2.0));
    }

    private void example1() {
        System.out.println("\nEXAMPLE 1");
        DenseContPhaseVar v1 = DenseContPhaseVar.Erlang(0.8, 3);
        DenseContPhaseVar v2 = DenseContPhaseVar.Erlang(1.5, 2);
        ContPhaseVar v3 = v1.sum(v2);
        System.out.println("v3:\n" + v3.toString());
    }

    private void example2() {
        System.out.println("\nEXAMPLE 2");
        DenseMatrix A = new DenseMatrix((double[][])new double[][]{{-4.0, 2.0, 1.0}, {1.0, -3.0, 1.0}, {2.0, 1.0, -5.0}});
        DenseVector alpha = new DenseVector(new double[]{0.1, 0.2, 0.2});
        DenseContPhaseVar v1 = new DenseContPhaseVar(alpha, A);
        double rho = 0.5;
        ContPhaseVar v2 = v1.waitingQ(rho);
        System.out.println("v2:\n" + ((Object)v2).toString());
    }

    private void example3() {
        System.out.println("\nEXAMPLE 3");
        double[] data = this.readTextFile("examples/jphase/W2.txt");
        EMHyperErlangFit fitter = new EMHyperErlangFit(data);
        ContPhaseVar v1 = fitter.fit(4);
        if (v1 != null) {
            System.out.println("v1:\n" + v1.toString());
            System.out.println("logLH:\t" + fitter.getLogLikelihood());
        }
    }

    private void example4() {
        System.out.println("\nEXAMPLE 4");
        MomentsACPHFit fitter = new MomentsACPHFit(2.0, 6.0, 25.0);
        ContPhaseVar v1 = fitter.fit();
        System.out.println("v1:\n" + v1.toString());
        System.out.println("m1:\t" + v1.moment(1));
        System.out.println("m2:\t" + v1.moment(2));
        System.out.println("m3:\t" + v1.moment(3));
    }

    private void example5() {
        System.out.println("\nEXAMPLE 5");
        DenseMatrix A = new DenseMatrix((double[][])new double[][]{{-4.0, 2.0, 1.0}, {1.0, -3.0, 1.0}, {2.0, 1.0, -5.0}});
        DenseVector alpha = new DenseVector(new double[]{0.3, 0.3, 0.4});
        DenseContPhaseVar v1 = new DenseContPhaseVar(alpha, A);
        NeutsContPHGenerator gen = new NeutsContPHGenerator(v1);
        double[] variates = new double[10];
        variates = gen.getRandom(10);
        int i = 0;
        while (i < 10) {
            System.out.println("var[" + i + "]:\t" + variates[i]);
            ++i;
        }
    }

    private void example6() {
        double[] lambdas = new double[]{3.0E-4, 1.0, 2.0};
        double[] alpha = new double[]{0.5, 0.5, 0.0};
        DenseContPhaseVar v1 = DenseContPhaseVar.HyperExpo(lambdas, alpha);
        ContPhaseVar v2 = v1.copy();
        int i = 0;
        while (i < 1000) {
            System.out.println(v2.expectedValue());
            v2 = v2.eqResidualTime();
            ++i;
        }
        System.out.println("v2:\n" + v2.toString());
    }

    private double[] readTextFile(String fileName) {
        ArrayList<Double> data = new ArrayList<Double>();
        try {
            FileReader archivo = new FileReader(fileName);
            BufferedReader entrada = new BufferedReader(archivo);
            System.out.println("Data file found");
            while (entrada.ready()) {
                String s = entrada.readLine();
                StringTokenizer str = new StringTokenizer(s);
                while (str.countTokens() == 0) {
                    s = entrada.readLine();
                    str = new StringTokenizer(s);
                }
                if (str.countTokens() != 1) {
                    throw new Exception();
                }
                data.add(new Double(Double.parseDouble(str.nextToken())));
            }
            entrada.close();
        }
        catch (Exception e) {
            System.out.println("File could not be read");
            return null;
        }
        double[] datos = new double[data.size()];
        int i = 0;
        while (i < data.size()) {
            datos[i] = (Double)data.get(i);
            ++i;
        }
        return datos;
    }
}

