/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import examples.jmdp.InvLevel;
import examples.jmdp.Order;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.DecisionRule;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.solvers.ProbabilitySolver;

public class ProbsExample
extends DTMDP<InvLevel, Order> {
    double[][] probs = new double[][]{{0.0, 0.4, 0.6}, {0.8, 0.2, 0.0}, {0.3, 0.5, 0.2}};

    public ProbsExample(States<InvLevel> initial) {
        super(initial);
    }

    @Override
    public double immediateCost(InvLevel i, Order a) {
        return 0.0;
    }

    @Override
    public double prob(InvLevel i, InvLevel j, Order a) {
        int iLevel = i.getLevel();
        int jLevel = j.getLevel();
        return this.probs[iLevel - 1][jLevel - 1];
    }

    @Override
    public States<InvLevel> reachable(InvLevel i, Order a) {
        StatesSet<InvLevel> set = new StatesSet<InvLevel>();
        int iLevel = i.getLevel();
        if (iLevel == 1) {
            set.add(new InvLevel(2));
            set.add(new InvLevel(3));
        } else if (iLevel == 2) {
            set.add(new InvLevel(1));
            set.add(new InvLevel(2));
        } else if (iLevel == 3) {
            set.add(new InvLevel(1));
            set.add(new InvLevel(2));
            set.add(new InvLevel(3));
        }
        return set;
    }

    @Override
    public Actions<Order> feasibleActions(InvLevel i) {
        return new ActionsSet<Order>(new Order(0));
    }

    public static void main(String[] args) {
        StatesSet<InvLevel> set = new StatesSet<InvLevel>(new InvLevel(1));
        ProbsExample prob = new ProbsExample((States<InvLevel>)set);
        prob.printSolution();
        try {
            DecisionRule dr = prob.getOptimalPolicy().getDecisionRule();
            ProbabilitySolver<InvLevel, Order> solver = new ProbabilitySolver<InvLevel, Order>(prob, dr);
            solver.solve();
            solver.setGaussSeidel(true);
            System.out.println("Gauss");
            solver.solve();
        }
        catch (SolverException e) {
            e.printStackTrace();
        }
    }
}

