/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import examples.jmdp.PendingOrders;
import examples.jmdp.ProcessAction;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.ValueFunction;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.DTMDP;

public class OrderProcessing
extends DTMDP<PendingOrders, ProcessAction> {
    double setupCost = 0.0;
    double unfilledOrderCost = 0.0;
    int maxOrders = 0;
    double theta = 0.0;
    double[] demandProbability;
    double[] demandCDF;
    ProcessAction all = new ProcessAction("Process all orders");
    ProcessAction none = new ProcessAction("Process no orders");
    ProcessAction[] vec = new ProcessAction[]{this.all, this.none};
    Actions<ProcessAction> actions = new ActionsSet<ProcessAction[]>(this.vec);

    public OrderProcessing(int initialPendingOrders, double setupCost, double unfilledOrderCost, int MaxOrders, double theta) {
        super(OrderProcessing.initialize(initialPendingOrders));
        this.setupCost = setupCost;
        this.unfilledOrderCost = unfilledOrderCost;
        this.maxOrders = MaxOrders;
        this.theta = theta;
        this.initializeProbabilities();
    }

    private void initializeProbabilities() {
        double p;
        this.demandProbability = new double[this.maxOrders + 1];
        this.demandCDF = new double[this.maxOrders + 1];
        this.demandProbability[0] = p = Math.exp(-this.theta);
        this.demandCDF[0] = 1.0;
        int i = 1;
        while (i <= this.maxOrders) {
            this.demandCDF[i] = this.demandCDF[i - 1] - p;
            this.demandProbability[i] = p = p * this.theta / (double)i;
            ++i;
        }
    }

    void initStates() {
        StatesSet<PendingOrders> states = new StatesSet<PendingOrders>();
        int n = 0;
        while (n <= this.maxOrders) {
            states.add(new PendingOrders(n));
            ++n;
        }
        this.states = states;
    }

    @Override
    public States<PendingOrders> reachable(PendingOrders i, ProcessAction a) {
        int n;
        StatesSet<PendingOrders> st = new StatesSet<PendingOrders>();
        if (a == this.all) {
            n = 0;
            while (n < i.getOrders()) {
                st.add(new PendingOrders(n));
                ++n;
            }
        }
        n = i.getOrders();
        while (n <= this.maxOrders) {
            st.add(new PendingOrders(n));
            ++n;
        }
        return st;
    }

    @Override
    public double immediateCost(PendingOrders i, ProcessAction a) {
        if (a == this.all) {
            return this.setupCost;
        }
        return (double)i.getOrders() * this.unfilledOrderCost;
    }

    @Override
    public Actions<ProcessAction> feasibleActions(PendingOrders i) {
        if (i.getOrders() == 0) {
            return new ActionsSet<ProcessAction>(this.none);
        }
        if (i.getOrders() == this.maxOrders) {
            return new ActionsSet<ProcessAction>(this.all);
        }
        return this.actions;
    }

    @Override
    public double prob(PendingOrders i, PendingOrders j, ProcessAction a) {
        if (a == this.none) {
            if (j.getOrders() == this.maxOrders) {
                return this.demandCDF[this.maxOrders - i.getOrders()];
            }
            return this.demandProbability[j.getOrders() - i.getOrders()];
        }
        if (a == this.all) {
            if (j.getOrders() == this.maxOrders) {
                return this.demandCDF[this.maxOrders];
            }
            return this.demandProbability[j.getOrders()];
        }
        return 0.0;
    }

    public double computeMOPs(PendingOrders i, Measure m) {
        switch (m) {
            case AVERAGE_ORDER_LEVEL: {
                return i.getOrders();
            }
        }
        return 0.0;
    }

    public double averageOrders() throws SolverException {
        double queue = 0.0;
        ValueFunction probs = this.getSteadyStateProbabilities();
        Iterator it = probs.iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            queue += e.getValue() * this.computeMOPs((PendingOrders)e.getKey(), Measure.AVERAGE_ORDER_LEVEL);
        }
        return queue;
    }

    public static StatesSet<PendingOrders> initialize(int initPendingOrders) {
        PendingOrders initState = new PendingOrders(initPendingOrders);
        return new StatesSet<PendingOrders>(initState);
    }

    public static PendingOrders initialState(int initPendingOrders) {
        return new PendingOrders(initPendingOrders);
    }

    public static void main(String[] args) throws SolverException {
        double setupCost = 60.0;
        double unfilledOrderCost = 4.0;
        int MaxOrders = 15;
        double theta = 3.0;
        OrderProcessing problem = new OrderProcessing(0, setupCost, unfilledOrderCost, MaxOrders, theta);
        problem.solve();
        problem.getSolver().setPrintValueFunction(true);
        problem.printSolution();
        PrintWriter pw = new PrintWriter(System.out, true);
        ValueFunction probs = problem.getSteadyStateProbabilities();
        probs.print(pw, "%-12S", "%10.5f");
        System.out.printf("%-12.3f average orders", problem.averageOrders());
    }

    protected static enum Measure {
        AVERAGE_ORDER_LEVEL;

    }
}

