/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import examples.jmdp.LeadTimeState;
import examples.jmdp.Order;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.solvers.ValueIterationSolver;

public class LeadTimeStochasticDemand
extends DTMDP<LeadTimeState, Order> {
    int maxInventory = 0;
    int maxItemsPerOrder = 0;
    int maxBackorders;
    int leadTime;
    double K = 0.0;
    double cost;
    double price;
    double h = 0.0;
    double holdingCost;
    double[] demandProbability;
    double[] demandCumulativeProbability;
    double theta;
    double backOrderCost;
    ActionsSet<Order> actionsSet;
    StatesSet<LeadTimeState> statesSet;
    ActionsSet<Order> actions;

    public LeadTimeStochasticDemand(States<LeadTimeState> initSet, int maxInventory, int maxItemsPerOrder, int leadTime, int maxBackorders, double K, double cost, double price, double h, double holdingCost, double theta, double backOrderCost) {
        super(initSet);
        this.maxInventory = maxInventory;
        this.maxItemsPerOrder = maxItemsPerOrder;
        this.leadTime = leadTime;
        this.maxBackorders = maxBackorders;
        this.K = K;
        this.cost = cost;
        this.price = price;
        this.h = h;
        this.holdingCost = holdingCost;
        this.theta = theta;
        this.backOrderCost = backOrderCost;
        this.states = this.initializeStates();
        System.out.println("States generated");
        this.initializeActions();
        System.out.println("Actions generated");
        this.initializeProbabilities();
    }

    double fixedOrderCost(int totalOrderSize) {
        return totalOrderSize > 0 ? Math.ceil(totalOrderSize / this.maxItemsPerOrder) * this.K : 0.0;
    }

    double variableOrderCost(int itemOrderSize) {
        return this.cost * (double)itemOrderSize;
    }

    double lostOrderCost(int x) {
        int b = this.maxBackorders;
        double expectedBackorders = 0.0;
        int k = Math.max(x + 1, 0);
        while (k <= x + b) {
            expectedBackorders += (double)(k - x) * this.demandProbability[k];
            ++k;
        }
        double toReturn = this.backOrderCost * expectedBackorders;
        return toReturn;
    }

    private void initializeProbabilities() {
        double p;
        this.demandProbability = new double[this.maxBackorders + this.maxInventory + 1];
        this.demandCumulativeProbability = new double[this.maxBackorders + this.maxInventory + 1];
        double q = p = Math.exp(-this.theta);
        this.demandProbability[0] = p;
        this.demandCumulativeProbability[0] = 1.0;
        int i = 1;
        while (i <= this.maxBackorders + this.maxInventory) {
            p = p * this.theta / (double)i;
            this.demandCumulativeProbability[i] = 1.0 - q;
            q += p;
            this.demandProbability[i] = p;
            ++i;
        }
    }

    void initializeActions() {
        this.actionsSet = new ActionsSet();
        int size = 0;
        while (size <= this.maxInventory + this.maxBackorders) {
            this.actionsSet.add(new Order(size));
            ++size;
        }
        this.actions = this.actionsSet;
    }

    StatesSet<LeadTimeState> initializeStates() {
        this.statesSet = new StatesSet();
        int inventory = -this.maxBackorders;
        while (inventory <= this.maxInventory) {
            int order = 0;
            while (order <= this.maxInventory - inventory) {
                if (order == 0) {
                    this.statesSet.add(new LeadTimeState(inventory, order, 0));
                } else {
                    int pendingStages = 0;
                    while (pendingStages <= this.leadTime) {
                        this.statesSet.add(new LeadTimeState(inventory, order, pendingStages));
                        ++pendingStages;
                    }
                }
                ++order;
            }
            ++inventory;
        }
        return new StatesSet<LeadTimeState>((States<LeadTimeState>)this.statesSet);
    }

    @Override
    public States<LeadTimeState> reachable(LeadTimeState i, Order a) {
        int orderSize = a.getSize();
        int level = i.getLevel();
        int pendingOrder = i.getOrder();
        int stagesToOrderArrival = i.getStages();
        StatesSet<LeadTimeState> toReturn = new StatesSet<LeadTimeState>();
        if (orderSize == 0) {
            if (pendingOrder > 0) {
                if (stagesToOrderArrival == 0) {
                    for (LeadTimeState s : this.states) {
                        if (s.getOrder() != 0 || s.getStages() != 0) continue;
                        toReturn.add(s);
                    }
                } else {
                    for (LeadTimeState s : this.states) {
                        if (s.getLevel() > level || s.getOrder() != pendingOrder || s.getStages() != stagesToOrderArrival - 1) continue;
                        toReturn.add(s);
                    }
                }
            } else {
                for (LeadTimeState s : this.states) {
                    if (s.getLevel() > level || s.getOrder() != 0 || s.getStages() != 0) continue;
                    toReturn.add(s);
                }
            }
        } else {
            for (LeadTimeState s : this.states) {
                if (s.getLevel() > level || s.getOrder() != orderSize || s.getStages() != this.leadTime) continue;
                toReturn.add(s);
            }
        }
        return toReturn;
    }

    @Override
    public double prob(LeadTimeState i, LeadTimeState j, Order a) {
        int iLevel = i.getLevel();
        int jLevel = j.getLevel();
        int inventoryCapacity = this.maxInventory - iLevel;
        int orderSize = a.getSize();
        if (inventoryCapacity >= orderSize && jLevel <= orderSize + iLevel) {
            int demand = orderSize + iLevel - jLevel;
            if (jLevel == -this.maxBackorders) {
                return this.demandCumulativeProbability[demand];
            }
            return this.demandProbability[demand];
        }
        return 0.0;
    }

    @Override
    public double immediateCost(LeadTimeState i, Order a) {
        int iLevel = i.getLevel();
        int orderSize = a.getSize();
        double totalCost = this.fixedOrderCost(a.getSize());
        totalCost += this.lostOrderCost(iLevel + orderSize);
        return totalCost += this.holdingCost * (double)Math.max(iLevel, 0);
    }

    @Override
    public Actions<Order> feasibleActions(LeadTimeState i) {
        int iLevel = i.getLevel();
        int pendingOrders = i.getOrder();
        ActionsSet<Order> toReturn = new ActionsSet<Order>();
        for (Order a : this.actions) {
            if (pendingOrders > 0 && a.getSize() == 0) {
                toReturn.add(a);
                break;
            }
            if (iLevel + a.getSize() > this.maxInventory) continue;
            toReturn.add(a);
        }
        return toReturn;
    }

    public static void main(String[] a) throws Exception {
        int maxInventory = 15;
        int maxItemsPerOrder = 6;
        int leadTime = 2;
        int maxBackorders = 5;
        double K = 500.0;
        double cost = 20000.0;
        double price = 23000.0;
        double h = Math.pow(1.3, 0.0) - 1.0;
        double holdingCost = h * cost;
        double theta = 4.0;
        double backOrderCost = 1000.0;
        StatesSet<LeadTimeState> initSet = new StatesSet<LeadTimeState>(new LeadTimeState(0, 0, 0));
        LeadTimeStochasticDemand pro = new LeadTimeStochasticDemand(initSet, maxInventory, maxItemsPerOrder, leadTime, maxBackorders, K, cost, price, h, holdingCost, theta, backOrderCost);
        ValueIterationSolver<LeadTimeState, Order> theSolver = new ValueIterationSolver<LeadTimeState, Order>(pro, 0.9);
        theSolver.useGaussSeidel(false);
        theSolver.setPrintValueFunction(true);
        theSolver.solve();
    }
}

