/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import examples.jmdp.InvLevel;
import examples.jmdp.Order;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.jmdp.FiniteMDP;

public class Inventory
extends FiniteMDP<InvLevel, Order> {
    int M;
    int lastStage;
    int K;
    double[] pr;
    double[] qr;
    double[] F;
    ActionsSet<Order> actions;
    StatesSet<InvLevel> states;

    double cost(int x) {
        return 2 * x;
    }

    double holding(int x) {
        return x;
    }

    double orderCost(int x) {
        return x > 0 ? (double)this.K + this.cost(x) : 0.0;
    }

    public Inventory(int lastStage, States<InvLevel> initSet, int M, int K, double[] pr, double[] qr, double[] F) {
        super(initSet, lastStage);
        this.M = M;
        this.lastStage = lastStage;
        this.K = K;
        this.pr = pr;
        this.qr = qr;
        this.F = F;
        this.initActions();
    }

    @Override
    public double prob(InvLevel i, InvLevel j, Order a, int t) {
        int iLevel = i.getLevel();
        int jLevel = j.getLevel();
        int orderSize = a.getSize();
        if (jLevel > 0 && jLevel <= orderSize + iLevel && orderSize + iLevel <= this.M) {
            return this.pr[orderSize + iLevel - jLevel];
        }
        if (orderSize + iLevel <= this.M && jLevel == 0) {
            return this.qr[orderSize + iLevel];
        }
        return 0.0;
    }

    @Override
    public double immediateCost(InvLevel i, Order a, int t) {
        int s = i.getLevel();
        int o = a.getSize();
        return -this.F[s + o] + this.orderCost(o) + this.holding(s + o);
    }

    @Override
    public double finalCost(InvLevel i) {
        return 0.0;
    }

    void initActions() {
        this.actions = new ActionsSet();
        int k = 0;
        while (k <= this.M) {
            this.actions.add(new Order(k));
            ++k;
        }
    }

    @Override
    public Actions<Order> feasibleActions(InvLevel i, int t) {
        ActionsSet<Order> actionSet = new ActionsSet<Order>();
        for (Order a : this.actions) {
            if (a.getSize() > this.M - i.getLevel()) continue;
            actionSet.add(a);
        }
        return actionSet;
    }

    @Override
    public States<InvLevel> reachable(InvLevel i, Order a, int t) {
        StatesSet<InvLevel> stSet = new StatesSet<InvLevel>();
        int n = 0;
        while (n <= i.getLevel() + a.getSize()) {
            stSet.add(new InvLevel(n));
            ++n;
        }
        return stSet;
    }

    public static void main(String[] a) throws Exception {
        int M = 3;
        int N = 3;
        int K = 4;
        double[] pr = new double[]{0.25, 0.5, 0.25, 0.0};
        double[] qr = new double[]{1.0, 0.75, 0.25, 0.0};
        double[] F = new double[]{0.0, 6.0, 8.0, 8.0};
        StatesSet<InvLevel> initSet = new StatesSet<InvLevel>(new InvLevel(0));
        Inventory pro = new Inventory(N, initSet, M, K, pr, qr, F);
        pro.solve();
        pro.printSolution();
    }
}

