/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import examples.jmdp.CowActions;
import examples.jmdp.CowQuantity;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.ValueFunction;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.FiniteDP;
import jmarkov.jmdp.solvers.FiniteSolver;

public class CowHerd
extends FiniteDP<CowQuantity, CowActions> {
    private double[] price = null;
    private int[] mxCows = null;
    private ActionsSet<CowActions> actions = new ActionsSet();

    public CowHerd(States<CowQuantity> initial, int horizon, double[] price, int[] mxCows) {
        super(initial, horizon);
        this.price = price;
        this.mxCows = mxCows;
        this.actions.add(CowActions.SELL);
        this.actions.add(CowActions.KEEP);
    }

    public CowHerd(int initialQuantity, int horizon, double[] price, int[] mxCows) {
        this(CowHerd.initStates(initialQuantity), horizon, price, mxCows);
    }

    private static States<CowQuantity> initStates(int quantity) {
        CowQuantity state = new CowQuantity(quantity);
        return new StatesSet<CowQuantity>(state);
    }

    public double getValue(int initQ) throws SolverException {
        ValueFunction<CowQuantity> vf = this.getOptimalValueFunction();
        CowQuantity state = new CowQuantity(initQ);
        return vf.get(state);
    }

    @Override
    public double immediateCost(CowQuantity i, CowActions a, int t) {
        if (a == CowActions.SELL) {
            return (double)(-i.cows) * this.price[t];
        }
        return 0.0;
    }

    @Override
    public double finalCost(CowQuantity i) {
        return (double)(-i.cows) * this.price[5];
    }

    @Override
    public CowQuantity destination(CowQuantity i, CowActions a, int t) {
        if (a == CowActions.KEEP) {
            int newCows = (int)Math.floor(1.5 * (double)i.cows);
            if (newCows <= this.mxCows[t + 1]) {
                return new CowQuantity(newCows);
            }
        } else if (a == CowActions.SELL) {
            return new CowQuantity(0);
        }
        return null;
    }

    @Override
    public Actions<CowActions> feasibleActions(CowQuantity st, int t) {
        if (st.cows == 0) {
            ActionsSet<CowActions> act = new ActionsSet<CowActions>();
            act.add(CowActions.KEEP);
            return act;
        }
        if ((int)Math.floor(1.5 * (double)st.cows) > this.mxCows[t + 1]) {
            ActionsSet<CowActions> act = new ActionsSet<CowActions>();
            act.add(CowActions.SELL);
            return act;
        }
        return this.actions;
    }

    public static void main(String[] a) throws SolverException {
        double[] price = new double[]{0.0, 10.0, 15.0, 25.0, 7.0, 10.0};
        int[] mxCows = new int[]{50, 75, 112, 168, 252, 378};
        CowQuantity initial = new CowQuantity(50);
        CowHerd prob = new CowHerd(50, 5, price, mxCows);
        FiniteSolver<CowQuantity, CowActions> theSolver = new FiniteSolver<CowQuantity, CowActions>(prob);
        theSolver.solve();
        System.out.println(theSolver.bestPolicy(initial));
    }
}

