/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import examples.jmdp.DemandEvent;
import examples.jmdp.InvLevel;
import examples.jmdp.Order;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.Events;
import jmarkov.basic.EventsSet;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.DTMDPEv;
import jmarkov.jmdp.solvers.ValueIterationSolver;

public class ControlProduccion
extends DTMDPEv<InvLevel, Order, DemandEvent> {
    private int maxInventory;
    private double fixedCost;
    double cost;
    double price;
    double holdingCost;
    double[] demPMF;
    double[] demCCDF;
    double[] demLoss1;
    double expDemand;
    Actions actions;

    public ControlProduccion(int maxInventory, double fixedCost, double cost, double price, double holdingCost, double interestRate, double demandMean) {
        super(new StatesSet<InvLevel>(new InvLevel(0)));
        this.maxInventory = maxInventory;
        this.fixedCost = fixedCost;
        this.cost = cost;
        this.price = price;
        this.holdingCost = holdingCost;
        this.expDemand = demandMean;
        this.demPMF = new double[maxInventory + 1];
        this.demCCDF = new double[maxInventory + 1];
        this.demLoss1 = new double[maxInventory + 1];
        this.init();
        this.setSolver(new ValueIterationSolver<InvLevel, Order>(this, interestRate));
    }

    double orderCost(int x) {
        return x > 0 ? this.fixedCost + this.cost * (double)x : 0.0;
    }

    double lostOrders(int x) {
        return this.expDemand * (this.demCCDF[x] - this.demPMF[x]) - (double)x * this.demCCDF[x];
    }

    private void initializeProbabilities() {
        double p;
        double q = p = Math.exp(-this.expDemand);
        this.demPMF[0] = p;
        this.demCCDF[0] = 1.0;
        this.demLoss1[0] = this.expDemand;
        int i = 1;
        while (i <= this.maxInventory) {
            p = p * this.expDemand / (double)i;
            this.demCCDF[i] = 1.0 - q;
            this.demPMF[i] = p;
            this.demLoss1[i] = (this.expDemand - (double)i) * (1.0 - (q += p)) + this.expDemand * p;
            ++i;
        }
    }

    @Override
    public States<InvLevel> reachable(InvLevel i, Order a, DemandEvent e) {
        StatesSet<InvLevel> stSet = new StatesSet<InvLevel>();
        if (e.getGreaterThan()) {
            stSet.add(new InvLevel(0));
        } else {
            stSet.add(new InvLevel(i.getLevel() + a.getSize() - e.getDemand()));
        }
        return stSet;
    }

    @Override
    public Events<DemandEvent> activeEvents(InvLevel i, Order a) {
        EventsSet<DemandEvent> eventSet = new EventsSet<DemandEvent>();
        eventSet.add(new DemandEvent(i.getLevel() + a.getSize(), true));
        int n = 0;
        while (n < i.getLevel() + a.getSize()) {
            eventSet.add(new DemandEvent(n, false));
            ++n;
        }
        return eventSet;
    }

    @Override
    public double prob(InvLevel i, InvLevel j, Order a, DemandEvent e) {
        return i.getLevel() + a.getSize() - e.getDemand() == j.getLevel() ? 1.0 : 0.0;
    }

    @Override
    public double prob(InvLevel i, DemandEvent e) {
        if (e.getGreaterThan()) {
            return this.demCCDF[e.getDemand()];
        }
        return this.demPMF[e.getDemand()];
    }

    @Override
    public double immediateCost(InvLevel i, Order a, DemandEvent e) {
        int iLevel = i.getLevel();
        int orderSize = a.getSize();
        int demand = e.getDemand();
        double cost = this.orderCost(orderSize) + this.holdingCost * (double)iLevel;
        return cost -= (double)demand * this.price;
    }

    void init() {
        Order[] acts = new Order[this.maxInventory + 1];
        InvLevel[] ssts = new InvLevel[this.maxInventory + 1];
        int k = 0;
        while (k <= this.maxInventory) {
            acts[k] = new Order(k);
            ssts[k] = new InvLevel(k);
            ++k;
        }
        this.states = new StatesSet<InvLevel[]>(ssts);
        this.actions = new ActionsSet<Order[]>(acts);
        this.initializeProbabilities();
    }

    @Override
    public Actions<Order> feasibleActions(InvLevel i) {
        int max = this.maxInventory - i.getLevel();
        Order[] vec = new Order[max + 1];
        int k = 0;
        while (k <= max) {
            vec[k] = new Order(k);
            ++k;
        }
        return new ActionsSet<Order[]>(vec);
    }

    public static void main(String[] a) throws SolverException {
        int M = 9;
        double K = 50.0;
        double cost = 400.0;
        double price = 1000.0;
        double holdingCost = 80.0;
        double discountFactor = 0.9;
        double demandMean = 4.0;
        ControlProduccion prob = new ControlProduccion(M, K, cost, price, holdingCost, discountFactor, demandMean);
        prob.getSolver().setPrintValueFunction(true);
        prob.solve();
        prob.printSolution();
    }
}

