/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import examples.jmdp.CTInventoryEvent;
import examples.jmdp.CTStockE;
import examples.jmdp.Order;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.Events;
import jmarkov.basic.EventsSet;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.CTMDPEv;
import jmarkov.jmdp.solvers.RelativeValueIterationSolver;

public class CTInventoryEvents
extends CTMDPEv<CTStockE, Order, CTInventoryEvent> {
    int maxCapacity;
    int truckSize;
    double K;
    double cost;
    double price;
    double holdingCost;
    double[] demandProbability;
    double[] demandCCDF;
    double[] demandLoss1;
    double demandMean;
    double leadTime;
    Actions actions;

    public CTInventoryEvents(States<CTStockE> initSet, int maxCapacity, int truckSize, double K, double cost, double price, double holdingCost, double demandRateA, double leadTime) {
        super(initSet);
        this.maxCapacity = maxCapacity;
        this.truckSize = truckSize;
        this.K = K;
        this.cost = cost;
        this.price = price;
        this.holdingCost = holdingCost;
        this.demandMean = demandRateA;
        this.leadTime = leadTime;
        this.demandProbability = new double[maxCapacity + 1];
        this.demandCCDF = new double[maxCapacity + 1];
        this.demandLoss1 = new double[maxCapacity + 1];
        this.initializeProbabilities();
    }

    public void initializeProbabilities() {
        double p;
        double q = p = Math.exp(-this.demandMean * this.leadTime);
        this.demandProbability[0] = p;
        this.demandCCDF[0] = 1.0;
        this.demandLoss1[0] = this.demandMean * this.leadTime;
        int i = 1;
        while (i <= this.maxCapacity) {
            p = p * this.demandMean * this.leadTime / (double)i;
            this.demandCCDF[i] = 1.0 - q;
            this.demandProbability[i] = p;
            this.demandLoss1[i] = (this.demandMean * this.leadTime - (double)i) * (1.0 - (q += p)) + this.demandMean * this.leadTime * p;
            ++i;
        }
    }

    @Override
    public Actions<Order> feasibleActions(CTStockE i) {
        ActionsSet<Order> set = new ActionsSet<Order>();
        int iLevel = i.getItems();
        if (iLevel + i.getOrders() < this.maxCapacity) {
            set.add(new Order(1));
        }
        if (iLevel > 1 || i.getOrders() > 0) {
            set.add(new Order(0));
        }
        return set;
    }

    @Override
    public Events<CTInventoryEvent> activeEvents(CTStockE i, Order a) {
        EventsSet<CTInventoryEvent> set = new EventsSet<CTInventoryEvent>();
        if (i.getOrders() > 0) {
            set.add(new CTInventoryEvent(CTInventoryEvent.orderArrival));
        }
        if (i.getItems() > 0) {
            set.add(new CTInventoryEvent(CTInventoryEvent.demandArrival));
        }
        return set;
    }

    @Override
    public States<CTStockE> reachable(CTStockE i, Order a, CTInventoryEvent e) {
        int items = i.getItems();
        int orders = i.getOrders();
        StatesSet<CTStockE> statesSet = new StatesSet<CTStockE>();
        if (e.getEvent() == CTInventoryEvent.demandArrival) {
            statesSet.add(new CTStockE(items - 1, orders + a.getSize()));
        }
        if (e.getEvent() == CTInventoryEvent.orderArrival) {
            statesSet.add(new CTStockE(items + 1, orders - 1 + a.getSize()));
        }
        return statesSet;
    }

    @Override
    public double rate(CTStockE i, CTStockE j, Order a, CTInventoryEvent e) {
        if (e.getEvent() == CTInventoryEvent.demandArrival) {
            return this.demandMean;
        }
        return (double)i.getOrders() / this.leadTime;
    }

    @Override
    public double lumpCost(CTStockE i, Order a, CTInventoryEvent e) {
        int x = i.getItems() + i.getOrders();
        double lostOrders = this.demandMean * this.leadTime * (this.demandCCDF[x] - this.demandProbability[x]) - (double)x * this.demandCCDF[x];
        double orderCost = x > 0 ? this.K : 0.0;
        return orderCost + (this.price - this.cost) * lostOrders;
    }

    @Override
    public double continuousCost(CTStockE i, Order a, CTInventoryEvent e) {
        return this.holdingCost * (double)i.getItems();
    }

    public static void main(String[] args) throws SolverException {
        int maxCapacity = 15;
        int truckSize = 6;
        double K = 0.0;
        double cost = 400.0;
        double price = 1000.0;
        double holdingCost = 80.0;
        double demandMean = 4.0;
        double leadTime = 2.0;
        StatesSet<CTStockE> initSet = new StatesSet<CTStockE>(new CTStockE(1, 0));
        CTInventoryEvents prob = new CTInventoryEvents(initSet, maxCapacity, truckSize, K, cost, price, holdingCost, demandMean, leadTime);
        RelativeValueIterationSolver<CTStockE, Order> solv = new RelativeValueIterationSolver<CTStockE, Order>(prob);
        solv.setPrintValueFunction(true);
        prob.setSolver(solv);
        prob.solve();
        prob.printSolution();
    }
}

