/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import examples.jmdp.Admit;
import examples.jmdp.TandemEvent;
import examples.jmdp.TandemQueues;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.Random;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.Events;
import jmarkov.basic.EventsSet;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.FiniteMDPEv;
import jmarkov.jmdp.solvers.FiniteSolver;

public class AccessControlFiniteHor
extends FiniteMDPEv<TandemQueues, Admit, TandemEvent> {
    double lambda;
    double mu1;
    double mu2;
    double c1;
    double c2;
    int b1;
    int b2;
    int N;

    public AccessControlFiniteHor(States<TandemQueues> init, double c1, double c2, double lambda, double mu1, double mu2, int b1, int b2, int N) {
        super(init, N);
        this.c1 = c1;
        this.c2 = c2;
        this.lambda = lambda;
        this.mu1 = mu1;
        this.mu2 = mu2;
        this.b1 = b1;
        this.b2 = b2;
        this.N = N;
    }

    @Override
    public Events<TandemEvent> activeEvents(TandemQueues i, Admit a, int t) {
        EventsSet<TandemEvent> eventSet = new EventsSet<TandemEvent>();
        eventSet.add(new TandemEvent(TandemEvent.TEvent.Arrival));
        eventSet.add(new TandemEvent(TandemEvent.TEvent.Service1));
        eventSet.add(new TandemEvent(TandemEvent.TEvent.Service2));
        return eventSet;
    }

    @Override
    public States<TandemQueues> reachable(TandemQueues i, Admit a, TandemEvent e, int t) {
        StatesSet<TandemQueues> set = new StatesSet<TandemQueues>();
        int ac = a.getAdm();
        switch (e.get()) {
            case Arrival: {
                int[] temp = new int[]{Math.min(i.getQ1() + ac, this.b1), i.getQ2()};
                set.add(new TandemQueues(temp));
                break;
            }
            case Service1: {
                int[] temp = new int[]{i.getQ1() == 0 ? 0 : i.getQ1() - 1, i.getQ1() == 0 ? i.getQ2() : Math.min(i.getQ2() + 1, this.b2)};
                set.add(new TandemQueues(temp));
                break;
            }
            case Service2: {
                int[] temp = new int[]{i.getQ1(), i.getQ2() == 0 ? 0 : i.getQ2() - 1};
                set.add(new TandemQueues(temp));
            }
        }
        return set;
    }

    @Override
    public Actions<Admit> feasibleActions(TandemQueues i, int t) {
        ActionsSet<Admit> set = new ActionsSet<Admit>();
        if (i.getQ1() < this.b1) {
            set.add(new Admit(1));
        }
        set.add(new Admit(0));
        return set;
    }

    @Override
    public double immediateCost(TandemQueues i, Admit a, TandemEvent e, int t) {
        int ac = a.getAdm();
        switch (e.get()) {
            case Arrival: {
                if (ac == 0) {
                    return this.c1;
                }
                return 0.0;
            }
            case Service1: {
                if (i.getQ2() == this.b2 && i.getQ1() > 0) {
                    return this.c2;
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    @Override
    public double prob(TandemQueues i, TandemQueues j, Admit a, TandemEvent e, int t) {
        int ac = a.getAdm();
        switch (e.get()) {
            case Arrival: {
                if (ac == 0 && i.getQ1() == j.getQ1() && i.getQ2() == j.getQ2()) {
                    return 1.0;
                }
                if (ac == 1 && i.getQ1() + 1 == j.getQ1() && i.getQ2() == j.getQ2()) {
                    return 1.0;
                }
                return 0.0;
            }
            case Service1: {
                if (i.getQ1() == 0 && i.getQ1() == j.getQ1() && i.getQ2() == j.getQ2()) {
                    return 1.0;
                }
                if (i.getQ1() > 0 && i.getQ2() < this.b2 && i.getQ1() - 1 == j.getQ1() && i.getQ2() + 1 == j.getQ2()) {
                    return 1.0;
                }
                if (i.getQ1() > 0 && i.getQ2() == this.b2 && i.getQ1() - 1 == j.getQ1() && i.getQ2() == j.getQ2()) {
                    return 1.0;
                }
                return 0.0;
            }
        }
        if (i.getQ2() == 0 && i.getQ1() == j.getQ1() && i.getQ2() == j.getQ2()) {
            return 1.0;
        }
        if (i.getQ2() > 0 && i.getQ1() == j.getQ1() && i.getQ2() - 1 == j.getQ2()) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double prob(TandemQueues i, TandemEvent e, int t) {
        double d = this.lambda + this.mu1 + this.mu2;
        switch (e.get()) {
            case Arrival: {
                return this.lambda / d;
            }
            case Service1: {
                return this.mu1 / d;
            }
        }
        return this.mu2 / d;
    }

    @Override
    public double finalCost(TandemQueues i) {
        return 0.0;
    }

    public static void main(String[] args) throws SolverException {
        boolean runOne = false;
        if (runOne) {
            int b1 = 3;
            int b2 = 3;
            int N = 10;
            double c1 = 10.0;
            double c2 = 11.0;
            double lambda = 8.0;
            double mu1 = 5.0;
            double mu2 = 3.0;
            int[] initState = new int[]{1, 1};
            StatesSet<TandemQueues> init = new StatesSet<TandemQueues>(new TandemQueues(initState));
            AccessControlFiniteHor AC = new AccessControlFiniteHor(init, c1, c2, lambda, mu1, mu2, b1, b2, N);
            FiniteSolver<TandemQueues, Admit> theSolver = new FiniteSolver<TandemQueues, Admit>(AC);
            AC.setDebugLevel(4);
            AC.setSolver(theSolver);
            AC.getSolver().setPrintValueFunction(true);
            AC.solve();
            AC.printSolution();
        } else {
            int b1 = 6;
            int b2 = 6;
            int N = 10;
            String stg = "Iter \t Lam \t Mu1 \t Mu2 \t C1 \t C2 \t C2+E \t MAX \n";
            DecimalFormat df1 = new DecimalFormat("#.###");
            Random randGen = new Random(123456L);
            int i = 1;
            while (i <= 10000) {
                double c1 = randGen.nextDouble() * 999.0 + 1.0;
                double c2 = randGen.nextDouble() * (999.0 - c1) + c1;
                double l = randGen.nextDouble() * 99.0 + 1.0;
                double m1 = randGen.nextDouble() * 99.0 + 1.0;
                double m2 = randGen.nextDouble() * 99.0 + 1.0;
                double x = randGen.nextDouble() * 0.1;
                double[][] beta = new double[b1 + 1][b2 + 1];
                double[][] beta2 = new double[b1 + 1][b2 + 1];
                if (i % 1000 == 0) {
                    System.out.println(String.valueOf(i) + ", ");
                } else if (i % 100 == 0) {
                    System.out.print(String.valueOf(i) + ", ");
                }
                int k = 0;
                while (k <= b2) {
                    int r = 0;
                    while (r <= b1) {
                        int[] initState = new int[]{r, k};
                        StatesSet<TandemQueues> init = new StatesSet<TandemQueues>(new TandemQueues(initState));
                        AccessControlFiniteHor AC = new AccessControlFiniteHor(init, c1, c2, l, m1, m2, b1, b2, N);
                        FiniteSolver<TandemQueues, Admit> theSolver = new FiniteSolver<TandemQueues, Admit>(AC);
                        AccessControlFiniteHor AC2 = new AccessControlFiniteHor(init, c1, c2 + c2 * x, l, m1, m2, b1, b2, N);
                        FiniteSolver<TandemQueues, Admit> theSolver2 = new FiniteSolver<TandemQueues, Admit>(AC2);
                        AC.setDebugLevel(0);
                        AC.setSolver(theSolver);
                        AC.solve();
                        AC2.setDebugLevel(0);
                        AC2.setSolver(theSolver2);
                        AC2.solve();
                        double[] g = theSolver.getOptimalValueFunction().get();
                        double[] g2 = theSolver2.getOptimalValueFunction().get();
                        beta[r][k] = -g[0];
                        beta2[r][k] = -g2[0];
                        ++r;
                    }
                    ++k;
                }
                double mx = -1000000.0;
                int k2 = 0;
                while (k2 <= b2) {
                    int r = 0;
                    while (r < b1) {
                        double dif;
                        if (k2 + r >= b2 && (dif = beta2[r + 1][k2] - beta2[r][k2] - (beta[r + 1][k2] - beta[r][k2])) >= mx) {
                            mx = dif;
                        }
                        ++r;
                    }
                    ++k2;
                }
                stg = String.valueOf(stg) + i + "\t" + df1.format(l) + "\t " + df1.format(m1) + "\t " + df1.format(m2) + "\t " + df1.format(c1) + "\t " + df1.format(c2) + "\t " + df1.format(c2 + x * c2) + "\t " + mx + "\n";
                ++i;
            }
            try {
                FileWriter outFile = new FileWriter("C:/Users/Owner/Documents/HomePC Files/Daniel Universidad/MIIND/Tesis/jMarkov2_0a/examples/jmarkov/AccessControlFiles/resultFinite.txt");
                PrintWriter out = new PrintWriter(outFile);
                StringWriter sw = new StringWriter();
                stg = String.valueOf(stg) + sw.toString();
                out.print(stg);
                out.close();
            }
            catch (IOException EE) {
                EE.printStackTrace();
            }
        }
    }
}

