/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.WebEvent;
import examples.jmarkov.WebState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.NotUnichainException;

public class Web
extends SimpleMarkovProcess<WebState, WebEvent> {
    private double Gamma;
    private double[] mu;
    double[] lambda;
    private double[] Prob;
    private int M;
    private int N;
    private int MaxQueue;
    private static final int ARRIVAL = 1;
    private static final int DEPARTURE = 0;

    public Web(double[] lambda, double[] mu, int M, double Gamma2, int MaxQueue, int N) {
        super(new WebState(M), WebEvent.getAllEvents(M));
        this.M = M;
        this.lambda = lambda;
        this.mu = mu;
        this.Gamma = Gamma2;
        this.N = N;
        this.MaxQueue = MaxQueue;
        int aux = 0;
        this.Prob = new double[M];
        int i = 0;
        while (i < M) {
            aux = (int)((double)aux + lambda[i]);
            ++i;
        }
        i = 0;
        while (i < M) {
            this.Prob[i] = lambda[i] / (double)aux;
            ++i;
        }
    }

    @Override
    public boolean active(WebState i, WebEvent e) {
        boolean result = false;
        switch (e.type) {
            case 1: {
                if (i.getQSize() >= this.MaxQueue) break;
                result = true;
                break;
            }
            case 0: {
                if (i.getNumber(e.item) <= 0) break;
                result = true;
            }
        }
        return result;
    }

    @Override
    public States<WebState> dests(WebState i, WebEvent e) {
        StatesSet<WebState> set = new StatesSet<WebState>();
        int[] NumItems = new int[this.M];
        int k = 0;
        while (k < this.M) {
            NumItems[k] = i.getNumber(k);
            ++k;
        }
        int Q = i.getQSize();
        switch (e.type) {
            case 1: {
                if (i.getNumServe() == this.N) {
                    set.add(new WebState(NumItems, ++Q, this.M));
                    break;
                }
                int n = e.item;
                NumItems[n] = NumItems[n] + 1;
                set.add(new WebState(NumItems, Q, this.M));
                break;
            }
            case 0: {
                if (i.getQSize() == 0) {
                    int n = e.item;
                    NumItems[n] = NumItems[n] - 1;
                    set.add(new WebState(NumItems, Q, this.M));
                    break;
                }
                --Q;
                int n = e.item;
                NumItems[n] = NumItems[n] - 1;
                int k2 = 0;
                while (k2 < this.M) {
                    int n2 = k2;
                    NumItems[n2] = NumItems[n2] + 1;
                    set.add(new WebState(NumItems, Q, this.M));
                    int n3 = k2++;
                    NumItems[n3] = NumItems[n3] - 1;
                }
                break;
            }
        }
        return set;
    }

    @Override
    public double rate(WebState i, WebState j, WebEvent e) {
        double result = 0.0;
        int aux = e.type;
        switch (e.type) {
            case 1: {
                result = this.lambda[e.item];
                break;
            }
            case 0: {
                if (i.getQSize() > 0) {
                    int k = 0;
                    while (k < this.M) {
                        if (i.getNumber(k) != j.getNumber(k)) {
                            aux = k;
                        }
                        ++k;
                    }
                    result = this.Gamma / this.mu[e.item] * (double)i.getNumber(e.item) * this.Prob[aux];
                    break;
                }
                result = this.Gamma / this.mu[e.item] * (double)i.getNumber(e.item);
            }
        }
        return result;
    }

    public static void main(String[] a) {
        double[] lambda = new double[]{};
        double[] mu = new double[]{};
        double Gamma2 = 0.0;
        int M = 0;
        int N = 0;
        int MaxQueue = 0;
        BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
        try {
            System.out.println("Number of different items types:");
            M = Integer.parseInt(rdr.readLine());
            System.out.println("Max number of items that can be served simultaneously:");
            N = Integer.parseInt(rdr.readLine());
            System.out.println("Bytes per second that the server works: ");
            Gamma2 = Double.parseDouble(rdr.readLine());
            System.out.println("Queue capacity: ");
            MaxQueue = Integer.parseInt(rdr.readLine());
            mu = new double[M];
            int k = 0;
            while (k < M) {
                System.out.println("Item " + (k + 1) + " mean size in bytes:");
                mu[k] = Double.parseDouble(rdr.readLine());
                ++k;
            }
            lambda = new double[M];
            k = 0;
            while (k < M) {
                System.out.println("Item " + (k + 1) + " arrival rate:");
                lambda[k] = Double.parseDouble(rdr.readLine());
                ++k;
            }
        }
        catch (IOException k) {
            // empty catch block
        }
        Web TheModel = new Web(lambda, mu, M, Gamma2, MaxQueue, N);
        TheModel.printAll();
        TheModel.showGUI();
    }

    @Override
    public String description() {
        double lambda = 0.0;
        int i = 0;
        while (i < this.M) {
            lambda += this.lambda[i];
            ++i;
        }
        String stg = "Web Server SYSTEM\n\n";
        stg = String.valueOf(stg) + "One server queue with " + this.M + " different kinds of items\n";
        try {
            stg = String.valueOf(stg) + "Avarge waiting time is " + this.getMOPsAvg("Queue Length") / lambda * 60.0 + " Minutes";
        }
        catch (NotUnichainException e) {
            e.printStackTrace();
        }
        return stg;
    }
}

