/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.QueuePhPh2Event;
import examples.jmarkov.QueuePhPh2State;
import java.util.Date;
import jmarkov.GeomProcess;
import jmarkov.GeomRelState;
import jmarkov.basic.StatesSet;

public class QueuePhPh2
extends GeomProcess<QueuePhPh2State, QueuePhPh2Event> {
    final int arrival = 0;
    final int st1Ph1ToSt1Ph2 = 1;
    final int st1Ph2ToSt2Ph1 = 2;
    final int st1Ph2ToSt2Ph2 = 3;
    final int st2Ph1ToSt2Ph1 = 4;
    final int st2Ph1ToSt2Ph2 = 5;
    final int st2Ph2ToSt2Ph1 = 6;
    final int st2Ph2ToSt2Ph2 = 7;
    private double lambda1;
    private double lambda2;
    private double s1Mu1;
    private double s1Mu2;
    private double s2Mu1;
    private double s2Mu2;
    private double prob1;
    private int cptyServ2;

    public QueuePhPh2(double lambda1, double lambda2, double s1Mu1, double s1Mu2, double s2Mu1, double s2Mu2, int cptyServ2) {
        super(new QueuePhPh2State(0, 0, 0), QueuePhPh2Event.getAllEvents());
        this.lambda1 = lambda1;
        this.lambda2 = lambda2;
        this.s1Mu1 = s1Mu1;
        this.s1Mu2 = s1Mu2;
        this.s2Mu1 = s2Mu1;
        this.s2Mu2 = s2Mu2;
        this.prob1 = lambda1 / (lambda1 + lambda2);
        this.cptyServ2 = cptyServ2;
    }

    public QueuePhPh2() {
        this(1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2);
    }

    @Override
    public boolean active(QueuePhPh2State i, int absLevel, QueuePhPh2Event e) {
        boolean result = false;
        switch (e.type) {
            case 0: {
                result = true;
                break;
            }
            case 1: {
                result = i.getServer1Status() == 1;
                break;
            }
            case 2: {
                result = i.getServer1Status() == 2;
                break;
            }
            case 3: {
                result = i.getServer1Status() == 2;
                break;
            }
            case 4: {
                result = i.getServer2Status() == 1;
                break;
            }
            case 5: {
                result = i.getServer2Status() == 1;
                break;
            }
            case 6: {
                result = i.getServer2Status() == 2;
                break;
            }
            case 7: {
                result = i.getServer2Status() == 2;
            }
        }
        return result;
    }

    @Override
    public GeomRelState<QueuePhPh2State>[] dests(QueuePhPh2State i, int absLevel, QueuePhPh2Event e) {
        int newCostumersInServer2 = i.getCostumersInServer2();
        int newServer1Status = i.getServer1Status();
        int newServer2Status = i.getServer2Status();
        int rLevel = 0;
        if (e.type == 0) {
            rLevel = 1;
            if (absLevel == 0) {
                newServer1Status = 1;
            }
        } else if (e.type == 1) {
            ++newServer1Status;
        } else if (e.type == 2 || e.type == 3) {
            if (newCostumersInServer2 < this.cptyServ2) {
                if (newCostumersInServer2 == 0) {
                    switch (e.type) {
                        case 2: {
                            newServer2Status = 1;
                            break;
                        }
                        case 3: {
                            newServer2Status = 2;
                        }
                    }
                }
                if (absLevel == 1) {
                    newServer1Status = 0;
                } else {
                    newServer1Status = 1;
                    rLevel = -1;
                }
                ++newCostumersInServer2;
            } else {
                newServer1Status = 3;
            }
        } else if (e.type == 4 || e.type == 5 || e.type == 6 || e.type == 7) {
            if (newCostumersInServer2 == 1) {
                newServer2Status = 0;
                --newCostumersInServer2;
            } else {
                newServer2Status = e.type == 4 || e.type == 6 ? 1 : 2;
                if (newServer1Status == 3 && absLevel == 1) {
                    newServer1Status = 0;
                } else if (newServer1Status == 3) {
                    rLevel = -1;
                    newServer1Status = 1;
                } else {
                    --newCostumersInServer2;
                }
            }
        }
        QueuePhPh2State newSubState = new QueuePhPh2State(newCostumersInServer2, newServer1Status, newServer2Status);
        GeomRelState<QueuePhPh2State> s = (e.type == 2 || e.type == 3) && i.getCostumersInServer2() < this.cptyServ2 && absLevel == 1 || (e.type == 4 || e.type == 5 || e.type == 6 || e.type == 7) && i.getCostumersInServer2() != 1 && i.getServer1Status() == 3 && absLevel == 1 ? new GeomRelState<QueuePhPh2State>(newSubState) : new GeomRelState<QueuePhPh2State>(newSubState, rLevel);
        StatesSet<GeomRelState<QueuePhPh2State>> statesSet = new StatesSet<GeomRelState<QueuePhPh2State>>(s);
        return (GeomRelState[])statesSet.toStateArray();
    }

    @Override
    public double rate(QueuePhPh2State i, int iLevel, QueuePhPh2State j, int jLevel, QueuePhPh2Event e) {
        double tasa = 0.0;
        switch (e.type) {
            case 0: {
                tasa = this.lambda1 + this.lambda2;
                break;
            }
            case 1: {
                tasa = this.s1Mu1;
                break;
            }
            case 2: {
                tasa = this.prob1 * this.s1Mu2;
                break;
            }
            case 3: {
                tasa = (1.0 - this.prob1) * this.s1Mu2;
                break;
            }
            case 4: {
                tasa = this.prob1 * this.s2Mu1;
                break;
            }
            case 5: {
                tasa = (1.0 - this.prob1) * this.s2Mu1;
                break;
            }
            case 6: {
                tasa = this.prob1 * this.s2Mu2;
                break;
            }
            case 7: {
                tasa = (1.0 - this.prob1) * this.s2Mu2;
            }
        }
        return tasa;
    }

    @Override
    public String description() {
        return "Ph/Ph/2";
    }

    public static void main(String[] a) {
        Date inicio = new Date();
        QueuePhPh2 theQueue = new QueuePhPh2(2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 2);
        theQueue.showGUI();
        theQueue.printAll();
        Date termina = new Date();
        long diferencia = termina.getTime() - inicio.getTime();
        System.out.println("tiempo de ejecuci\u00f3n = " + diferencia);
    }
}

