/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.QueueMMKdNEvent;
import examples.jmarkov.QueueMMKdNState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;

public class QueueMMKdN
extends SimpleMarkovProcess<QueueMMKdNState, QueueMMKdNEvent> {
    private double lambda;
    private double[] mu;
    private double[] alpha;
    private int K;
    private int N;
    private static final int NDARRIVAL = 0;
    private static final int DIRARRIVAL = 1;
    private static final int DEPARTURE = 2;

    public QueueMMKdN(double lambda, double[] mu, double[] alpha, int N) {
        super(new QueueMMKdNState(mu.length, alpha), QueueMMKdNEvent.getAllEvents(mu.length));
        this.K = mu.length;
        this.lambda = lambda;
        this.mu = mu;
        this.alpha = alpha;
        this.N = N;
    }

    public QueueMMKdN() {
        this(1.0, new double[]{2.0, 3.0, 4.0}, new double[]{2.0, 3.0, 4.0}, 8);
    }

    @Override
    public boolean active(QueueMMKdNState i, QueueMMKdNEvent e) {
        boolean result = false;
        switch (e.type) {
            case 0: {
                result = i.allBusy() && i.getQSize() < this.N - this.K;
                break;
            }
            case 1: {
                result = i.getStatus(e.server) == 0;
                break;
            }
            case 2: {
                result = i.getStatus(e.server) == 1;
            }
        }
        return result;
    }

    @Override
    public States<QueueMMKdNState> dests(QueueMMKdNState i, QueueMMKdNEvent e) {
        int[] status = new int[this.K];
        int k = 0;
        while (k < this.K) {
            status[k] = i.getStatus(k);
            ++k;
        }
        int Q = i.getQSize();
        switch (e.type) {
            case 0: {
                ++Q;
                break;
            }
            case 1: {
                status[e.server] = 1;
                break;
            }
            case 2: {
                if (Q > 0) {
                    status[e.server] = 1;
                    --Q;
                    break;
                }
                status[e.server] = 0;
            }
        }
        return new StatesSet<QueueMMKdNState>(new QueueMMKdNState(status, Q, this.alpha));
    }

    @Override
    public double rate(QueueMMKdNState i, QueueMMKdNState j, QueueMMKdNEvent e) {
        double result = 0.0;
        switch (e.type) {
            case 2: {
                result = this.mu[e.server];
                break;
            }
            case 0: {
                result = this.lambda;
                break;
            }
            case 1: {
                result = i.prob(e.server) * this.lambda;
            }
        }
        return result;
    }

    public static void main(String[] a) {
        BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
        try {
            System.out.println("Input Rate: ");
            double lda = Double.parseDouble(rdr.readLine());
            System.out.println("Num Servers: ");
            int K = Integer.parseInt(rdr.readLine());
            double[] mu = new double[K];
            double[] alpha = new double[K];
            int k = 0;
            while (k < K) {
                System.out.println("Service rate, server " + (k + 1) + " : ");
                mu[k] = Double.parseDouble(rdr.readLine());
                ++k;
            }
            k = 0;
            while (k < K) {
                System.out.println("Choosing intensity, server  " + (k + 1) + " : ");
                alpha[k] = Double.parseDouble(rdr.readLine());
                ++k;
            }
            System.out.println("Max in system : ");
            int N = Integer.parseInt(rdr.readLine());
            QueueMMKdN theModel = new QueueMMKdN(lda, mu, alpha, N);
            theModel.showGUI();
            theModel.printAll();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String description() {
        String stg = "M/M/k/N SYSTEM\n\n";
        stg = String.valueOf(stg) + "Multiple server queue with " + this.K + " different servers\n";
        stg = String.valueOf(stg) + "Arrival Rate = " + this.lambda + ", Max number in system " + this.N;
        return stg;
    }
}

