/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.PropertiesState;

class QueueMM1NState
extends PropertiesState {
    QueueMM1NState(int x) {
        super(1);
        this.prop[0] = x;
    }

    @Override
    public void computeMOPs(MarkovProcess mp) {
        this.setMOP(mp, "Number in the system", this.getLevel());
        this.setMOP(mp, "Number in queue", this.getNumberQ());
        this.setMOP(mp, "Server Utilization", this.getServerStatus());
    }

    public int getLevel() {
        return this.prop[0];
    }

    public int getServerStatus() {
        return this.prop[0] > 0 ? 1 : 0;
    }

    public int getNumberQ() {
        return this.getLevel() - this.getServerStatus();
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public String label() {
        return "" + this.getLevel();
    }

    @Override
    public String description() {
        return "Number in system = " + this.getLevel() + "  (" + this.getNumberQ() + " in queue).";
    }
}

