/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.PropertiesState;

class QueueMEk1State
extends PropertiesState {
    private int k;

    QueueMEk1State(int status, int numStages) {
        super(1);
        this.k = numStages;
        this.setProperty(0, status);
    }

    @Override
    public void computeMOPs(MarkovProcess mp) {
        this.setMOP(mp, "Server Utilization", this.getServerStatus() != 0 ? 1 : 0);
        int i = 1;
        while (i <= this.k) {
            this.setMOP(mp, "Stage " + i + " Utilization", this.getServerStatus() == i ? 1.0 : 0.0);
            ++i;
        }
    }

    public int getServerStatus() {
        return this.getProperty(0);
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public String label() {
        return "S" + this.getProperty(0);
    }

    @Override
    public String description() {
        return "Server status = " + this.getServerStatus();
    }
}

