/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.PickBlockWideContKPickers_V3Event;
import examples.jmarkov.PickBlockWideContKPickers_V3State;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.NotUnichainException;

public class PickBlockWideContKPickers_V3
extends SimpleMarkovProcess<PickBlockWideContKPickers_V3State, PickBlockWideContKPickers_V3Event> {
    private double p;
    private int picklocs;
    private int k;
    private double pickspeed;
    private double walkspeed;

    public PickBlockWideContKPickers_V3(double p, int picklocs, int k, double pickspeed, double walkspeed, int[] a) {
        super(new PickBlockWideContKPickers_V3State(a, picklocs, k), PickBlockWideContKPickers_V3Event.getAllEvents(k));
        this.p = p;
        this.picklocs = picklocs;
        this.pickspeed = pickspeed;
        this.walkspeed = walkspeed;
        this.k = k;
    }

    public PickBlockWideContKPickers_V3() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = -1;
        this(1.0, 20, 3, 1.0, 10.0, nArray);
    }

    @Override
    public boolean active(PickBlockWideContKPickers_V3State i, PickBlockWideContKPickers_V3Event e) {
        boolean result;
        block20: {
            int act;
            boolean blockable;
            block21: {
                block19: {
                    result = false;
                    blockable = false;
                    act = i.getState(e.getPicker() + this.k);
                    int pick = e.getPicker();
                    int distmin = this.k;
                    int[] dude = new int[this.k];
                    int j = 0;
                    while (j < this.k) {
                        if ((Math.abs(i.getState(j) - (i.getState(pick) + 1)) == 0 || Math.abs(i.getState(j) - (i.getState(pick) + 1)) == this.picklocs) && j != pick) {
                            distmin = 0;
                            dude[j] = j;
                        } else {
                            dude[j] = this.k;
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < this.k) {
                        if (dude[j] < this.k && distmin == 0 && i.getState(dude[j] + this.k) >= 1) {
                            blockable = true;
                        }
                        ++j;
                    }
                    if (act != 2) break block19;
                    result = false;
                    break block20;
                }
                if (act != 0) break block21;
                switch (e.getType()) {
                    case WALKTOPICK: {
                        if (blockable) {
                            result = false;
                            break;
                        }
                        result = true;
                        break;
                    }
                    case WALKTOWALK: {
                        result = true;
                        break;
                    }
                    case WALKTOBLOCK: {
                        if (blockable) {
                            result = true;
                            break;
                        }
                        break block20;
                    }
                    default: {
                        result = false;
                        break;
                    }
                }
                break block20;
            }
            if (act == 1) {
                switch (e.getType()) {
                    case PICKTOPICK: {
                        if (blockable) {
                            result = false;
                            break;
                        }
                        result = true;
                        break;
                    }
                    case PICKTOWALK: {
                        result = true;
                        break;
                    }
                    case PICKTOBLOCK: {
                        if (!blockable) break;
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public States<PickBlockWideContKPickers_V3State> dests(PickBlockWideContKPickers_V3State i, PickBlockWideContKPickers_V3Event e) {
        int[] origin = i.getProperties();
        return new StatesSet<PickBlockWideContKPickers_V3State>(i.Trans(origin, this.k, e));
    }

    @Override
    public double rate(PickBlockWideContKPickers_V3State i, PickBlockWideContKPickers_V3State j, PickBlockWideContKPickers_V3Event e) {
        double pr;
        block21: {
            int act;
            boolean blockable;
            double q;
            block22: {
                block20: {
                    if (!this.active(i, e)) {
                        return 0.0;
                    }
                    pr = 0.0;
                    q = 1.0 - this.p;
                    blockable = false;
                    act = i.getState(e.getPicker() + this.k);
                    int pick = e.getPicker();
                    int distmin = this.k;
                    int[] dude = new int[this.k];
                    int l = 0;
                    while (l < this.k) {
                        if ((Math.abs(i.getState(l) - (i.getState(pick) + 1)) == 0 || Math.abs(i.getState(l) - (i.getState(pick) + 1)) == this.picklocs) && l != pick) {
                            distmin = 0;
                            dude[l] = l;
                        } else {
                            dude[l] = this.k;
                        }
                        ++l;
                    }
                    l = 0;
                    while (l < this.k) {
                        if (dude[l] < this.k && distmin == 0 && i.getState(dude[l] + this.k) >= 1) {
                            blockable = true;
                        }
                        ++l;
                    }
                    if (act != 2) break block20;
                    pr = 0.0;
                    break block21;
                }
                if (act != 0) break block22;
                switch (e.getType()) {
                    case WALKTOPICK: {
                        if (blockable) {
                            pr = 0.0;
                            break;
                        }
                        pr = this.p * this.walkspeed;
                        break;
                    }
                    case WALKTOWALK: {
                        pr = q * this.walkspeed;
                        break;
                    }
                    case WALKTOBLOCK: {
                        if (blockable) {
                            pr = this.p * this.walkspeed;
                            break;
                        }
                        break block21;
                    }
                    default: {
                        pr = 0.0;
                        break;
                    }
                }
                break block21;
            }
            if (act == 1) {
                switch (e.getType()) {
                    case PICKTOPICK: {
                        if (blockable) {
                            pr = 0.0;
                            break;
                        }
                        pr = this.p * this.pickspeed;
                        break;
                    }
                    case PICKTOWALK: {
                        pr = q * this.pickspeed;
                        break;
                    }
                    case PICKTOBLOCK: {
                        if (!blockable) break;
                        pr = this.p * this.pickspeed;
                        break;
                    }
                    default: {
                        pr = 0.0;
                    }
                }
            }
        }
        return pr;
    }

    @Override
    public String description() {
        String stg = "WideCont-Aisle-OPS \n\nThere are " + this.picklocs + " pick locations in the system\n\n";
        stg = String.valueOf(stg) + "There are " + this.k + " Pickers in the system.\n";
        stg = String.valueOf(stg) + "The pick and walk times are exponential RVs.\n";
        stg = String.valueOf(stg) + "The average pick speed of a picker is " + this.pickspeed + " locations per minute \n";
        stg = String.valueOf(stg) + "The average walk speed of a picker is " + this.walkspeed + " locations per minute\n";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        stg = String.valueOf(stg) + sw.toString();
        return stg;
    }

    @Override
    public int printMOPs(PrintWriter out, int width, int decimals) {
        try {
            double[] busy = this.getSteadyState();
            double block = 0.0;
            StatesSet a = this.getStates();
            State[] c = a.toStateArray();
            int i = 0;
            while (i < this.k) {
                int j = 0;
                while (j < this.getNumStates()) {
                    if (c[j].getMOP(this.k + i) == 2.0) {
                        block += busy[j];
                    }
                    ++j;
                }
                ++i;
            }
            out.printf("    Numero de Pick Locations   = %6d ", this.picklocs);
            out.printf("\n    Numero de Pickers          = %6d ", this.k);
            out.printf("\n    Picking Probability        = %2.6f ", this.p);
            out.printf("\n    Porcentaje de Tiempo de Bloqueo de cada Picker     = %2.6f ", block * 100.0 / (double)this.k);
            out.println();
        }
        catch (NotUnichainException e) {
            out.println(e);
        }
        return 0;
    }

    public static void main(String[] a) {
        PickBlockWideContKPickers_V3 OPS = new PickBlockWideContKPickers_V3();
        OPS.setDebugLevel(0);
        OPS.setMaxStates(8000L);
        OPS.showGUI();
        OPS.printAll();
        OPS.printMOPs();
    }

    public double getProbability() {
        return this.p;
    }

    public int getPicklocs() {
        return this.picklocs;
    }
}

