/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.PickBlockWideEvent;
import examples.jmarkov.PickBlockWideState;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.NotUnichainException;

public class PickBlockWide
extends SimpleMarkovProcess<PickBlockWideState, PickBlockWideEvent> {
    private double p;
    private int picklocs;

    public PickBlockWide(double p, int picklocs) {
        super(new PickBlockWideState(0, picklocs), PickBlockWideEvent.getAllEvents(picklocs));
        this.p = p;
        this.picklocs = picklocs;
    }

    public PickBlockWide() {
        this(0.1, 20);
    }

    @Override
    public boolean active(PickBlockWideState i, PickBlockWideEvent e) {
        boolean result = false;
        int stat = i.getDistance();
        int dest = stat + e.getShift();
        result = dest < this.picklocs && dest >= 0;
        return result;
    }

    @Override
    public States<PickBlockWideState> dests(PickBlockWideState i, PickBlockWideEvent e) {
        int origin = i.getDistance();
        int dest = e.getShift();
        return new StatesSet<PickBlockWideState>(i.Trans(origin, dest));
    }

    @Override
    public double rate(PickBlockWideState i, PickBlockWideState j, PickBlockWideEvent e) {
        int origin = i.getDistance();
        int shift = e.getShift();
        int dest = origin + shift;
        return this.getProbs(origin, dest);
    }

    public double getProbs(int i, int j) {
        int r = 0;
        int loc = this.getPicklocs();
        double q = 0.0;
        double denom = 0.0;
        double prob = 0.0;
        double[] h = new double[loc];
        q = 1.0 - this.p;
        if (i == 0) {
            int k = 1;
            while (k <= loc - 1) {
                r = k + i;
                h[r] = (this.p * Math.pow(q, Math.abs(k) - 1) + this.p * Math.pow(q, loc - Math.abs(k) - 1)) / 2.0;
                denom += h[r];
                ++k;
            }
            h[0] = 0.0;
            prob = h[j] / (denom += h[0]);
        } else {
            int k = -i;
            while (k <= loc - 1 - i) {
                r = k + i;
                if (r != i) {
                    h[r] = (this.p * Math.pow(q, Math.abs(k)) + this.p * Math.pow(q, loc - Math.abs(k))) / (1.0 + q);
                    denom += h[r];
                }
                ++k;
            }
            h[i] = this.p / (1.0 + q);
            prob = h[j] / (denom += h[i]);
        }
        return prob;
    }

    @Override
    public String description() {
        String stg = "Wide-Aisle-OPS \n\nThere are " + this.picklocs + " pick locations in the system\n\n";
        stg = String.valueOf(stg) + "There are 2 Pickers in the system.\n";
        stg = String.valueOf(stg) + "The pick/walk speed ratio is 1:infinity.\n";
        stg = String.valueOf(stg) + "Picking Probability is " + this.p + ".";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        stg = String.valueOf(stg) + sw.toString();
        return stg;
    }

    @Override
    public int printMOPs(PrintWriter out, int width, int decimals) {
        try {
            double[] busy = this.getSteadyState();
            out.printf("    Number of Pick Locations   = %6d ", this.picklocs);
            out.printf("\n    Number of Pickers          = %6d ", 2);
            out.printf("\n    Picking Probability        = %6.4f ", this.p);
            out.printf("\n    Percentage of Time Picker 1 is blocked    = %3.5f ", busy[0] * 100.0 / 2.0);
            out.printf("\n    Percentage of Time Picker 2 is blocked    = %3.5f ", busy[0] * 100.0 / 2.0);
            out.println();
        }
        catch (NotUnichainException e) {
            out.println(e);
        }
        return 0;
    }

    public static void main(String[] a) {
        PickBlockWide OPS = new PickBlockWide();
        OPS.setDebugLevel(0);
        OPS.showGUI();
        OPS.printAll();
        OPS.printMOPs();
    }

    public double getProbability() {
        return this.p;
    }

    public int getPicklocs() {
        return this.picklocs;
    }
}

