/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.basic.Event;
import jmarkov.basic.EventsSet;

class PickBlockNarrowSlowEvent
extends Event {
    private Type type;
    public int distshift;
    public int first;
    public int second;

    public PickBlockNarrowSlowEvent(Type type) {
        this.type = type;
        switch (type) {
            case WALKWALK: {
                this.distshift = 0;
                this.first = 0;
                this.second = 0;
                break;
            }
            case WALKPICK: {
                this.distshift = 1;
                this.first = 0;
                this.second = 1;
                break;
            }
            case PICKWALK: {
                this.distshift = -1;
                this.first = 1;
                this.second = 0;
                break;
            }
            case PICKPICK: {
                this.distshift = 0;
                this.first = 1;
                this.second = 1;
                break;
            }
            case TOBLOCK1: {
                this.distshift = 0;
                this.first = 0;
                this.second = 1;
                break;
            }
            case TOBLOCK2: {
                this.distshift = 0;
                this.first = 1;
                this.second = 0;
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    public int getDistshift() {
        return this.distshift;
    }

    public int getFirst() {
        return this.first;
    }

    public int getSecond() {
        return this.second;
    }

    public static EventsSet<PickBlockNarrowSlowEvent> getAllEvents() {
        EventsSet<PickBlockNarrowSlowEvent> eSet = new EventsSet<PickBlockNarrowSlowEvent>();
        eSet.add(new PickBlockNarrowSlowEvent(Type.PICKPICK));
        eSet.add(new PickBlockNarrowSlowEvent(Type.PICKWALK));
        eSet.add(new PickBlockNarrowSlowEvent(Type.WALKPICK));
        eSet.add(new PickBlockNarrowSlowEvent(Type.WALKWALK));
        eSet.add(new PickBlockNarrowSlowEvent(Type.TOBLOCK1));
        eSet.add(new PickBlockNarrowSlowEvent(Type.TOBLOCK2));
        return eSet;
    }

    @Override
    public String label() {
        String stg = "";
        switch (this.type) {
            case PICKPICK: {
                stg = "Both Pick";
                break;
            }
            case WALKWALK: {
                stg = "Both walk";
                break;
            }
            case PICKWALK: {
                stg = "The First Picker picks, the second walks";
                break;
            }
            case WALKPICK: {
                stg = "The first picker walks the second picks";
                break;
            }
            case TOBLOCK1: {
                stg = "Picker 1 gets blocked by picker 2";
                break;
            }
            case TOBLOCK2: {
                stg = "Picker 2 gets blocked by picker 1";
            }
        }
        return stg;
    }

    public static enum Type {
        PICKPICK,
        WALKWALK,
        PICKWALK,
        WALKPICK,
        TOBLOCK1,
        TOBLOCK2;

    }
}

