/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.PickBlockNarrowSlowEvent;
import examples.jmarkov.PickBlockNarrowSlowState;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.NotUnichainException;

public class PickBlockNarrowSlow
extends SimpleMarkovProcess<PickBlockNarrowSlowState, PickBlockNarrowSlowEvent> {
    private double p;
    private int picklocs;

    public PickBlockNarrowSlow(double p, int picklocs, int[] a) {
        super(new PickBlockNarrowSlowState(a, picklocs), PickBlockNarrowSlowEvent.getAllEvents());
        this.p = p;
        this.picklocs = picklocs;
    }

    public PickBlockNarrowSlow() {
        int[] nArray = new int[3];
        nArray[0] = 1;
        this(0.1, 250, nArray);
    }

    @Override
    public boolean active(PickBlockNarrowSlowState i, PickBlockNarrowSlowEvent e) {
        boolean result = false;
        if (i.getFirst() == 0 && i.getSecond() == 0) {
            switch (e.getType()) {
                case WALKWALK: {
                    result = true;
                    break;
                }
                case WALKPICK: {
                    result = true;
                    break;
                }
                case PICKPICK: {
                    result = true;
                    break;
                }
                case PICKWALK: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else if (i.getFirst() == 1 && i.getSecond() == 0) {
            switch (e.getType()) {
                case WALKWALK: {
                    result = true;
                    break;
                }
                case WALKPICK: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else if (i.getFirst() == 0 && i.getSecond() == 1) {
            switch (e.getType()) {
                case WALKWALK: {
                    result = true;
                    break;
                }
                case PICKWALK: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else if (i.getFirst() == 1 && i.getSecond() == 1) {
            switch (e.getType()) {
                case WALKWALK: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        if (i.getDistance() == 1) {
            if (i.getFirst() == 0 && i.getSecond() == 1) {
                switch (e.getType()) {
                    case WALKWALK: {
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
            }
            if (i.getFirst() == 0 && i.getSecond() == 0) {
                switch (e.getType()) {
                    case WALKWALK: {
                        result = true;
                        break;
                    }
                    case WALKPICK: {
                        result = true;
                        break;
                    }
                    case PICKPICK: {
                        result = true;
                        break;
                    }
                    case TOBLOCK1: {
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
            }
        }
        if (i.getDistance() == this.picklocs - 1) {
            if (i.getFirst() == 1 && i.getSecond() == 0) {
                switch (e.getType()) {
                    case WALKWALK: {
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
            }
            if (i.getFirst() == 0 && i.getSecond() == 0) {
                switch (e.getType()) {
                    case WALKWALK: {
                        result = true;
                        break;
                    }
                    case PICKWALK: {
                        result = true;
                        break;
                    }
                    case PICKPICK: {
                        result = true;
                        break;
                    }
                    case TOBLOCK2: {
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public States<PickBlockNarrowSlowState> dests(PickBlockNarrowSlowState i, PickBlockNarrowSlowEvent e) {
        int[] origin = i.getProperties();
        return new StatesSet<PickBlockNarrowSlowState>(i.Trans(origin, e));
    }

    @Override
    public double rate(PickBlockNarrowSlowState i, PickBlockNarrowSlowState j, PickBlockNarrowSlowEvent e) {
        int[] origin = i.getProperties();
        int[] dest = j.getProperties();
        if (!this.active(i, e) || Math.abs(origin[0] - dest[0]) > 1) {
            return 0.0;
        }
        return this.getProbs(origin, dest);
    }

    public double getProbs(int[] i, int[] j) {
        double pr = 0.0;
        double q = 1.0 - this.p;
        if (i[1] == 1 && i[2] == 1) {
            pr = j[1] == 0 && j[2] == 0 && i[0] == j[0] ? 1.0 : 0.0;
        } else if (i[1] == 1 && i[2] == 0) {
            pr = j[1] == 0 && j[2] == 0 && i[0] == j[0] ? q : (j[1] == 0 && j[2] == 1 && i[0] + 1 == j[0] ? this.p : 0.0);
        } else if (i[1] == 0 && i[2] == 1) {
            pr = j[1] == 0 && j[2] == 0 && i[0] == j[0] ? q : (j[1] == 1 && j[2] == 0 && i[0] - 1 == j[0] ? this.p : 0.0);
        } else if (i[1] == 0 && i[2] == 0) {
            pr = j[1] == 0 && j[2] == 0 && i[0] == j[0] ? q * q : (j[1] == 0 && j[2] == 1 && i[0] + 1 == j[0] ? this.p * q : (j[1] == 1 && j[2] == 0 && i[0] - 1 == j[0] ? this.p * q : (j[1] == 1 && j[2] == 1 && i[0] == j[0] ? this.p * this.p : 0.0)));
        }
        if (i[0] == 1 && i[1] == 0 && i[2] == 1) {
            pr = j[0] == 1 && i[1] == 0 && j[2] == 0 ? 1.0 : 0.0;
        }
        if (i[0] == 1 && i[1] == 0 && i[2] == 0) {
            pr = j[1] == 0 && j[2] == 0 && i[0] == j[0] ? q * q : (j[1] == 0 && j[2] == 1 && i[0] + 1 == j[0] ? this.p * q : (j[1] == 0 && j[2] == 1 && i[0] == j[0] ? this.p * q : (j[1] == 1 && j[2] == 1 && i[0] == j[0] ? this.p * this.p : 0.0)));
        }
        if (i[0] == this.picklocs - 1 && i[1] == 1 && i[2] == 0) {
            pr = j[0] == this.picklocs - 1 && j[1] == 0 && j[2] == 0 ? 1.0 : 0.0;
        }
        if (i[0] == this.picklocs - 1 && i[1] == 0 && i[2] == 0) {
            pr = j[1] == 0 && j[2] == 0 && i[0] == j[0] ? q * q : (j[1] == 1 && j[2] == 0 && i[0] == j[0] ? this.p * q : (j[1] == 1 && j[2] == 0 && i[0] - 1 == j[0] ? this.p * q : (j[1] == 1 && j[2] == 1 && i[0] == j[0] ? this.p * this.p : 0.0)));
        }
        return pr;
    }

    @Override
    public String description() {
        String stg = "NarrowSlow-Aisle-OPS \n\nThere are " + this.picklocs + " pick locations in the system\n";
        stg = String.valueOf(stg) + "There are 2 Pickers in the system.\n";
        stg = String.valueOf(stg) + "The pick/walk speed ratio is 1:1.\n";
        stg = String.valueOf(stg) + "The picking Probability is " + this.p + ".\n";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        stg = String.valueOf(stg) + sw.toString();
        return stg;
    }

    @Override
    public int printMOPs(PrintWriter out, int width, int decimals) {
        try {
            double[] busy = this.getSteadyState();
            out.printf("    Number of Pick Locations   = %6d ", this.picklocs);
            out.printf("\n    Number of Pickers          = %6d ", 2);
            out.printf("\n    Picking Probability        = %2.6f ", this.p);
            out.printf("\n    Percentage of Time Picker 1 is blocked    = %2.6f ", busy[1] * 100.0);
            out.printf("\n    Percentage of Time Picker 2 is blocked    = %2.6f ", busy[4 * this.picklocs - 6] * 100.0);
            out.println();
        }
        catch (NotUnichainException e) {
            out.println(e);
        }
        return 0;
    }

    public static void main(String[] a) {
        PickBlockNarrowSlow OPS = new PickBlockNarrowSlow();
        OPS.setDebugLevel(0);
        OPS.showGUI();
        OPS.printAll();
        OPS.printMOPs();
    }

    public double getProbability() {
        return this.p;
    }

    public int getPicklocs() {
        return this.picklocs;
    }
}

