/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.PickBlockNarrowContEvent;
import examples.jmarkov.PickBlockNarrowContState;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.NotUnichainException;

public class PickBlockNarrowCont
extends SimpleMarkovProcess<PickBlockNarrowContState, PickBlockNarrowContEvent> {
    private double p;
    private int picklocs;
    private double pickspeed1;
    private double walkspeed1;
    private double pickspeed2;
    private double walkspeed2;

    public PickBlockNarrowCont(double p, int picklocs, double pickspeed1, double walkspeed1, double pickspeed2, double walkspeed2, int[] a) {
        super(new PickBlockNarrowContState(a, picklocs), PickBlockNarrowContEvent.getAllEvents());
        this.p = p;
        this.picklocs = picklocs;
        this.pickspeed1 = pickspeed1;
        this.walkspeed1 = walkspeed1;
        this.pickspeed2 = pickspeed2;
        this.walkspeed2 = walkspeed2;
    }

    public PickBlockNarrowCont() {
        int[] nArray = new int[3];
        nArray[0] = 1;
        this(0.1, 6, 1.0, 5.0, 1.0, 5.0, nArray);
    }

    @Override
    public boolean active(PickBlockNarrowContState i, PickBlockNarrowContEvent e) {
        boolean result = false;
        if (i.getDistance() == 0 && i.getFirst() == 1) {
            switch (e.getType()) {
                case FIRSTPICKTOPICK: {
                    result = true;
                    break;
                }
                case FIRSTPICKTOWALK: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else if (i.getDistance() == 0 && i.getFirst() == 0) {
            switch (e.getType()) {
                case FIRSTWALKTOPICK: {
                    result = true;
                    break;
                }
                case FIRSTWALKTOWALK: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else if (i.getDistance() == this.picklocs && i.getSecond() == 0) {
            switch (e.getType()) {
                case SECWALKTOPICK: {
                    result = true;
                    break;
                }
                case SECWALKTOWALK: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else if (i.getDistance() == this.picklocs && i.getSecond() == 1) {
            switch (e.getType()) {
                case SECPICKTOPICK: {
                    result = true;
                    break;
                }
                case SECPICKTOWALK: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else if (i.getFirst() == 0 && i.getSecond() == 0) {
            switch (e.getType()) {
                case FIRSTWALKTOPICK: {
                    result = true;
                    break;
                }
                case FIRSTWALKTOWALK: {
                    result = true;
                    break;
                }
                case SECWALKTOPICK: {
                    result = true;
                    break;
                }
                case SECWALKTOWALK: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else if (i.getFirst() == 0 && i.getSecond() == 1) {
            switch (e.getType()) {
                case FIRSTWALKTOPICK: {
                    result = true;
                    break;
                }
                case FIRSTWALKTOWALK: {
                    result = true;
                    break;
                }
                case SECPICKTOPICK: {
                    result = true;
                    break;
                }
                case SECPICKTOWALK: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else if (i.getFirst() == 1 && i.getSecond() == 0) {
            switch (e.getType()) {
                case FIRSTPICKTOPICK: {
                    result = true;
                    break;
                }
                case FIRSTPICKTOWALK: {
                    result = true;
                    break;
                }
                case SECWALKTOPICK: {
                    result = true;
                    break;
                }
                case SECWALKTOWALK: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else if (i.getFirst() == 1 && i.getSecond() == 1) {
            switch (e.getType()) {
                case FIRSTPICKTOPICK: {
                    result = true;
                    break;
                }
                case FIRSTPICKTOWALK: {
                    result = true;
                    break;
                }
                case SECPICKTOPICK: {
                    result = true;
                    break;
                }
                case SECPICKTOWALK: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    @Override
    public States<PickBlockNarrowContState> dests(PickBlockNarrowContState i, PickBlockNarrowContEvent e) {
        int[] origin = i.getProperties();
        return new StatesSet<PickBlockNarrowContState>(i.Trans(origin, e));
    }

    @Override
    public double rate(PickBlockNarrowContState i, PickBlockNarrowContState j, PickBlockNarrowContEvent e) {
        int[] origin = i.getProperties();
        int[] dest = j.getProperties();
        PickBlockNarrowContEvent.Type a = e.getType();
        if (!this.active(i, e)) {
            return 0.0;
        }
        return this.getProbs(origin, dest, a);
    }

    public double getProbs(int[] i, int[] j, PickBlockNarrowContEvent.Type e) {
        double pr = 0.0;
        double q = 1.0 - this.p;
        if (i[1] == 0 && i[2] == 0) {
            switch (e) {
                case FIRSTWALKTOPICK: {
                    pr = this.p * this.walkspeed1;
                    break;
                }
                case FIRSTWALKTOWALK: {
                    pr = q * this.walkspeed1;
                    break;
                }
                case SECWALKTOPICK: {
                    pr = this.p * this.walkspeed2;
                    break;
                }
                case SECWALKTOWALK: {
                    pr = q * this.walkspeed2;
                    break;
                }
            }
        } else if (i[1] == 1 && i[2] == 0) {
            switch (e) {
                case FIRSTPICKTOPICK: {
                    pr = this.p * this.pickspeed1;
                    break;
                }
                case FIRSTPICKTOWALK: {
                    pr = q * this.pickspeed1;
                    break;
                }
                case SECWALKTOPICK: {
                    pr = this.p * this.walkspeed2;
                    break;
                }
                case SECWALKTOWALK: {
                    pr = q * this.walkspeed2;
                    break;
                }
            }
        } else if (i[1] == 0 && i[2] == 1) {
            switch (e) {
                case FIRSTWALKTOPICK: {
                    pr = this.p * this.walkspeed1;
                    break;
                }
                case FIRSTWALKTOWALK: {
                    pr = q * this.walkspeed1;
                    break;
                }
                case SECPICKTOPICK: {
                    pr = this.p * this.pickspeed2;
                    break;
                }
                case SECPICKTOWALK: {
                    pr = q * this.pickspeed2;
                    break;
                }
            }
        } else if (i[1] == 1 && i[2] == 1) {
            switch (e) {
                case FIRSTPICKTOPICK: {
                    pr = this.p * this.pickspeed1;
                    break;
                }
                case FIRSTPICKTOWALK: {
                    pr = q * this.pickspeed1;
                    break;
                }
                case SECPICKTOPICK: {
                    pr = this.p * this.pickspeed2;
                    break;
                }
                case SECPICKTOWALK: {
                    pr = q * this.pickspeed2;
                    break;
                }
            }
        }
        return pr;
    }

    @Override
    public String description() {
        String stg = "NarrowCont-Aisle-OPS \n\nThere are " + this.picklocs + " pick locations in the system\n\n";
        stg = String.valueOf(stg) + "There are 2 Pickers in the system.\n";
        stg = String.valueOf(stg) + "The pick and walk times are exponential RVs.\n";
        stg = String.valueOf(stg) + "The average pick speed of picker 1 is " + this.pickspeed1 + " locations per minute \n";
        stg = String.valueOf(stg) + "The average walk speed of picker 1 is " + this.walkspeed1 + " locations per minute\n";
        stg = String.valueOf(stg) + "The average pick speed of picker 2 is " + this.pickspeed2 + " locations per minute \n";
        stg = String.valueOf(stg) + "The average walk speed of picker 2 is " + this.walkspeed2 + " locations per minute\n";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        stg = String.valueOf(stg) + sw.toString();
        return stg;
    }

    @Override
    public int printMOPs(PrintWriter out, int width, int decimals) {
        try {
            double[] busy = this.getSteadyState();
            double bloq2 = busy[0] + busy[1] + busy[2] + busy[3];
            double bloq1 = busy[4 * this.picklocs] + busy[4 * this.picklocs + 1] + busy[4 * this.picklocs + 2] + busy[4 * this.picklocs + 3];
            out.printf("    Number of Pick Locations   = %6d ", this.picklocs);
            out.printf("\n    Number of Pickers          = %6d ", 2);
            out.printf("\n    Picking Probability        = %2.6f ", this.p);
            out.printf("\n    Percentage of Time Picker 1 is blocked    = %2.6f ", bloq1 * 100.0);
            out.printf("\n    Percentage of Time Picker 2 is blocked    = %2.6f ", bloq2 * 100.0);
            out.println();
        }
        catch (NotUnichainException e) {
            out.println(e);
        }
        return 0;
    }

    public static void main(String[] a) {
        PickBlockNarrowCont OPS = new PickBlockNarrowCont();
        OPS.setDebugLevel(0);
        OPS.showGUI();
        OPS.printAll();
        OPS.printMOPs();
    }

    public double getProbability() {
        return this.p;
    }

    public int getPicklocs() {
        return this.picklocs;
    }
}

