/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.PickBlockNarrowEvent;
import examples.jmarkov.PickBlockNarrowState;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.NotUnichainException;

public class PickBlockNarrow
extends SimpleMarkovProcess<PickBlockNarrowState, PickBlockNarrowEvent> {
    private double p;
    private int picklocs;

    public PickBlockNarrow(double p, int picklocs) {
        super(new PickBlockNarrowState(0, picklocs), PickBlockNarrowEvent.getAllEvents(picklocs));
        this.p = p;
        this.picklocs = picklocs;
    }

    public PickBlockNarrow() {
        this(0.5, 100);
    }

    @Override
    public boolean active(PickBlockNarrowState i, PickBlockNarrowEvent e) {
        boolean result = false;
        int stat = i.getDistance();
        int dest = stat + e.getShift();
        result = dest <= this.picklocs && dest >= 0;
        return result;
    }

    @Override
    public States<PickBlockNarrowState> dests(PickBlockNarrowState i, PickBlockNarrowEvent e) {
        int origin = i.getDistance();
        int dest = e.getShift();
        return new StatesSet<PickBlockNarrowState>(i.Trans(origin, dest));
    }

    @Override
    public double rate(PickBlockNarrowState i, PickBlockNarrowState j, PickBlockNarrowEvent e) {
        int origin = i.getDistance();
        int shift = e.getShift();
        int dest = origin + shift;
        return this.getProbs(origin, dest);
    }

    public double getProbs(int i, int j) {
        double prob = 0.0;
        double q = 1.0 - this.p;
        if (i == 0) {
            i = 1;
        } else if (i == this.picklocs) {
            i = this.picklocs - 1;
        }
        prob = Math.pow(q, Math.abs(i - j)) / (1.0 + q);
        if (j != 0 && j != this.picklocs) {
            prob *= this.p;
        }
        return prob;
    }

    @Override
    public String description() {
        String stg = "Narrow-Aisle-OPS \n\nThere are " + this.picklocs + " pick locations in the system\n";
        stg = String.valueOf(stg) + "There are 2 Pickers in the system.\n";
        stg = String.valueOf(stg) + "The pick/walk speed ratio is 1:infinity.\n";
        stg = String.valueOf(stg) + "Picking Probability is " + this.p + ".";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        stg = String.valueOf(stg) + sw.toString();
        return stg;
    }

    @Override
    public int printMOPs(PrintWriter out, int width, int decimals) {
        try {
            double[] busy = this.getSteadyState();
            out.printf("    Number of Pick Locations   = %6d ", this.picklocs);
            out.printf("\n    Number of Pickers          = %6d ", 2);
            out.printf("\n    Picking Probability        = %6.4f ", this.p);
            out.printf("\n    Percentage of Time Picker 1 is Blocked   = %3.6f ", busy[0] * 100.0);
            out.printf("\n    Percentage of Time Picker 2 is Blocked    = %3.6f ", busy[this.picklocs] * 100.0);
            out.println();
        }
        catch (NotUnichainException e) {
            out.println(e);
        }
        return 0;
    }

    public static void main(String[] a) {
        PickBlockNarrow OPS = new PickBlockNarrow();
        OPS.setDebugLevel(0);
        OPS.showGUI();
        OPS.printAll();
        OPS.printMOPs();
    }

    public double getProbability() {
        return this.p;
    }

    public int getPicklocs() {
        return this.picklocs;
    }
}

