/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.basic.Event;
import jmarkov.basic.EventsSet;
import jphase.PhaseVar;

class PHLineEvent
extends Event {
    Type type;
    private int station;
    private int curPH;

    PHLineEvent() {
        this.type = Type.ARRIVAL;
        this.station = 0;
    }

    PHLineEvent(Type type, int station, int phase) {
        this.type = type;
        this.curPH = phase;
        this.station = station;
    }

    public int getCurPH() {
        if (this.type == Type.ARRIVAL) {
            throw new IllegalArgumentException("Current phase is not defined for event " + (Object)((Object)Type.ARRIVAL));
        }
        return this.curPH;
    }

    public int getStation() {
        return this.station;
    }

    public Type getType() {
        return this.type;
    }

    static EventsSet<PHLineEvent> getAllEvents(PhaseVar[] phaseVars) {
        EventsSet<PHLineEvent> E = new EventsSet<PHLineEvent>();
        E.add(new PHLineEvent());
        int numStats = phaseVars.length;
        int s = 0;
        while (s < numStats) {
            int numPhases = phaseVars[s].getNumPhases();
            int n = 1;
            while (n <= numPhases) {
                E.add(new PHLineEvent(Type.CHANGE_PHASE, s, n));
                E.add(new PHLineEvent(Type.FINISH_AND_IDLE, s, n));
                E.add(new PHLineEvent(Type.FINISH_AND_RESTART, s, n));
                E.add(new PHLineEvent(Type.FINISH_AND_IDLE_MOVE, s, n));
                E.add(new PHLineEvent(Type.FINISH_AND_RESTART_MOVE, s, n));
                ++n;
            }
            ++s;
        }
        return E;
    }

    @Override
    public String label() {
        String stg = "";
        switch (this.type) {
            case ARRIVAL: {
                stg = "Arrival";
                break;
            }
            case CHANGE_PHASE: {
                stg = "Ph(" + (this.station + 1) + "," + this.curPH + ")";
                break;
            }
            case FINISH_AND_IDLE: {
                stg = "End(" + (this.station + 1) + "," + this.curPH + ")";
                break;
            }
            case FINISH_AND_IDLE_MOVE: {
                stg = "End(" + (this.station + 1) + "," + this.curPH + ",M)";
            }
            case FINISH_AND_RESTART: {
                stg = "End(" + (this.station + 1) + "," + this.curPH + ",R)";
            }
            case FINISH_AND_RESTART_MOVE: {
                stg = "End(" + (this.station + 1) + "," + this.curPH + ",R & M)";
            }
        }
        return stg;
    }

    public static enum Type {
        ARRIVAL,
        CHANGE_PHASE,
        FINISH_AND_IDLE,
        FINISH_AND_RESTART,
        FINISH_AND_IDLE_MOVE,
        FINISH_AND_RESTART_MOVE;

    }
}

