/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.PropertiesState;

class MM2dNState
extends PropertiesState {
    MM2dNState(int x, int y, int z) {
        super(3);
        this.prop[0] = x;
        this.prop[1] = y;
        this.prop[2] = z;
    }

    @Override
    public void computeMOPs(MarkovProcess mp) {
        this.setMOP(mp, "Status Server 1", this.getStatus1());
        this.setMOP(mp, "Status Server 2", this.getStatus2());
        this.setMOP(mp, "Queue Length", this.getQSize());
        this.setMOP(mp, "Number in System", this.getStatus1() + this.getStatus2() + this.getQSize());
    }

    public int getStatus1() {
        return this.prop[0];
    }

    public int getStatus2() {
        return this.prop[1];
    }

    public int getQSize() {
        return this.prop[2];
    }

    boolean isEmpty() {
        return this.getStatus1() + this.getStatus2() + this.getQSize() == 0;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public String label() {
        String stg = "0";
        if (this.getStatus1() == 1 && this.getStatus2() == 0) {
            stg = "1A";
        }
        if (this.getStatus2() == 1 && this.getStatus1() == 0) {
            stg = "1B";
        }
        if (this.getStatus2() == 1 && this.getStatus1() == 1) {
            stg = "" + (2 + this.getQSize());
        }
        return stg;
    }

    @Override
    public String description() {
        String stg = "";
        stg = String.valueOf(stg) + "Server 1 is " + (this.getStatus1() == 1 ? "busy" : "idle");
        stg = String.valueOf(stg) + ". Server 2 is " + (this.getStatus2() == 1 ? "busy" : "idle");
        stg = String.valueOf(stg) + ". There are " + this.getQSize() + " customers waiting in queue.";
        return stg;
    }
}

