/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.PropertiesState;

class KanbanState
extends PropertiesState {
    KanbanState(int[] status, int[] buffer, int[] kanbans) {
        super(status.length + (buffer.length - 1) + kanbans.length);
        int m = status.length;
        int i = 0;
        while (i < m) {
            this.prop[i] = status[i];
            ++i;
        }
        i = 0;
        while (i < m - 1) {
            this.prop[i + m] = buffer[i + 1];
            ++i;
        }
        i = 1;
        while (i < m) {
            this.prop[i + 2 * (m - 1)] = kanbans[i - 1];
            ++i;
        }
    }

    @Override
    public void computeMOPs(MarkovProcess mp) {
        int m = this.getNumStations();
        int i = 0;
        while (i < m) {
            this.setMOP(mp, "Server utilization " + (i + 1), this.getStatus(i));
            ++i;
        }
        i = 0;
        while (i < m - 1) {
            this.setMOP(mp, "WIP in Kanbans " + (i + 1), this.getKanban(i));
            ++i;
        }
        i = 1;
        while (i < m) {
            this.setMOP(mp, "WIP in Buffer " + i, this.getBuffer(i));
            ++i;
        }
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    public int getStatus(int i) {
        return this.prop[i];
    }

    public int getBuffer(int i) {
        int m = (this.prop.length + 2) / 3;
        return this.prop[i + (m - 1)];
    }

    public int getKanban(int i) {
        int m = this.getNumStations();
        return this.prop[i + 1 + 2 * (m - 1)];
    }

    public int getNumStations() {
        return (this.prop.length + 2) / 3;
    }

    @Override
    public String label() {
        String stg = "";
        int m = (this.prop.length + 1) / 3 + 1;
        int i = 0;
        while (i < m) {
            stg = String.valueOf(stg) + "S" + (i + 1) + "(" + this.getStatus(i) + "," + (i > 0 ? "" + this.getBuffer(i) : "*") + "," + (i < m - 1 ? "" + this.getKanban(i) : "*") + ")";
            ++i;
        }
        return stg;
    }

    @Override
    public String description() {
        String stg = "";
        int m = (this.prop.length + 1) / 3 + 1;
        int i = 0;
        while (i < m) {
            stg = String.valueOf(stg) + "STATION " + (i + 1) + "= (Status: " + this.getStatus(i) + ", Buffer: " + (i > 0 ? "" + this.getBuffer(i) : "*") + ", Kanbans: " + (i < m - 1 ? "" + this.getKanban(i) : "*") + ")  ";
            ++i;
        }
        return stg;
    }
}

