/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import Jama.Matrix;
import examples.jmarkov.JacksonEvent;
import examples.jmarkov.JacksonState;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.Event;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.NotUnichainException;

public class Jackson
extends SimpleMarkovProcess<JacksonState, JacksonEvent> {
    private double[][] probs;
    private double[] mus;
    private int[] numServers;
    private int[] wip;
    private int numStations;

    public Jackson(String filewip, String fileservers, String fileservicesrates, String fileprob) {
        this(Jackson.loadInt(filewip), Jackson.loadInt(fileservers), Jackson.loadDouble(fileservicesrates), Jackson.loadMatrix(fileprob));
    }

    public Jackson() {
        this("JacksonFiles/Wiplevel.txt", "JacksonFiles/Numservers.txt", "JacksonFiles/Servicesrates.txt", "JacksonFiles/Probabilities.txt");
    }

    public Jackson(int[] wip, int[] servers, double[] srvRates, double[][] probabilities) {
        super(new JacksonState(wip), JacksonEvent.getAllEvents(wip.length, probabilities));
        this.numStations = wip.length;
        this.wip = wip;
        this.numServers = servers;
        this.mus = srvRates;
        this.probs = probabilities;
    }

    public Jackson(int wip, int M, int[] servers, double[] srvRates) {
        this(Jackson.initWip(wip, M), servers, srvRates, Jackson.flowProb(M));
    }

    public Jackson(int wip, int M, double[] srvRates) {
        this(Jackson.initWip(wip, M), Jackson.initSingleServers(M), srvRates, Jackson.flowProb(M));
    }

    public Jackson(int wip, int M, double[] srvRates, double[][] prob) {
        this(Jackson.initWip(wip, M), Jackson.initSingleServers(M), srvRates, prob);
    }

    private static int[] initWip(int wip, int M) {
        int[] wipp = new int[M];
        wipp[0] = wip;
        return wipp;
    }

    private static int[] initSingleServers(int M) {
        int[] srv = new int[M];
        int i = 0;
        while (i < M) {
            srv[i] = 1;
            ++i;
        }
        return srv;
    }

    private static double[][] flowProb(int M) {
        double[][] prob = new double[M][M];
        int i = 0;
        while (i < M - 1) {
            prob[i][i + 1] = 1.0;
            ++i;
        }
        prob[M - 1][0] = 1.0;
        return prob;
    }

    public static Matrix loadJamaMatrix(String fileName) {
        Matrix Mat = null;
        File fil = null;
        try {
            URL url = Jackson.class.getResource(fileName);
            fil = new File(url.toURI());
            System.out.println("Reading file: " + fil.getAbsolutePath());
            Mat = Matrix.read((BufferedReader)new BufferedReader(new FileReader(fil)));
        }
        catch (Exception e) {
            System.out.println("Unable to read the file " + fil.getAbsolutePath() + "\n");
            e.printStackTrace();
            System.exit(0);
        }
        return Mat;
    }

    public static int[] loadInt(String fileName) {
        int[] temp2 = null;
        Matrix C = Jackson.loadJamaMatrix(fileName);
        double[] temp1 = C.getRowPackedCopy();
        int N = temp1.length;
        temp2 = new int[N];
        int i = 0;
        while (i < temp1.length) {
            temp2[i] = (int)temp1[i];
            ++i;
        }
        return temp2;
    }

    public static double[] loadDouble(String fileName) {
        Matrix C = Jackson.loadJamaMatrix(fileName);
        return C.getRowPackedCopy();
    }

    public static double[][] loadMatrix(String fileName) {
        Matrix C = Jackson.loadJamaMatrix(fileName);
        return C.getArrayCopy();
    }

    @Override
    public boolean active(JacksonState i, JacksonEvent e) {
        boolean result = false;
        int origin = e.getOrigin();
        int dest = e.getDest();
        result = i.getWip(origin) > 0 && this.probs[origin][dest] > 0.0;
        return result;
    }

    @Override
    public States<JacksonState> dests(JacksonState i, JacksonEvent e) {
        int origin = e.getOrigin();
        int dest = e.getDest();
        return new StatesSet<JacksonState>(i.Trans(origin, dest));
    }

    @Override
    public double rate(JacksonState i, JacksonState j, JacksonEvent e) {
        int origin = e.getOrigin();
        int dest = e.getDest();
        return this.mus[origin] * (double)Math.min(i.getWip(origin), this.numServers[origin]) * this.probs[origin][dest];
    }

    @Override
    public String description() {
        int totWIP = 0;
        int i = 0;
        while (i < this.numStations) {
            totWIP += this.wip[i];
            ++i;
        }
        String stg = "CLOSED JACKSON NETWORK \n\nThere are " + totWIP + " units in the system\n\n";
        int i2 = 0;
        while (i2 < this.numStations) {
            stg = String.valueOf(stg) + "WorkStation " + (i2 + 1) + ":\n " + this.numServers[i2] + " Exponential servers with service rate " + this.mus[i2] + "\n";
            ++i2;
        }
        stg = String.valueOf(stg) + "Transition Probabilities:\n";
        Matrix probMat = new Matrix(this.probs);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        probMat.print(pw, 7, 4);
        stg = String.valueOf(stg) + sw.toString();
        return stg;
    }

    public double[] effLambdas() throws NotUnichainException {
        Event[] events;
        double[] sums = new double[this.numStations];
        Event[] eventArray = events = this.getEvents();
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            Event ev = eventArray[n2];
            JacksonEvent e = (JacksonEvent)ev;
            int n3 = e.getOrigin();
            sums[n3] = sums[n3] + this.getEventRate(e.getIndex());
            ++n2;
        }
        return sums;
    }

    @Override
    public int printMOPs(PrintWriter out, int width, int decimals) {
        try {
            double[] lambda = this.effLambdas();
            int i = 0;
            while (i < this.numStations) {
                out.println("STATION " + (i + 1) + ":");
                double wip = this.getMOPsAvg("Average WIP at the buffer " + (i + 1));
                double busyServers = this.getMOPsAvg("Busy Servers at Station " + (i + 1));
                double numInQ = wip - busyServers;
                double queueTime = numInQ / lambda[i];
                double flowTime = wip / lambda[i];
                double rho = busyServers / (double)this.numServers[i];
                out.printf("    Throughput        = %6.4f ", lambda[i]);
                out.printf("\n    Avg. WIP          = %6.4f ", wip);
                out.printf("\n    Avg. Flow Time    = %6.4f ", flowTime);
                out.printf("\n    Avg. Num in Queue = %6.4f ", numInQ);
                out.printf("\n    Avg. Queue Time   = %6.4f ", queueTime);
                out.printf("\n    Avg. Busy Servers = %6.4f ", busyServers);
                out.printf("\n    Avg. Utilization  = %6.4f ", rho);
                out.println();
                ++i;
            }
        }
        catch (NotUnichainException e) {
            out.println(e);
        }
        return 0;
    }

    public static void main(String[] a) {
        String file1 = "";
        String file2 = "";
        String file3 = "";
        String file4 = "";
        if (a.length < 4) {
            file1 = "JacksonFiles/Wiplevel.txt";
            file2 = "JacksonFiles/Numservers.txt";
            file3 = "JacksonFiles/Servicesrates.txt";
            file4 = "JacksonFiles/Probabilities.txt";
        } else {
            file1 = a[0];
            file2 = a[1];
            file3 = a[2];
            file4 = a[3];
        }
        Jackson theNet = new Jackson(file1, file2, file3, file4);
        theNet.setDebugLevel(1);
        theNet.showGUI();
        theNet.printAll();
    }

    public int[] getNumServers() {
        return this.numServers;
    }

    public int getNumStations() {
        return this.numStations;
    }
}

