/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.PropertiesState;

class ErlangQueueState
extends PropertiesState {
    int N;
    int M;

    public ErlangQueueState(int M, int N) {
        this(new int[N], N, M);
    }

    public ErlangQueueState(int[] status, int N, int M) {
        super(status);
        this.N = N;
        this.M = M;
    }

    @Override
    public void computeMOPs(MarkovProcess mp) {
        this.setMOP(mp, "Queue Length", 1.0);
    }

    public int getProp(int i) {
        return this.prop[i];
    }

    public int getIdle() {
        int aux = -1;
        int i = 0;
        while (i < this.N) {
            if (this.prop[i] == 0) {
                aux = i;
            }
            ++i;
        }
        return aux;
    }

    public double prob() {
        double aux = 0.0;
        double prob = 1.0;
        int i = 0;
        while (i < this.N) {
            if (this.prop[i] == 0) {
                aux += 1.0;
            }
            ++i;
        }
        if (aux != 0.0) {
            prob = 1.0 / aux;
            return prob;
        }
        return prob;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public String description() {
        String stg = "";
        int k = 0;
        while (k < this.N) {
            stg = String.valueOf(stg) + " Server: ";
            stg = String.valueOf(stg) + (k + 1) + " Phase: " + this.prop[k] + " ";
            ++k;
        }
        return stg;
    }

    @Override
    public String label() {
        String stg = "";
        int k = 0;
        while (k < this.N) {
            stg = String.valueOf(stg) + this.prop[k] + (k != this.N - 1 ? "," : "");
            ++k;
        }
        return stg;
    }
}

