/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.ErlangQueueEvent;
import examples.jmarkov.ErlangQueueState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import jmarkov.GeomProcess;
import jmarkov.GeomRelState;
import jmarkov.basic.StatesSet;

public class ErlangQueue
extends GeomProcess<ErlangQueueState, ErlangQueueEvent> {
    double lambda;
    double mu;
    int N;
    int M;
    static final int ARRIVAL = 1;
    static final int DEPARTURE = 2;
    static final int PHASECHANGE = 3;

    public ErlangQueue(double lambda, double mu, int N, int M) {
        super(new ErlangQueueState(M, N), ErlangQueueEvent.getAllEvents(N));
        this.lambda = lambda;
        this.mu = mu;
        this.N = N;
        this.M = M;
    }

    @Override
    public boolean active(ErlangQueueState i, int iLevel, ErlangQueueEvent e) {
        boolean result = false;
        switch (e.type) {
            case 1: {
                result = true;
                break;
            }
            case 2: {
                if (i.getProp(e.server) != this.M) break;
                result = true;
                break;
            }
            case 3: {
                if (i.getProp(e.server) == 0 || i.getProp(e.server) == this.M) break;
                result = true;
            }
        }
        return result;
    }

    @Override
    public GeomRelState<ErlangQueueState>[] dests(ErlangQueueState i, int absLevel, ErlangQueueEvent e) {
        StatesSet destStates = new StatesSet();
        int[] props = i.getProperties();
        int rLevel = 0;
        switch (e.type) {
            case 1: {
                if (i.getIdle() != -1) {
                    int k = 0;
                    while (k < this.N) {
                        if (props[k] == 0) {
                            props[k] = 1;
                            destStates.add(new GeomRelState<ErlangQueueState>(new ErlangQueueState(props, this.N, this.M), rLevel));
                            props[k] = 0;
                        }
                        ++k;
                    }
                }
                if (i.getIdle() != -1) break;
                rLevel = 1;
                destStates.add(new GeomRelState<ErlangQueueState>(new ErlangQueueState(props, this.N, this.M), rLevel));
                break;
            }
            case 2: {
                if (absLevel == 0) {
                    props[e.server] = 0;
                    destStates.add(new GeomRelState<ErlangQueueState>(new ErlangQueueState(props, this.N, this.M), rLevel));
                    break;
                }
                rLevel = -1;
                props[e.server] = 1;
                destStates.add(new GeomRelState<ErlangQueueState>(new ErlangQueueState(props, this.N, this.M), rLevel));
                break;
            }
            case 3: {
                rLevel = 0;
                int n = e.server;
                props[n] = props[n] + 1;
                destStates.add(new GeomRelState<ErlangQueueState>(new ErlangQueueState(props, this.N, this.M), rLevel));
            }
        }
        return (GeomRelState[])destStates.toStateArray();
    }

    @Override
    public double rate(ErlangQueueState i, int iLevel, ErlangQueueState j, int jLevel, ErlangQueueEvent e) {
        double rate = -1.0;
        switch (e.type) {
            case 1: {
                rate = this.lambda * i.prob();
                break;
            }
            case 2: {
                rate = this.mu;
                break;
            }
            case 3: {
                rate = this.mu;
            }
        }
        return rate;
    }

    @Override
    public String description() {
        return "Erlang queue with " + this.N + " Servers and " + this.M + " Phases";
    }

    public static void main(String[] args) {
        double lambda = 0.0;
        double mu = 0.0;
        int M = 0;
        int N = 0;
        BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
        try {
            System.out.println("Arrival Rate: ");
            lambda = Double.parseDouble(rdr.readLine());
            System.out.println("Service Mean time in minutes: ");
            mu = Double.parseDouble(rdr.readLine());
            System.out.println("Total Serves: ");
            N = Integer.parseInt(rdr.readLine());
            System.out.println("Total Phases: ");
            M = Integer.parseInt(rdr.readLine());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        mu = (double)(M * 60) / mu;
        ErlangQueue TheModel = new ErlangQueue(lambda, mu, N, M);
        TheModel.showGUI();
        TheModel.setDebugLevel(4);
        TheModel.generate();
        TheModel.printDenseMatrix(new PrintWriter(System.out));
        TheModel.printAll();
    }
}

