/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.basic.Event;
import jmarkov.basic.EventsSet;

class DriveThruEvent
extends Event {
    private Type type;
    private int position;

    public DriveThruEvent(Type type) {
        assert (type == Type.ARRIVAL || type == Type.MIC_COMPLETION);
        this.type = type;
    }

    public DriveThruEvent(int position) {
        this.type = Type.SERVICE_COMPLETION;
        this.position = position;
    }

    public int getPos() {
        assert (this.type == Type.SERVICE_COMPLETION);
        return this.position;
    }

    public Type getType() {
        return this.type;
    }

    public static EventsSet<DriveThruEvent> getAllEvents(int micPos) {
        EventsSet<DriveThruEvent> eSet = new EventsSet<DriveThruEvent>();
        eSet.add(new DriveThruEvent(Type.ARRIVAL));
        eSet.add(new DriveThruEvent(Type.MIC_COMPLETION));
        int i = 0;
        while (i <= micPos) {
            eSet.add(new DriveThruEvent(i));
            ++i;
        }
        return eSet;
    }

    @Override
    public String label() {
        String stg = "";
        switch (this.type) {
            case ARRIVAL: {
                stg = "Arrival";
                break;
            }
            case MIC_COMPLETION: {
                stg = "MicEnd";
                break;
            }
            default: {
                stg = "SrvEnd(" + this.position + ")";
            }
        }
        return stg;
    }

    public static enum Type {
        ARRIVAL,
        MIC_COMPLETION,
        SERVICE_COMPLETION;

    }
}

