/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.PropertiesState;

class BucketStateBuf
extends PropertiesState {
    private static int M;
    private static int N;

    public BucketStateBuf(int numWorkers, int numMachines) {
        super(2 * numWorkers + 2 * numMachines);
        M = numMachines;
        N = numWorkers;
        int i = 0;
        while (i < numWorkers) {
            this.prop[i] = 0;
            this.prop[i + numWorkers] = 0;
            ++i;
        }
        this.prop[2 * numWorkers - 1] = 1;
        i = 1;
        while (i < numMachines) {
            this.prop[2 * numWorkers + i] = 0;
            ++i;
        }
        this.prop[2 * numWorkers] = 1;
    }

    public BucketStateBuf(int[] machines, int[] workerStatus, int[] machineStatus, int[] numInBuffers) {
        super(2 * machines.length + 2 * machineStatus.length);
        System.arraycopy(machines, 0, this.prop, 0, N);
        System.arraycopy(workerStatus, 0, this.prop, N, N);
        System.arraycopy(machineStatus, 0, this.prop, 2 * N, M);
        System.arraycopy(numInBuffers, 0, this.prop, 2 * N + M, M);
    }

    public BucketStateBuf(int[] machines, int[] numInBuffers) {
        this(machines, BucketStateBuf.getWorkerStatus(machines), BucketStateBuf.getMachineStatus(machines), numInBuffers);
    }

    @Override
    public void computeMOPs(MarkovProcess mp) {
        int sumWrks = 0;
        int sumBuf = 0;
        int i = 0;
        while (i < N) {
            int j = 0;
            while (j < M) {
                this.setMOP(mp, "Machine " + (j + 1) + " used by worker " + (i + 1), this.isWkrAtMachine(i, j) ? 1 : 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < N) {
            sumWrks += this.getWorkerStatus(i);
            this.setMOP(mp, "Status Worker " + (i + 1), this.getWorkerStatus(i));
            ++i;
        }
        i = 0;
        while (i < M) {
            this.setMOP(mp, "Status Machine" + (i + 1), this.getMachineStatus(i));
            ++i;
        }
        i = 1;
        while (i < M) {
            this.setMOP(mp, "Units in Buffer" + (i + 1), this.getBuffer(i));
            sumBuf += this.getBuffer(i);
            ++i;
        }
        this.setMOP(mp, "Number of active workers in the system", sumWrks);
        this.setMOP(mp, "Number of total units in buffer", sumBuf);
    }

    public final boolean isWkrAtMachine(int worker, int machine) {
        return this.prop[worker] == machine;
    }

    public final int getMachine(int k) {
        return this.prop[k];
    }

    public final int[] getMachines() {
        int[] MaqOp = new int[N];
        System.arraycopy(this.prop, 0, MaqOp, 0, N);
        return MaqOp;
    }

    public final int getWorkerStatus(int i) {
        return this.prop[i + N];
    }

    public final int getMachineStatus(int j) {
        return this.prop[j + 2 * N];
    }

    public final int getBuffer(int j) {
        assert (j >= 0 && j < M);
        return this.prop[j + 2 * N + M];
    }

    public final int[] getBuffers() {
        int[] buffers = new int[M];
        System.arraycopy(this.prop, 2 * N + M, buffers, 0, M);
        return buffers;
    }

    public BucketStateBuf moveBackwards(int j, int[] machines, int[] buffers) {
        int[] newMachines = new int[N];
        int[] newBuffers = new int[M];
        System.arraycopy(machines, 0, newMachines, 0, N);
        System.arraycopy(buffers, 0, newBuffers, 0, M);
        if (j > 0 && machines[j - 1] == machines[j]) {
            return this.moveBackwards(j - 1, newMachines, newBuffers);
        }
        if (this.getBuffer(machines[j]) > 0 && (this.getMachineStatus(machines[j]) == 0 || machines[j] == 0)) {
            int n = machines[j];
            newBuffers[n] = newBuffers[n] - 1;
        } else {
            if (j > 0 && machines[j - 1] != machines[j] && this.getMachineStatus(machines[j] - 1) == 0 && this.getBuffer(machines[j]) == 0) {
                int n = j;
                newMachines[n] = newMachines[n] - 1;
                return this.moveBackwards(j, newMachines, newBuffers);
            }
            if (j > 0 && this.getBuffer(machines[j]) == 0 && this.getMachineStatus(machines[j] - 1) == 1) {
                int n = j;
                newMachines[n] = newMachines[n] - 1;
                return this.moveBackwards(j - 1, newMachines, newBuffers);
            }
            if (!(j == 0 & machines[j] == 0)) {
                int n = j;
                newMachines[n] = newMachines[n] - 1;
                return this.moveBackwards(j, newMachines, newBuffers);
            }
        }
        return new BucketStateBuf(newMachines, newBuffers);
    }

    @Override
    public String label() {
        String stg = "";
        int i = 0;
        while (i < N) {
            stg = String.valueOf(stg) + (this.getMachine(i) + 1);
            ++i;
        }
        stg = String.valueOf(stg) + "/";
        int j = 1;
        while (j < M) {
            stg = String.valueOf(stg) + this.getBuffer(j);
            ++j;
        }
        return stg;
    }

    @Override
    public String description() {
        String stg = "Machines (";
        int i = 0;
        while (i < N) {
            stg = String.valueOf(stg) + (this.getMachine(i) + 1);
            ++i;
        }
        stg = String.valueOf(stg) + ") Buf. (";
        i = 1;
        while (i < M) {
            stg = String.valueOf(stg) + this.getBuffer(i);
            ++i;
        }
        stg = String.valueOf(stg) + "). Act.Wkrs. = {";
        i = 0;
        while (i < N) {
            stg = String.valueOf(stg) + (this.getWorkerStatus(i) == 1 ? String.valueOf(i + 1) + " " : "");
            ++i;
        }
        stg = String.valueOf(stg) + "} Act. Mach. {";
        int j = 0;
        while (j < M) {
            stg = String.valueOf(stg) + (this.getMachineStatus(j) == 1 ? String.valueOf(j + 1) + " " : "");
            ++j;
        }
        stg = String.valueOf(stg) + "}";
        return stg;
    }

    @Override
    public boolean isConsistent() {
        boolean result = true;
        return result;
    }

    private static int[] getWorkerStatus(int[] machines) {
        int[] workersStatus = new int[N];
        workersStatus[BucketStateBuf.N - 1] = 1;
        int i = N - 2;
        while (i >= 0) {
            if (machines[i] != machines[i + 1]) {
                workersStatus[i] = 1;
            }
            --i;
        }
        return workersStatus;
    }

    private static int[] getMachineStatus(int[] machines) {
        int[] StatusMaq = new int[M];
        int i = 0;
        while (i < N) {
            StatusMaq[machines[i]] = 1;
            ++i;
        }
        return StatusMaq;
    }
}

