/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import Jama.Matrix;
import examples.jmarkov.BucketEventBuf;
import examples.jmarkov.BucketStateBuf;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;

public class BucketBuffers
extends SimpleMarkovProcess<BucketStateBuf, BucketEventBuf> {
    private int N;
    private int M;
    private double[][] mu;
    private int[] capBuffers;

    private BucketBuffers(int N, int M, double[][] mu, int[] capBuffers) {
        super(new BucketStateBuf(N, M), BucketEventBuf.getAllEvents(M));
        this.M = M;
        this.N = N;
        this.mu = mu;
        this.capBuffers = capBuffers;
        assert (mu.length == N);
        assert (mu[0].length == M);
        assert (capBuffers.length == M);
    }

    public BucketBuffers(double[][] mu, int[] capBuffers) {
        this(mu.length, capBuffers.length, mu, capBuffers);
    }

    public BucketBuffers(String ratesFile, String buffersFile) throws IOException {
        this(BucketBuffers.loadRateMatrix(ratesFile), BucketBuffers.loadBuffers(buffersFile));
    }

    public BucketBuffers() throws IOException {
        this("BucketFiles/Mu2.txt", "BucketFiles/Buf2.txt");
    }

    @Override
    public boolean active(BucketStateBuf i, BucketEventBuf e) {
        return i.getMachineStatus(e.getMachine()) == 1;
    }

    @Override
    public States<BucketStateBuf> dests(BucketStateBuf i, BucketEventBuf e) {
        int[] newMachines = i.getMachines();
        int[] newBuffers = i.getBuffers();
        int evtWorker = this.getWorkerEvt(i, e.getMachine());
        if (e.getMachine() < this.M - 1 && i.getMachineStatus(e.getMachine() + 1) == 0) {
            newMachines[evtWorker] = e.getMachine() + 1;
        } else if (e.getMachine() < this.M - 1 && i.getMachineStatus(e.getMachine() + 1) == 1 && !this.spaceInBuffer(e.getMachine() + 1, i)) {
            newMachines[evtWorker] = e.getMachine() + 1;
        } else {
            if (e.getMachine() < this.M - 1 && i.getMachineStatus(e.getMachine() + 1) == 1 && this.spaceInBuffer(e.getMachine() + 1, i)) {
                int n = e.getMachine() + 1;
                newBuffers[n] = newBuffers[n] + 1;
                return new StatesSet<BucketStateBuf>(i.moveBackwards(evtWorker, newMachines, newBuffers));
            }
            assert (e.getMachine() == this.M - 1);
            return new StatesSet<BucketStateBuf>(i.moveBackwards(evtWorker, newMachines, newBuffers));
        }
        return new StatesSet<BucketStateBuf>(new BucketStateBuf(newMachines, newBuffers));
    }

    @Override
    public double rate(BucketStateBuf i, BucketStateBuf j, BucketEventBuf e) {
        return this.mu[this.getWorkerEvt(i, e.getMachine())][e.getMachine()];
    }

    private boolean spaceInBuffer(int i, BucketStateBuf s) {
        return s.getBuffer(i) < this.capBuffers[i];
    }

    @Override
    public String description() {
        String stg = "  ";
        stg = String.valueOf(stg) + "Bucket Brigades Production System with " + this.M + " Machines and " + this.N + " Workers\n";
        stg = String.valueOf(stg) + "\nMatrix Mu: Process rate of worker w. on machine m. \n      ";
        int i = 0;
        while (i < this.M) {
            stg = String.valueOf(stg) + "M" + i + "  ";
            ++i;
        }
        stg = String.valueOf(stg) + "\n";
        i = 0;
        while (i < this.N) {
            stg = String.valueOf(stg) + "N" + i + "  ";
            int j = 0;
            while (j < this.M) {
                stg = String.valueOf(stg) + this.mu[i][j] + " ";
                ++j;
            }
            stg = String.valueOf(stg) + "\n";
            ++i;
        }
        stg = String.valueOf(stg) + "\nB.C. ";
        i = 1;
        while (i < this.M) {
            stg = String.valueOf(stg) + this.capBuffers[i] + "   ";
            ++i;
        }
        return stg;
    }

    int getWorkerEvt(BucketStateBuf s, int m) {
        int result = 0;
        int i = 0;
        while (i < this.N) {
            if (s.getMachine(i) == m) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    private static int[] loadBuffers(String fileBuf) throws IOException {
        double[] buf = null;
        try {
            Matrix Buf = Matrix.read((BufferedReader)new BufferedReader(new FileReader(fileBuf)));
            buf = Buf.getRowPackedCopy();
        }
        catch (IOException e) {
            throw new IOException("Unable to read " + fileBuf);
        }
        int m = buf.length + 1;
        int[] buffy = new int[m];
        int i = 1;
        while (i < m) {
            buffy[i] = (int)buf[i - 1];
            ++i;
        }
        return buffy;
    }

    private static double[][] loadRateMatrix(String fileMu) throws IOException {
        double[][] mu = null;
        try {
            Matrix muMatrix = Matrix.read((BufferedReader)new BufferedReader(new FileReader(fileMu)));
            mu = muMatrix.getArrayCopy();
        }
        catch (IOException e) {
            throw new IOException("Unable to read " + fileMu);
        }
        return mu;
    }

    public static void main(String[] args) throws IOException {
        String fileMu = "BucketFiles/Mu2.txt";
        String fileBuf = "BucketFiles/Buf2.txt";
        BucketBuffers theModel = new BucketBuffers(fileMu, fileBuf);
        theModel.setDebugLevel(4);
        theModel.generate();
    }
}

