/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.BankEvent;
import examples.jmarkov.BankState;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.NotUnichainException;

class BankProcess
extends SimpleMarkovProcess<BankState, BankEvent> {
    double[] lambda;
    double[] mu;
    double[] Prob;
    int M;
    int S;
    int K;
    int MaxVIPQ;
    int MaxOTHERQ;
    private static final int VIPARRIVAL = 1;
    private static final int OTHERARRIVAL = 2;
    private static final int VIPDEPARTURE = 3;
    private static final int OTHERDEPARTURE = 4;

    public BankProcess(double[] lambda, double[] mu, double[] Prob, int M, int S, int K, int MaxVIPQ, int MaxOTHERQ) {
        super(new BankState(M, S, K), BankEvent.getAllEvents(K));
        this.M = M;
        this.S = S;
        this.K = K;
        this.lambda = lambda;
        this.mu = mu;
        this.Prob = Prob;
        this.MaxVIPQ = MaxVIPQ;
        this.MaxOTHERQ = MaxOTHERQ;
    }

    @Override
    public boolean active(BankState i, BankEvent e) {
        boolean result = false;
        switch (e.type) {
            case 1: {
                if (i.getVIPQSize() >= this.MaxVIPQ) break;
                result = true;
                break;
            }
            case 2: {
                if (i.getOTHERQSize() >= this.MaxOTHERQ) break;
                result = true;
                break;
            }
            case 3: {
                if (i.getVIPSingleTrans(e.transaction) <= 0) break;
                result = true;
                break;
            }
            case 4: {
                if (i.getOTHERSingleTrans(e.transaction) <= 0) break;
                result = true;
            }
        }
        return result;
    }

    @Override
    public States<BankState> dests(BankState i, BankEvent e) {
        StatesSet<BankState> set = new StatesSet<BankState>();
        int[] props = new int[this.K + this.K + 2];
        int k = 0;
        while (k < 2 * this.K) {
            props[k] = i.getProp(k);
            ++k;
        }
        int VIPQ = i.getVIPQSize();
        int OTHERQ = i.getOTHERQSize();
        switch (e.type) {
            case 1: {
                if (i.getVIPTrans() >= this.M) {
                    set.add(new BankState(props, ++VIPQ, OTHERQ, this.K, this.M, this.S));
                    break;
                }
                int n = e.transaction;
                props[n] = props[n] + 1;
                set.add(new BankState(props, VIPQ, OTHERQ, this.K, this.M, this.S));
                break;
            }
            case 2: {
                if (i.getOTHERTrans() >= this.S) {
                    set.add(new BankState(props, VIPQ, ++OTHERQ, this.K, this.M, this.S));
                    break;
                }
                int n = this.K + e.transaction;
                props[n] = props[n] + 1;
                set.add(new BankState(props, VIPQ, OTHERQ, this.K, this.M, this.S));
                break;
            }
            case 3: {
                int k2;
                if (i.getVIPQSize() == 0 && i.getOTHERQSize() == 0) {
                    int n = e.transaction;
                    props[n] = props[n] - 1;
                    set.add(new BankState(props, VIPQ, OTHERQ, this.K, this.M, this.S));
                }
                if (i.getVIPQSize() == 0 && i.getOTHERQSize() > 0) {
                    int n = e.transaction;
                    props[n] = props[n] - 1;
                    --OTHERQ;
                    k2 = 0;
                    while (k2 < this.K) {
                        int n2 = k2;
                        props[n2] = props[n2] + 1;
                        set.add(new BankState(props, VIPQ, OTHERQ, this.K, this.M, this.S));
                        int n3 = k2++;
                        props[n3] = props[n3] - 1;
                    }
                }
                if (i.getVIPQSize() <= 0) break;
                int n = e.transaction;
                props[n] = props[n] - 1;
                --VIPQ;
                k2 = 0;
                while (k2 < this.K) {
                    int n4 = k2;
                    props[n4] = props[n4] + 1;
                    set.add(new BankState(props, VIPQ, OTHERQ, this.K, this.M, this.S));
                    int n5 = k2++;
                    props[n5] = props[n5] - 1;
                }
                break;
            }
            case 4: {
                if (i.getOTHERQSize() == 0) {
                    int n = this.K + e.transaction;
                    props[n] = props[n] - 1;
                    set.add(new BankState(props, VIPQ, OTHERQ, this.K, this.M, this.S));
                }
                if (i.getOTHERQSize() <= 0) break;
                int n = this.K + e.transaction;
                props[n] = props[n] - 1;
                --OTHERQ;
                int k3 = 0;
                while (k3 < this.K) {
                    int n6 = this.K + k3;
                    props[n6] = props[n6] + 1;
                    set.add(new BankState(props, VIPQ, OTHERQ, this.K, this.M, this.S));
                    int n7 = this.K + k3;
                    props[n7] = props[n7] - 1;
                    ++k3;
                }
                break;
            }
        }
        return set;
    }

    @Override
    public double rate(BankState i, BankState j, BankEvent e) {
        double result = 0.0;
        switch (e.type) {
            case 1: {
                result = this.lambda[0] * this.Prob[e.transaction];
                break;
            }
            case 2: {
                result = this.lambda[1] * this.Prob[e.transaction];
                break;
            }
            case 3: {
                result = this.mu[e.transaction];
                break;
            }
            case 4: {
                result = this.mu[e.transaction];
            }
        }
        return result;
    }

    @Override
    public String description() {
        String stg = "Bank with VIP Servers SYSTEM\n\n";
        stg = String.valueOf(stg) + "Multiple server queue with " + this.M + " servers for VIP clients\n";
        stg = String.valueOf(stg) + "and " + this.S + " servers for normal clients\n\n";
        try {
            stg = String.valueOf(stg) + "VIP clients mean waiting time: " + this.getMOPsAvg("VIPQueue Length") / this.lambda[0] * 60.0 + " minutes\n\n\n";
        }
        catch (NotUnichainException e) {
            e.printStackTrace();
        }
        if (this.S == 0) {
            stg = String.valueOf(stg) + "Time desired cannot be achieved with that number of servers!!!!\n";
            stg = String.valueOf(stg) + "Try adding more servers";
        }
        return stg;
    }
}

