/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.PropertiesState;

class BBPhaseState
extends PropertiesState {
    private static int M;
    private static int N;

    public BBPhaseState(int N) {
        super(2 * N);
        BBPhaseState.N = N;
        this.prop[N - 1] = 1;
        int j = N;
        while (j < 2 * N) {
            this.prop[j] = 1;
            ++j;
        }
    }

    BBPhaseState(int[] phases, int[] machines) {
        super(2 * phases.length);
        System.arraycopy(phases, 0, this.prop, 0, N);
        System.arraycopy(machines, 0, this.prop, N, N);
    }

    public int askWorkerMachine(int wk, int k) {
        int result = 0;
        if (this.prop[N + wk] == k && this.prop[wk] > 0) {
            result = 1;
        }
        return result;
    }

    @Override
    public void computeMOPs(MarkovProcess mp) {
        int i = 0;
        while (i < N) {
            int j = 0;
            while (j < M) {
                this.setMOP(mp, "Machine " + (j + 1) + " usage by worker " + (i + 1), this.askWorkerMachine(i, j + 1));
                ++j;
            }
            ++i;
        }
        int sumOp = 0;
        int i2 = 0;
        while (i2 < N) {
            sumOp += this.getWkrStatus(i2);
            this.setMOP(mp, "Status Worker " + (i2 + 1), this.getWkrStatus(i2));
            ++i2;
        }
        this.setMOP(mp, "Number  of active workers in the production line", sumOp);
        i2 = 0;
        while (i2 < M) {
            this.setMOP(mp, "Status Machine " + (i2 + 1), this.getMachStatus(i2 + 1));
            ++i2;
        }
        i2 = 0;
        while (i2 < N) {
            this.setMOP(mp, "Blocked worker " + (i2 + 1), this.getWksBlocked(i2));
            ++i2;
        }
    }

    public int getWksBlocked(int wk) {
        if (this.prop[wk] == 0) {
            return 1;
        }
        return 0;
    }

    public int getWrkMach(int wk) {
        return this.prop[N + wk];
    }

    public int[] getWrkMach() {
        int[] opeMach = new int[N];
        System.arraycopy(this.prop, N, opeMach, 0, N);
        return opeMach;
    }

    public int getWkrPhase(int wk) {
        return this.prop[wk];
    }

    public int[] getWkrPhase() {
        int[] opePhase = new int[N];
        System.arraycopy(this.prop, 0, opePhase, 0, N);
        return opePhase;
    }

    @Override
    public BBPhaseState clone() {
        return new BBPhaseState(this.getWkrPhase(), this.getWrkMach());
    }

    public int getWkrStatus(int wk) {
        return this.getWkrPhase(wk) > 0 ? 1 : 0;
    }

    public int getMachStatus(int k) {
        int result = 0;
        int i = N;
        while (i < 2 * N && result == 0) {
            if (this.prop[i] == k) {
                result = 1;
            }
            ++i;
        }
        return result;
    }

    public BBPhaseState newPhase(int curOpe, int curMac, int newPhase) {
        int[] machOpe = this.getWrkMach();
        int[] phaseOpe = this.getWkrPhase();
        machOpe[curOpe] = curMac;
        phaseOpe[curOpe] = newPhase;
        return new BBPhaseState(phaseOpe, machOpe);
    }

    public BBPhaseState newMach(int curWkr, int newMach, int newPhase) {
        int[] machWkr = this.getWrkMach();
        int[] phaseWkr = this.getWkrPhase();
        machWkr[curWkr] = newMach;
        phaseWkr[curWkr] = newPhase;
        return new BBPhaseState(phaseWkr, machWkr);
    }

    public BBPhaseState reset(int[] newPhases, int[] newMacs) {
        int[] machines = newMacs;
        int[] phase = newPhases;
        return new BBPhaseState(phase, machines);
    }

    public BBPhaseState newMach(int curOpe, int fase1, int fase2, int Mac1, int Mac2) {
        int[] machOpe = this.getWrkMach();
        int[] phaseOpe = this.getWkrPhase();
        machOpe[curOpe] = Mac1;
        machOpe[curOpe - 1] = Mac2;
        phaseOpe[curOpe] = fase1;
        phaseOpe[curOpe - 1] = fase2;
        return new BBPhaseState(phaseOpe, machOpe);
    }

    @Override
    public String label() {
        String stg = "";
        int i = 0;
        while (i < N) {
            stg = String.valueOf(stg) + this.prop[i];
            ++i;
        }
        stg = String.valueOf(stg) + "/";
        i = N;
        while (i < 2 * N) {
            stg = String.valueOf(stg) + this.prop[i];
            ++i;
        }
        return stg;
    }

    @Override
    public String description() {
        String stg = "PhOpe: {";
        int k = 0;
        while (k < N - 1) {
            stg = String.valueOf(stg) + this.getWkrPhase(k) + ",";
            ++k;
        }
        stg = String.valueOf(stg) + this.getWkrPhase(N - 1);
        stg = String.valueOf(stg) + "} MachOpe: {";
        int j = 0;
        while (j < N - 1) {
            stg = String.valueOf(stg) + this.getWrkMach(j) + ",";
            ++j;
        }
        stg = String.valueOf(stg) + this.getWrkMach(N - 1);
        stg = String.valueOf(stg) + "} Blocked. Wk: {";
        j = 0;
        while (j < N) {
            stg = String.valueOf(stg) + (this.getWkrPhase(j) == 0 ? String.valueOf(j + 1) : "");
            ++j;
        }
        stg = String.valueOf(stg) + "} ";
        return stg;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }
}

