/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.BBPhBuf;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import jmarkov.basic.exceptions.NotUnichainException;
import jphase.ContPhaseVar;
import jphase.DenseContPhaseVar;

public class BBPhBufExp
extends BBPhBuf {
    public static void modelPrinting(int workers, int[] bufferCaps, int stations, double[][] velocities, ContPhaseVar[] vars, String description, boolean printHeads, BufferedWriter output, int debugLevel) throws NotUnichainException, IOException {
        double[] mposAvg1;
        int n;
        BBPhBuf model1 = new BBPhBuf(workers, stations, vars, velocities, bufferCaps);
        model1.setDebugLevel(debugLevel);
        model1.setMaxStates(20000L);
        model1.generate();
        if (printHeads) {
            String[] MopsNames;
            output.write(String.valueOf(description) + "\n");
            String[] stringArray = MopsNames = model1.getMOPNames();
            n = MopsNames.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                output.write(String.valueOf(s) + "\t");
                ++n2;
            }
            output.write("Throughput Rate\n");
        }
        double[] dArray = mposAvg1 = model1.getMOPsAvg();
        int n3 = mposAvg1.length;
        n = 0;
        while (n < n3) {
            double d = dArray[n];
            output.write(String.valueOf(d) + "\t");
            ++n;
        }
        output.write(String.valueOf(model1.getResetRate()) + "\n");
    }

    public static void bufferVariation(int workers, int stations, double[][] velocities, ContPhaseVar[] vars, boolean[] buffer, int maxBuff, FileWriter file, String description, int debugLevel) throws IOException, NotUnichainException {
        BufferedWriter output = new BufferedWriter(file);
        int[] bufferCaps = new int[stations - 1];
        boolean printHeads = true;
        int b = 0;
        while (b < maxBuff + 1) {
            int n = 0;
            boolean[] blArray = buffer;
            int n2 = buffer.length;
            int n3 = 0;
            while (n3 < n2) {
                boolean i = blArray[n3];
                if (i) {
                    bufferCaps[n] = b;
                }
                ++n;
                ++n3;
            }
            BBPhBufExp.modelPrinting(workers, bufferCaps, stations, velocities, vars, description, printHeads, output, debugLevel);
            if (printHeads) {
                printHeads = false;
            }
            ++b;
        }
        output.close();
    }

    public static void bufferVariation() {
        int l;
        ContPhaseVar[] varsArray = new ContPhaseVar[6];
        String[] descriptions = new String[varsArray.length];
        varsArray[5] = DenseContPhaseVar.Erlang(7.0, 7);
        descriptions[5] = "Erlang distributions, 7 phases, mean 1";
        varsArray[0] = DenseContPhaseVar.Erlang(2.0, 2);
        descriptions[0] = "Erlang distributions, 2 phases, mean 1";
        varsArray[1] = DenseContPhaseVar.expo(1.0);
        descriptions[1] = "Exponential distribution, mean 1";
        double[] c2Array = new double[]{1.5, 2.0, 2.5};
        double[] lambda = new double[2];
        int i = 0;
        while (i < c2Array.length) {
            lambda[0] = 1.0 / (1.0 + Math.sqrt((c2Array[i] - 1.0) / 2.0));
            lambda[1] = 1.0 / (1.0 - Math.sqrt((c2Array[i] - 1.0) / 2.0));
            varsArray[i + 2] = DenseContPhaseVar.HyperExpo(lambda, new double[]{0.5, 0.5});
            descriptions[i + 2] = "HyperExponential distribution, mean 1, 2 phases, c2 " + c2Array[i];
            ++i;
        }
        int stations = 5;
        ContPhaseVar[] vars = new ContPhaseVar[stations];
        int workers = 4;
        boolean[] buffer = new boolean[stations - 1];
        int i2 = 0;
        while (i2 < buffer.length) {
            buffer[i2] = false;
            ++i2;
        }
        int maxBuff = 0;
        double[][] velocities = new double[workers][stations];
        int i3 = 0;
        while (i3 < workers) {
            l = 0;
            while (l < stations) {
                velocities[i3][l] = 1.0;
                ++l;
            }
            ++i3;
        }
        int modelCounter = 1;
        l = 0;
        while (l < buffer.length + 1) {
            int i4;
            if (l == 0) {
                buffer[0] = true;
            } else if (l > 0 && l < buffer.length) {
                buffer[l - 1] = false;
                buffer[l] = true;
            } else {
                i4 = 0;
                while (i4 < buffer.length) {
                    buffer[i4] = true;
                    ++i4;
                }
            }
            i4 = 0;
            while (i4 < varsArray.length) {
                int j = 0;
                while (j < vars.length) {
                    vars[j] = varsArray[i4].copy();
                    ++j;
                }
                try {
                    String description;
                    System.out.println("./BucketFiles/model" + modelCounter + ".txt");
                    FileWriter file = new FileWriter("./BucketFiles/model" + modelCounter + ".txt");
                    if (l < buffer.length) {
                        int pos = l + 2;
                        description = String.valueOf(descriptions[i4]) + "buffer position " + pos;
                    } else {
                        description = String.valueOf(descriptions[i4]) + "all stations with buffer";
                    }
                    if (i4 == varsArray.length - 1) {
                        int maxBuffE = 4;
                        BBPhBufExp.bufferVariation(workers, stations, velocities, vars, buffer, maxBuffE, file, description, 3);
                    } else {
                        BBPhBufExp.bufferVariation(workers, stations, velocities, vars, buffer, maxBuff, file, description, 3);
                    }
                }
                catch (Exception e) {
                    System.out.println("The destination file was not found.");
                }
                ++modelCounter;
                ++i4;
            }
            ++l;
        }
    }

    public static void BottelNeckBefore() {
        ContPhaseVar[] varsArray = new ContPhaseVar[6];
        ContPhaseVar[] neckVars = new ContPhaseVar[6];
        String[] descriptions = new String[varsArray.length];
        varsArray[5] = DenseContPhaseVar.Erlang(7.0, 7);
        neckVars[5] = DenseContPhaseVar.Erlang(3.5, 7);
        descriptions[5] = "Erlang distributions, 7 phases, mean 1";
        varsArray[0] = DenseContPhaseVar.Erlang(2.0, 2);
        neckVars[0] = DenseContPhaseVar.Erlang(1.0, 2);
        descriptions[0] = "Erlang distributions, 2 phases, mean 1";
        varsArray[1] = DenseContPhaseVar.expo(1.0);
        neckVars[1] = DenseContPhaseVar.expo(0.5);
        descriptions[1] = "Exponential distribution, mean 1";
        double[] c2Array = new double[]{1.5, 2.0, 2.5};
        double[] lambda = new double[2];
        double[] lambdaNeck = new double[2];
        int i = 0;
        while (i < c2Array.length) {
            lambda[0] = 1.0 / (1.0 + Math.sqrt((c2Array[i] - 1.0) / 2.0));
            lambda[1] = 1.0 / (1.0 - Math.sqrt((c2Array[i] - 1.0) / 2.0));
            lambdaNeck[0] = 1.0 / (2.0 * (1.0 + Math.sqrt((c2Array[i] - 1.0) / 2.0)));
            lambdaNeck[1] = 1.0 / (2.0 * (1.0 - Math.sqrt((c2Array[i] - 1.0) / 2.0)));
            varsArray[i + 2] = DenseContPhaseVar.HyperExpo(lambda, new double[]{0.5, 0.5});
            neckVars[i + 2] = DenseContPhaseVar.HyperExpo(lambdaNeck, new double[]{0.5, 0.5});
            descriptions[i + 2] = "HyperExponential distribution, mean 1, 2 phases, c2 " + c2Array[i];
            ++i;
        }
        int stations = 5;
        int bottelNeck = stations - 3;
        ContPhaseVar[] vars = new ContPhaseVar[stations];
        int workers = 4;
        boolean[] buffer = new boolean[stations - 1];
        int i2 = 0;
        while (i2 < buffer.length) {
            buffer[i2] = false;
            ++i2;
        }
        buffer[bottelNeck] = true;
        int maxBuff = 10;
        double[][] velocities = new double[workers][stations];
        int i3 = 0;
        while (i3 < workers) {
            int l = 0;
            while (l < stations) {
                velocities[i3][l] = 1.0;
                ++l;
            }
            ++i3;
        }
        int modelCounter = 1;
        int i4 = 0;
        while (i4 < varsArray.length) {
            int j = 0;
            while (j < vars.length) {
                vars[j] = j == bottelNeck ? neckVars[i4].copy() : varsArray[i4].copy();
                ++j;
            }
            try {
                FileWriter file = new FileWriter("./BucketFiles/bottelNeckmodelBefore" + modelCounter + ".txt");
                String description = String.valueOf(descriptions[i4]) + "buffer position 3";
                BBPhBufExp.bufferVariation(workers, stations, velocities, vars, buffer, maxBuff, file, description, 3);
            }
            catch (Exception e) {
                System.out.println("The destination file was not found.");
            }
            ++modelCounter;
            ++i4;
        }
    }

    public static void BottelNeckAfter() {
        ContPhaseVar[] varsArray = new ContPhaseVar[6];
        ContPhaseVar[] neckVars = new ContPhaseVar[6];
        String[] descriptions = new String[varsArray.length];
        varsArray[5] = DenseContPhaseVar.Erlang(7.0, 7);
        neckVars[5] = DenseContPhaseVar.Erlang(3.5, 7);
        descriptions[5] = "Erlang distributions, 7 phases, mean 1";
        varsArray[0] = DenseContPhaseVar.Erlang(2.0, 2);
        neckVars[0] = DenseContPhaseVar.Erlang(1.0, 2);
        descriptions[0] = "Erlang distributions, 2 phases, mean 1";
        varsArray[1] = DenseContPhaseVar.expo(1.0);
        neckVars[1] = DenseContPhaseVar.expo(0.5);
        descriptions[1] = "Exponential distribution, mean 1";
        double[] c2Array = new double[]{1.5, 2.0, 2.5};
        double[] lambda = new double[2];
        double[] lambdaNeck = new double[2];
        int i = 0;
        while (i < c2Array.length) {
            lambda[0] = 1.0 / (1.0 + Math.sqrt((c2Array[i] - 1.0) / 2.0));
            lambda[1] = 1.0 / (1.0 - Math.sqrt((c2Array[i] - 1.0) / 2.0));
            lambdaNeck[0] = 1.0 / (2.0 * (1.0 + Math.sqrt((c2Array[i] - 1.0) / 2.0)));
            lambdaNeck[1] = 1.0 / (2.0 * (1.0 - Math.sqrt((c2Array[i] - 1.0) / 2.0)));
            varsArray[i + 2] = DenseContPhaseVar.HyperExpo(lambda, new double[]{0.5, 0.5});
            neckVars[i + 2] = DenseContPhaseVar.HyperExpo(lambdaNeck, new double[]{0.5, 0.5});
            descriptions[i + 2] = "HyperExponential distribution, mean 1, 2 phases, c2 " + c2Array[i];
            ++i;
        }
        int stations = 5;
        int bottelNeck = stations - 3;
        ContPhaseVar[] vars = new ContPhaseVar[stations];
        int workers = 4;
        boolean[] buffer = new boolean[stations - 1];
        int i2 = 0;
        while (i2 < buffer.length) {
            buffer[i2] = false;
            ++i2;
        }
        buffer[bottelNeck + 1] = true;
        buffer[bottelNeck] = true;
        int maxBuff = 10;
        double[][] velocities = new double[workers][stations];
        int i3 = 0;
        while (i3 < workers) {
            int l = 0;
            while (l < stations) {
                velocities[i3][l] = 1.0;
                ++l;
            }
            ++i3;
        }
        int modelCounter = 1;
        int i4 = 0;
        while (i4 < varsArray.length) {
            int j = 0;
            while (j < vars.length) {
                vars[j] = j == bottelNeck ? neckVars[i4].copy() : varsArray[i4].copy();
                ++j;
            }
            try {
                FileWriter file = new FileWriter("./BucketFiles/bottelNeckmodelAfter" + modelCounter + ".txt");
                String description = String.valueOf(descriptions[i4]) + "buffer position 4";
                BBPhBufExp.bufferVariation(workers, stations, velocities, vars, buffer, maxBuff, file, description, 3);
            }
            catch (Exception e) {
                System.out.println("The destination file was not found.");
            }
            ++modelCounter;
            ++i4;
        }
    }

    public static void main(String[] s) {
        BBPhBufExp.bufferVariation();
    }
}

