/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.BBPhBufEv;
import examples.jmarkov.BBPhBufSt;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import jmarkov.MarkovProcess;
import jmarkov.basic.StatesSet;
import jmarkov.basic.Transition;
import jmarkov.basic.Transitions;
import jmarkov.basic.TransitionsSet;
import jmarkov.basic.exceptions.NotUnichainException;
import jphase.ContPhaseVar;
import jphase.DenseContPhaseVar;
import no.uib.cipr.matrix.Matrix;

public class BBPhBuf
extends MarkovProcess<BBPhBufSt, BBPhBufEv> {
    private int N;
    private int M;
    private ContPhaseVar[] machineTimes;
    private double[][] vels;
    private int[] capBuffer;
    private int[][][] reachablePhases;
    private int[][] startPhases;
    private boolean[][] canFinish;
    private boolean[][] canChange;

    public BBPhBuf(int numWorkers, int numMachines, ContPhaseVar[] processTimes, double[][] vels, int[] capBuffer) {
        super(new BBPhBufSt(numWorkers, numMachines), BBPhBufEv.getAllEvents(numWorkers));
        this.N = numWorkers;
        this.M = numMachines;
        this.capBuffer = capBuffer;
        this.machineTimes = processTimes;
        this.vels = vels;
        assert (this.M == processTimes.length);
        assert (this.N == vels.length);
        assert (this.M - 1 == capBuffer.length);
        this.buildReachablePhases();
        BBPhBufSt.setModel(this);
    }

    public BBPhBuf() {
        this(2, 2, new ContPhaseVar[]{DenseContPhaseVar.Erlang(1.0, 2), DenseContPhaseVar.Erlang(1.0, 2)}, new double[][]{{1.0, 1.0}, {2.0, 3.0}}, new int[1]);
        this.setDebugLevel(0);
        this.setMaxStates(4000L);
    }

    private void buildReachablePhases() {
        this.reachablePhases = new int[this.M][][];
        this.startPhases = new int[this.M][];
        this.canFinish = new boolean[this.M][];
        this.canChange = new boolean[this.M][];
        int j = 0;
        while (j < this.M) {
            ContPhaseVar var = this.machineTimes[j];
            int m = var.getNumPhases();
            double[] alpha = var.getVectorArray();
            double[] a = var.getMat0Array();
            double[][] A = var.getMatrixArray();
            this.reachablePhases[j] = new int[m + 1][];
            this.canFinish[j] = new boolean[m + 1];
            this.canChange[j] = new boolean[m + 1];
            ArrayList<Integer> listStart = new ArrayList<Integer>();
            int k = 1;
            while (k <= m) {
                if (alpha[k - 1] > 0.0) {
                    listStart.add(k);
                }
                this.canFinish[j][k] = a[k - 1] > 0.0;
                ArrayList<Integer> listReachable = new ArrayList<Integer>();
                int k2 = 1;
                while (k2 <= m) {
                    if (A[k - 1][k2 - 1] > 0.0) {
                        boolean[] blArray = this.canChange[j];
                        int n = k;
                        blArray[n] = blArray[n] | true;
                        listReachable.add(k2);
                    }
                    ++k2;
                }
                int n = listReachable.size();
                this.reachablePhases[j][k] = new int[n];
                int k22 = 0;
                while (k22 < n) {
                    this.reachablePhases[j][k][k22] = (Integer)listReachable.get(k22);
                    ++k22;
                }
                ++k;
            }
            int numStart = listStart.size();
            this.startPhases[j] = new int[numStart];
            int k2 = 0;
            while (k2 < numStart) {
                this.startPhases[j][k2] = (Integer)listStart.get(k2);
                ++k2;
            }
            ++j;
        }
    }

    public int[] getStartingPhases(int j) {
        assert (j >= 0 && j < this.M);
        if (this.startPhases == null || this.startPhases[j] == null) {
            this.buildReachablePhases();
        }
        return this.startPhases[j];
    }

    public int[] getReachablePhases(int j, int k) {
        assert (j >= 0 && j < this.M);
        assert (1 <= k && k <= this.machineTimes[j].getNumPhases());
        if (this.reachablePhases == null || this.reachablePhases[j] == null || this.reachablePhases[j][k] == null) {
            this.buildReachablePhases();
        }
        return this.reachablePhases[j][k];
    }

    public double getStartingProb(int j, int k) {
        assert (j >= 0 && j < this.M);
        assert (1 <= k && k <= this.machineTimes[j].getNumPhases());
        return this.machineTimes[j].getVector().get(k - 1);
    }

    public double getTransitionRate(int j, int k1, int k2) {
        assert (j >= 0 && j < this.M);
        assert (1 <= k1 && k1 <= this.machineTimes[j].getNumPhases());
        assert (1 <= k2 && k2 <= this.machineTimes[j].getNumPhases());
        return this.machineTimes[j].getMatrix().get(k1 - 1, k2 - 1);
    }

    public double getAbsorptionRate(int j, int f) {
        assert (j >= 0 && j < this.M);
        assert (f <= this.machineTimes[j].getNumPhases());
        return this.machineTimes[j].getMat0().get(f - 1);
    }

    public boolean active(BBPhBufSt x, BBPhBufEv e) {
        boolean result = false;
        int i = e.getWorker();
        int k = x.getPhase(i);
        int j = x.getMachine(i);
        boolean isLastMach = j == this.M - 1;
        boolean nextIsBusy = !isLastMach && i < this.N - 1 && x.getMachine(i + 1) == j + 1;
        boolean isFirstWorker = i == 0;
        boolean prevIsBlocked = !isFirstWorker && x.getPhase(i - 1) == 0;
        boolean thereIsRoom = j < this.M - 1 && x.getBuffer(j) < this.capBuffer[j];
        switch (e.getType()) {
            case CHANGE_PHASE: {
                result = this.canChange[j][k];
                break;
            }
            case MOVE: {
                result = !isLastMach && !prevIsBlocked && this.canFinish[j][k] && !nextIsBusy;
                break;
            }
            case MOVE_START: {
                result = !isLastMach && prevIsBlocked && this.canFinish[j][k] && !nextIsBusy;
                break;
            }
            case BLOCKING: {
                result = !prevIsBlocked && this.canFinish[j][k] && nextIsBusy && !thereIsRoom;
                break;
            }
            case BLOCKING_START: {
                result = prevIsBlocked && this.canFinish[j][k] && nextIsBusy && !thereIsRoom;
                break;
            }
            case RESET: {
                result = this.canFinish[j][k];
                if (isLastMach) break;
                result &= nextIsBusy && thereIsRoom;
            }
        }
        return result;
    }

    @Override
    public Transitions<BBPhBufSt> activeTransitions(BBPhBufSt x, BBPhBufEv e) {
        TransitionsSet<BBPhBufSt> trans = new TransitionsSet<BBPhBufSt>();
        if (!this.active(x, e)) {
            return trans;
        }
        int i = e.getWorker();
        int j = x.getMachine(i);
        int k = x.getPhase(i);
        double rate = -1.0;
        switch (e.getType()) {
            case CHANGE_PHASE: {
                int[] nArray = this.getReachablePhases(j, k);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int k2 = nArray[n2];
                    rate = this.vels[i][j] * this.getTransitionRate(j, k, k2);
                    trans.add(x.phaseChange(i, k2), rate);
                    ++n2;
                }
                break;
            }
            case MOVE: {
                int[] nArray = this.getStartingPhases(j + 1);
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int k1 = nArray[n3];
                    rate = this.vels[i][j] * this.getAbsorptionRate(j, k) * this.getStartingProb(j + 1, k1);
                    trans.add(x.moveToNext(i, k1), rate);
                    ++n3;
                }
                break;
            }
            case MOVE_START: {
                int[] nArray = this.startPhases[j + 1];
                int n = nArray.length;
                int n4 = 0;
                while (n4 < n) {
                    int k1 = nArray[n4];
                    int[] nArray2 = this.startPhases[j];
                    int n5 = nArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        int k2 = nArray2[n6];
                        rate = this.vels[i][j] * this.getAbsorptionRate(j, k) * this.getStartingProb(j + 1, k1) * this.getStartingProb(j, k2);
                        trans.add(x.moveToNext(i, k1).phaseChange(i - 1, k2), rate);
                        ++n6;
                    }
                    ++n4;
                }
                break;
            }
            case BLOCKING: {
                rate = this.vels[i][j] * this.getAbsorptionRate(j, k);
                trans.add(x.block(i), rate);
                break;
            }
            case BLOCKING_START: {
                int[] nArray = this.startPhases[j];
                int n = nArray.length;
                int n7 = 0;
                while (n7 < n) {
                    int k2 = nArray[n7];
                    rate = this.vels[i][j] * this.getAbsorptionRate(j, k) * this.getStartingProb(j, k2);
                    trans.add(x.block(i).phaseChange(i - 1, k2), rate);
                    ++n7;
                }
                break;
            }
            case RESET: {
                BBPhBufSt y = x.phaseChange(i, 0);
                int s = y.getResetMachine(j);
                int w = y.getResetWorker(s);
                BBPhBufSt z = x.reset(i, w, s);
                rate = this.vels[i][j] * this.getAbsorptionRate(j, k);
                Transition<BBPhBufSt> tr = new Transition<BBPhBufSt>(z, rate);
                trans.add(this.revive(tr, i, w));
            }
        }
        return trans;
    }

    public double rate(BBPhBufSt x, BBPhBufSt y, BBPhBufEv e) {
        int i = e.getWorker();
        int k = x.getPhase(i);
        int k2 = y.getPhase(i);
        int j = x.getMachine(i);
        double[] a = null;
        double[] alpha = null;
        double rate = -1.0;
        switch (e.getType()) {
            case CHANGE_PHASE: {
                Matrix A = this.machineTimes[j].getMatrix();
                rate = this.vels[i][j] * A.get(k - 1, k2 - 1);
                break;
            }
            case MOVE: {
                a = this.machineTimes[j].getMat0Array();
                alpha = this.machineTimes[j + 1].getVectorArray();
                rate = this.vels[i][j] * a[k - 1] * alpha[k2 - 1];
                break;
            }
            case MOVE_START: {
                a = this.machineTimes[j].getMat0Array();
                alpha = this.machineTimes[j + 1].getVectorArray();
                double[] alpha1 = this.machineTimes[j].getVectorArray();
                int k1 = y.getPhase(i - 1);
                rate = this.vels[i][j] * a[k - 1] * alpha1[k1 - 1] * alpha[k2 - 1];
                break;
            }
            case BLOCKING: {
                a = this.machineTimes[j].getMat0Array();
                rate = this.vels[i][j] * a[k - 1];
                break;
            }
            case BLOCKING_START: {
                a = this.machineTimes[j].getMat0Array();
                double[] alpha1 = this.machineTimes[j].getVectorArray();
                int k1 = y.getPhase(i - 1);
                rate = this.vels[i][j] * a[k - 1] * alpha1[k1 - 1];
                break;
            }
            case RESET: {
                int s = x.getResetMachine(j);
                int w = x.getResetWorker(s);
                a = this.machineTimes[j].getMat0Array();
                alpha = this.machineTimes[w].getVectorArray();
                rate = this.vels[i][j] * a[k - 1];
                if (w == 0 && x.getMachine(0) == 0 && x.isBusy(0)) {
                    rate = this.vels[i][j] * a[k - 1];
                    break;
                }
                k2 = y.getPhase(w);
                rate = this.vels[i][j] * a[k - 1] * alpha[k2 - 1];
            }
        }
        return rate;
    }

    private Transitions<BBPhBufSt> revive(Transitions<BBPhBufSt> trs, int i) {
        TransitionsSet<BBPhBufSt> theSet = new TransitionsSet<BBPhBufSt>();
        for (Transition transition : trs) {
            theSet.add(this.revive(transition, i));
        }
        return theSet;
    }

    private Transitions<BBPhBufSt> revive(Transition<BBPhBufSt> tr, int i, int w) {
        return this.revive(this.revive(tr, i), w);
    }

    public Transitions<BBPhBufSt> revive(Transition<BBPhBufSt> tr, int i) {
        boolean isFirstAtMachine;
        assert (i >= 0 && i < this.N);
        BBPhBufSt x = tr.getState();
        double baseRate = tr.getRate();
        TransitionsSet<BBPhBufSt> transSet = new TransitionsSet<BBPhBufSt>();
        int j = x.getMachine(i);
        boolean bl = isFirstAtMachine = i < this.N - 1 && x.getMachine(i + 1) > j || i == this.N - 1;
        if (isFirstAtMachine && !x.isBusy(i)) {
            int[] nArray = this.getStartingPhases(j);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int f = nArray[n2];
                transSet.add(x.phaseChange(i, f), baseRate * this.getStartingProb(j, f));
                ++n2;
            }
        } else {
            transSet.add(x, baseRate);
        }
        return transSet;
    }

    public double getResetRate() throws NotUnichainException {
        StatesSet theStates = this.getStates();
        BBPhBufEv[] theEvents = (BBPhBufEv[])this.getEvents();
        double resetRate = 0.0;
        double[] pi = this.getSteadyState();
        BBPhBufEv[] bBPhBufEvArray = theEvents;
        int n = theEvents.length;
        int n2 = 0;
        while (n2 < n) {
            BBPhBufEv e = bBPhBufEvArray[n2];
            if (e.getWorker() == this.N - 1 && e.getType() == BBPhBufEv.Type.RESET) {
                int s = 0;
                for (BBPhBufSt i : theStates) {
                    Transitions<BBPhBufSt> trans;
                    if (i.getMachine(e.getWorker()) == this.M - 1 && this.active(i, e) && (trans = this.activeTransitions(i, e)) != null) {
                        for (Transition transition : trans) {
                            resetRate += pi[s] * transition.getRate();
                        }
                    }
                    ++s;
                }
            }
            ++n2;
        }
        return resetRate;
    }

    @Override
    public String description() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("Bucket Brigades Production System with " + this.M + " Machines and " + this.N + " Workers.\n");
        pw.print("\nBuffers Capacity (");
        int j = 0;
        while (j < this.M - 1) {
            pw.print(String.valueOf(this.capBuffer[j]) + (j < this.M - 2 ? "," : ""));
            ++j;
        }
        pw.print(")\n");
        pw.print("\nDistributions: Process Time on machine m.\n");
        j = 0;
        while (j < this.M) {
            pw.println("Machine " + (j + 1) + ": ");
            pw.println(this.machineTimes[j].description());
            ++j;
        }
        pw.print("\nRelitive Velocities:\n");
        Jama.Matrix mat = new Jama.Matrix(this.vels);
        mat.print(pw, 8, 2);
        return sw.toString();
    }

    @Override
    public int printMOPs(PrintWriter out, int width, int decimals) {
        int namesWidth = super.printMOPs(out, width, decimals);
        try {
            out.printf(String.valueOf(this.pad("Throughput Rate", namesWidth, false)) + this.pad(this.getResetRate(), width, decimals), new Object[0]);
        }
        catch (NotUnichainException e) {
            out.println(e);
        }
        return namesWidth;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        BBPhBufSt.setModel(null);
    }

    public static void main(String[] a) {
        int N = 3;
        int M = 2;
        int[] bufferCaps = new int[]{1};
        DenseContPhaseVar v = DenseContPhaseVar.expo(1.0);
        DenseContPhaseVar v2 = DenseContPhaseVar.expo(1.0);
        ContPhaseVar[] machineTimes = new ContPhaseVar[]{v, v, v2};
        double[][] velocities = new double[][]{{1.0, 1.0}, {1.0, 1.0}, {1.0, 1.0}};
        BBPhBuf model = new BBPhBuf(N, M, machineTimes, velocities, bufferCaps);
        model.setDebugLevel(4);
        model.generate();
        model.setDebugLevel(4);
    }
}

