/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.basic.Event;
import jmarkov.basic.EventsSet;

class AccessControl2QueuesEvent
extends Event {
    private Type type;
    public int first;
    public int second;

    public AccessControl2QueuesEvent(Type type) {
        this.type = type;
        switch (type) {
            case ADMIT: {
                this.first = 1;
                this.second = 0;
                break;
            }
            case COMP_1: {
                this.first = -1;
                this.second = 1;
                break;
            }
            case COMP_2: {
                this.first = 0;
                this.second = -1;
                break;
            }
            case LOSS: {
                this.first = -1;
                this.second = 0;
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    public int getFirst() {
        return this.first;
    }

    public int getSecond() {
        return this.second;
    }

    public static EventsSet<AccessControl2QueuesEvent> getAllEvents() {
        EventsSet<AccessControl2QueuesEvent> eSet = new EventsSet<AccessControl2QueuesEvent>();
        eSet.add(new AccessControl2QueuesEvent(Type.ADMIT));
        eSet.add(new AccessControl2QueuesEvent(Type.COMP_1));
        eSet.add(new AccessControl2QueuesEvent(Type.COMP_2));
        eSet.add(new AccessControl2QueuesEvent(Type.LOSS));
        return eSet;
    }

    @Override
    public String label() {
        String stg = "";
        switch (this.type) {
            case ADMIT: {
                stg = "A new job enters the system.";
                break;
            }
            case COMP_1: {
                stg = "A job is completed at station 1.";
                break;
            }
            case COMP_2: {
                stg = "A job is completed at station 2.";
                break;
            }
            case LOSS: {
                stg = "A job is lost between stations 1 and 2.";
            }
        }
        return stg;
    }

    public static enum Type {
        ADMIT,
        COMP_1,
        COMP_2,
        LOSS;

    }
}

