/*****************************************************************************
 * This code is part of Art Gallery Solver (AGSol) Package, which aims the 
 * resolution of the Art Gallery Problem With Point Guards.
 *
 * This software version (1.0.2) has been tested under and is compatible with 
 * CGAL 3.9 and GLPK 4.52.
 *
 * Authors:
 *  Davi Colli Tozoni - davi.tozoni@gmail.com
 *  Marcelo Castilho Couto - coutomarcelo@gmail.com
 *
 * AGSol Concept and Design: 
 *  Davi Colli Tozoni, Marcelo Castilho Couto, Pedro Jussieu de Rezende & Cid 
 * Carvalho de Souza.
 * 
 * Other information can be found at:
 *  http://www.ic.unicamp.br/~cid/Problem-instances/Art-Gallery/index.html
 *
 * --
 * 
 *  This program is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 *      
 ****************************************************************************/


#ifndef POLYGON_WITH_HOLES_EXT_H
#define POLYGON_WITH_HOLES_EXT_H

#include "PolygonExt.h"

class PolygonWithHolesExt : public PolygonWithHoles{
    public:
        PolygonWithHolesExt() : PolygonWithHoles() {}
        PolygonWithHolesExt(PolygonWithHoles pol) : PolygonWithHoles(pol) {}
        PolygonWithHolesExt(Polygon pol) : PolygonWithHoles(pol) {}
        
        /**
         * Computes visibility polygons for polygons with holes.  The idea is
         * to use the same algorithm for the class PolygonExt (without holes)
         * and then remove the shadows generated by each hole.
         */
        PolygonExt getVisibility(Point);
        
        /**
         * Computes the area of a polygon with holes by removing the area of
         * the boundary polygon and subtracting the area of the holes.
         */
        RT area();
        
        /**
         * Computes the total number of vertices of the polygon with holes.
         */
        int size();
};

#endif

