// Copyright (c) 2012 David Munger, Pierre L'Ecuyer, Université de Montréal.
// 
// This file is part of Lattice Builder.
// 
// Lattice Builder is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Lattice Builder is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Lattice Builder.  If not, see <http://www.gnu.org/licenses/>.

#ifndef LATBUILDER__FUNCTOR__ALL_OF_H
#define LATBUILDER__FUNCTOR__ALL_OF_H

namespace LatBuilder { namespace Functor {
   /**
    * Returns \c true if all of the elements evaluate to \c true or if there are
    * no elements.
    */
   class AllOf {
   public:
      typedef bool result_type;

      template <typename InputIterator>
      bool operator()(InputIterator first, InputIterator last) const
      {
         while (first != last) {
            if (!*first) return false;
            ++first;
         }
         return true;
      }
   };
}}

#endif
