module sample_m ! Sample of library package called by tmessy
use messy_m, only : rk, messy, messy_ty
type, public :: sample_ty
 type(messy_ty) :: e
 integer ::  what
end type sample_ty

integer, parameter :: setup_sample=0, partial_message=1, finish_message=2

contains
  subroutine sample(s)
    type(sample_ty) :: s
    select case (s%what)
    case(setup_sample) ! The setup call
      s%e%ename="sample"
      return
    case(partial_message) ! Partial print of error1
      call messy(s%e, "$E34Start of error message from sample what=$I.$C",&
        & [ 1, s%what ])
    case(finish_message) ! Finish this error message
      call messy(s%e, "Finish with what=$I.", [ s%what ])
    case default
      call messy(s%e, "$E56Fatal error called sample with what = $I.",&
      & [99, s%what ])
    end select
    return
  end subroutine sample
end module sample_m
