(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9667,        283]
NotebookOptionsPosition[      8530,        238]
NotebookOutlinePosition[      8893,        254]
CellTagsIndexPosition[      8850,        251]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["MathTIDES.  Version : 1.30", "Section",
 CellChangeTimes->{{3.470545224089817*^9, 3.470545228544339*^9}, {
   3.470545353980753*^9, 3.470545354130248*^9}, 3.473426292675918*^9, 
   3.533299876854787*^9}],

Cell["\<\
MathTIDES. Version 1.3.0.
This file is part of TIDES.
  \
\>", "Text",
 CellChangeTimes->{3.533299875240671*^9}],

Cell["\<\
Alberto Abad, Roberto Barrio, Fernando Blesa, Marcos Rodriguez
Grupo de Mec\[AAcute]nica Espacial.  IUMA.
University of Zaragoza
50009 Zaragoza. Spain.

 http://gme.unizar.es/software/tides
 Contact: <tides@unizar.es>
\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Installation", "Section",
 CellChangeTimes->{{3.4705452562377768`*^9, 3.4705452632256317`*^9}}],

Cell[TextData[StyleBox["To install ( or uninstall)  MathTIDES choose between \
one the following options, open the corresponding Cell and run the Cell.",
 FontSize->36]], "Text",
 CellChangeTimes->{{3.470126316193121*^9, 3.470126414814747*^9}}],

Cell[CellGroupData[{

Cell["Install MathTIDES for all users", "Subsection",
 CellChangeTimes->{{3.470125870231476*^9, 3.470125888025694*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"InstallMathTIDES", " ", "=", "\[IndentingNewLine]", "\t", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"nmt", ",", " ", "sep", ",", " ", "dir"}], "}"}], ",", 
    "\[IndentingNewLine]", "\t\t", 
    RowBox[{
     RowBox[{"nmt", " ", "=", " ", "\"\<MathTIDES\>\""}], ";", 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{"sep", " ", "=", " ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"StringFreeQ", "[", 
         RowBox[{"$SystemID", ",", " ", "\"\<Windows\>\""}], "]"}], ",", " ", 
        "\"\</\>\"", ",", " ", "\"\<\\\\\>\""}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{"dir", " ", "=", " ", 
      RowBox[{
      "$BaseDirectory", " ", "<>", " ", "sep", " ", "<>", 
       "\"\<Applications\>\"", "<>", "sep", "<>", "nmt"}]}], ";", 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{"CopyDirectory", "[", 
      RowBox[{"nmt", ",", " ", "dir"}], "]"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4701237036441507`*^9, 3.4701238387960243`*^9}, {
  3.470123876933445*^9, 3.4701238945036993`*^9}, {3.4701259087528667`*^9, 
  3.4701259212366867`*^9}, {3.4701259642693787`*^9, 3.470125965987455*^9}, {
  3.470126130724691*^9, 3.4701261312667294`*^9}, {3.470126251548052*^9, 
  3.47012625280221*^9}}],

Cell[BoxData["\<\"/Library/Mathematica/Applications/MathTIDES\"\>"], "Output",
 CellChangeTimes->{{3.470126124674223*^9, 3.470126132125616*^9}, 
   3.470127379402423*^9, 3.472270844688548*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["UnInstall MathTIDES for all users", "Subsection",
 CellChangeTimes->{{3.470125917330945*^9, 3.470125917577444*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"UnInstallMathTIDES", " ", "=", "\[IndentingNewLine]", "\t", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"nmt", ",", " ", "sep", ",", " ", "dir"}], "}"}], ",", 
    "\[IndentingNewLine]", "\t\t", 
    RowBox[{
     RowBox[{"nmt", " ", "=", " ", "\"\<MathTIDES\>\""}], ";", 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{"sep", " ", "=", " ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"StringFreeQ", "[", 
         RowBox[{"$SystemID", ",", " ", "\"\<Windows\>\""}], "]"}], ",", " ", 
        "\"\</\>\"", ",", " ", "\"\<\\\\\>\""}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{"dir", " ", "=", " ", 
      RowBox[{
      "$BaseDirectory", " ", "<>", " ", "sep", " ", "<>", 
       "\"\<Applications\>\"", "<>", "sep", "<>", "nmt"}]}], ";", 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{"DeleteDirectory", "[", 
      RowBox[{"dir", ",", " ", 
       RowBox[{"DeleteContents", "\[Rule]", "True"}]}], "]"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.4701237036441507`*^9, 3.4701238387960243`*^9}, {
   3.470123876933445*^9, 3.4701238945036993`*^9}, 3.4701259087528667`*^9, 
   3.4701259715413313`*^9, {3.4701261815950203`*^9, 3.470126182010113*^9}, 
   3.4701262591643467`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Install MathTIDES only for this user", "Subsection",
 CellChangeTimes->{{3.470125870231476*^9, 3.470125888025694*^9}, {
  3.47012604410785*^9, 3.4701260515921183`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"InstallMathTIDES", " ", "=", "\[IndentingNewLine]", "\t", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"nmt", ",", " ", "sep", ",", " ", "dir"}], "}"}], ",", 
    "\[IndentingNewLine]", "\t\t", 
    RowBox[{
     RowBox[{"nmt", " ", "=", " ", "\"\<MathTIDES\>\""}], ";", 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{"sep", " ", "=", " ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"StringFreeQ", "[", 
         RowBox[{"$SystemID", ",", " ", "\"\<Windows\>\""}], "]"}], ",", " ", 
        "\"\</\>\"", ",", " ", "\"\<\\\\\>\""}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{"dir", " ", "=", " ", 
      RowBox[{
      "$UserBaseDirectory", " ", "<>", " ", "sep", " ", "<>", 
       "\"\<Applications\>\"", "<>", "sep", "<>", "nmt"}]}], ";", 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{"CopyDirectory", "[", 
      RowBox[{"nmt", ",", " ", "dir"}], "]"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4701237036441507`*^9, 3.4701238387960243`*^9}, {
   3.470123876933445*^9, 3.4701238945036993`*^9}, {3.4701259087528667`*^9, 
   3.4701259212366867`*^9}, {3.4701259642693787`*^9, 3.470125965987455*^9}, {
   3.470126076230434*^9, 3.4701260771390667`*^9}, {3.470126200011981*^9, 
   3.47012620230624*^9}, 3.470126262268528*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["UnInstall MathTIDES for this user", "Subsection",
 CellChangeTimes->{{3.470125917330945*^9, 3.470125917577444*^9}, {
  3.470126058650051*^9, 3.4701260616734333`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"UnInstallMathTIDES", " ", "=", "\[IndentingNewLine]", "\t", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"nmt", ",", " ", "sep", ",", " ", "dir"}], "}"}], ",", 
    "\[IndentingNewLine]", "\t\t", 
    RowBox[{
     RowBox[{"nmt", " ", "=", " ", "\"\<MathTIDES\>\""}], ";", 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{"sep", " ", "=", " ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"StringFreeQ", "[", 
         RowBox[{"$SystemID", ",", " ", "\"\<Windows\>\""}], "]"}], ",", " ", 
        "\"\</\>\"", ",", " ", "\"\<\\\\\>\""}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{"dir", " ", "=", " ", 
      RowBox[{
      "$UserBaseDirectory", " ", "<>", " ", "sep", " ", "<>", 
       "\"\<Applications\>\"", "<>", "sep", "<>", "nmt"}]}], ";", 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{"DeleteDirectory", "[", 
      RowBox[{"dir", ",", " ", 
       RowBox[{"DeleteContents", "\[Rule]", "True"}]}], "]"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.4701237036441507`*^9, 3.4701238387960243`*^9}, {
   3.470123876933445*^9, 3.4701238945036993`*^9}, 3.4701259087528667`*^9, 
   3.4701259715413313`*^9, {3.4701260823313723`*^9, 3.470126083179109*^9}, {
   3.470126232004178*^9, 3.4701262327378387`*^9}, 3.470126264644409*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check your installation", "Section",
 CellChangeTimes->{{3.4701262743502483`*^9, 3.470126282295847*^9}}],

Cell[BoxData[
 RowBox[{"<<", "MathTIDES`"}]], "Input",
 CellChangeTimes->{{3.470126287997384*^9, 3.470126301191834*^9}}]
}, Closed]]
},
WindowSize->{1500, 1051},
WindowMargins->{{87, Automatic}, {40, Automatic}},
ShowSelection->True,
FrontEndVersion->"7.0 for Mac OS X x86 (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 209, 3, 100, "Section"],
Cell[779, 27, 122, 5, 84, "Text"],
Cell[904, 34, 242, 9, 197, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1183, 48, 101, 1, 100, "Section"],
Cell[1287, 51, 244, 3, 192, "Text"],
Cell[CellGroupData[{
Cell[1556, 58, 119, 1, 51, "Subsection"],
Cell[CellGroupData[{
Cell[1700, 63, 1422, 32, 179, "Input"],
Cell[3125, 97, 192, 2, 40, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[3366, 105, 121, 1, 37, "Subsection"],
Cell[3490, 108, 1407, 33, 179, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[4934, 146, 174, 2, 37, "Subsection"],
Cell[5111, 150, 1452, 32, 179, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6600, 187, 172, 2, 51, "Subsection"],
Cell[6775, 191, 1457, 33, 179, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8281, 230, 110, 1, 100, "Section"],
Cell[8394, 233, 120, 2, 40, "Input"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
