      SUBROUTINE ZZSRCH (STRING,ISTRLN,DICT,DICTLN,KEYLEN,NUMBER,
     -                   SORTED,UPCASE                          )

C## A R G U M E N T S:
                      INTEGER       DICTLN, NUMBER, ISTRLN, KEYLEN
                      CHARACTER*(*) STRING,   DICT
                      LOGICAL       SORTED, UPCASE

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION:        NOT REQUIRED.
C               SYSTEM  DEPENDENCE:                      NONE.
C
C>RCS $HEADER: SRCH.F,V 1.10 91/11/20 10:53:09 BUCKLEY EXP $
C>RCS $LOG:     SRCH.F,V $
C>RCS REVISION 1.10  91/11/20  10:53:09  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 1.9  89/06/30  13:39:53  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.3.1.1  89/05/20  16:43:00  BUCKLEY
C>RCS TEMP. TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.3  89/05/18  12:20:53  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:48:19  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM.
C>RCS
C>RCS REVISION 1.1  89/01/17  16:50:14  BUCKLEY
C>RCS INITIAL REVISION
C>RCS
C
C## D E S C R I P T I O N:
C
C        THIS ROUTINE SEARCHES A DICTIONARY DICT OF KEYWORDS FOR
C        A SPECIFIC ENTRY GIVEN AS STRING. WE HAVE THE FOLLOWING.
C
C     ON ENTRY:
C
C        STRING     THE STRING TO SEARCH FOR.
C
C        ISTRLN     ABS(ISTRLN) CHARACTERS OF STRING ARE USED IN THE
C                   COMPARISON. IF ABS(ISTRLN) IS >= LEN(STRING), THE
C                   FULL STRING IS USED. IF THE STRING TO COMPARE IS
C                   LARGER THAN THE ENTRIES IN THE DICTIONARY, EXCESS
C                   CHARACTERS ON THE RIGHT ARE IGNORED.
C                       EACH ENTRY OF THE DICTIONARY MAY CONTAIN
C                   EITHER ONE OR TWO PARTS (REFERRED TO AS HALVES SINCE
C                   THE PARTS MUST BE OF EQUAL LENGTH). IF ISTRLN IS
C                   POSITIVE THE COMPARISON IS MADE WITH THE FIRST (OR
C                   ONLY) PART OF EACH ENTRY. IF ISTRLN IS NEGATIVE THEN
C                   THE SECOND HALF OF EACH DICTIONARY ENTRY IS USED IN
C                   THE COMPARISON.
C
C        DICT       THE DICTIONARY. NOTE THAT THE KEYWORDS IN THE
C                   DICTIONARY ARE STORED AS A SINGLE (CONCATENATED)
C                   CHARACTER STRING, WITH NO SEPARATION BETWEEN
C                   KEYWORDS. THEY MUST THEREFORE BE OF A FIXED LENGTH.
C                   NOTE ALSO THAT EACH ENTRY MAY ACTUALLY BE COMPRISED
C                   OF TWO PARTS OF EQUAL LENGTH.
C
C        DICTLN     THE NUMBER OF ENTRIES IN THE DICTIONARY DICT.
C
C        NUMBER     THE ENTRY IN DICT AT WHICH TO START THE SEARCH.
C                   IF FOR EXAMPLE, NUMBER=3, THEN THE SEARCH IS ON
C                   ENTRIES 3,4,...,DICTLN IN THE DICTIONARY.
C
C        SORTED     TRUE IF THE DICT IS SORTED IN ALPHABETICAL ORDER
C
C        UPCASE     TRUE IF ALL ENTRIES IN THE STRING ARE ALREADY IN
C                   UPPER CASE.
C
C     ON EXIT:
C
C        UNALTERED      STRING, ISTRLN, DICT, DICTLN, SORTED
C
C        NUMBER   = 0   IF THE SEARCH FAILED TO FIND THE DESIRED STRING.
C                 = K   IF ENTRY K IN THE DICTIONARY IS THE FIRST
C                       DICTIONARY ENTRY FOUND TO MATCH THE STRING,
C                       AS LEAST AS FAR AS THE FIRST ISTRLN CHARAC-
C                       TERS ARE CONCERNED.
C
C## E N T R Y   P O I N T S: THE NATURAL ENTRY ZZSRCH
C## S U B R O U T I N E S:   ABS, MIN, MAX, LEN   ...INTRINSIC
C## P A R A M E T E R S:

      INTEGER     CTOUPP,     CTOLOW,     CTOCAP
      PARAMETER ( CTOUPP = 1, CTOLOW = 2, CTOCAP = 3 )
C## L O C A L   D E C L:
                             INTEGER I, IS,  LENG,  K, J, L, OFFSET
                             CHARACTER   CH*1

C## S A V E:                 NONE SELECTED.
C## E Q U I V A L E N C E S: NONE ARE DEFINED.
C## C O M M O N:             NONE IS DEFINED.
C## D A T A:                 NONE ARE SET.
C##                                                E X E C U T I O N
C##                                                E X E C U T I O N

      IF ( ISTRLN .LT. 0 ) THEN
         OFFSET = KEYLEN / 2
      ELSE
         OFFSET = 0
      ENDIF

      LENG   = MIN ( ABS(ISTRLN), KEYLEN, LEN(STRING) )
      IS     = MAX ( 1,NUMBER )
      NUMBER = 0

      J = (IS-1) * KEYLEN + 1 + OFFSET

C---- USE SIMPLE SEQUENTIAL SEARCH
C      - NOT LONG ENOUGH FOR BINARY, AND NEED NOT BE SORTED

      DO 100 K=IS,DICTLN

         L = J
         DO 50 I = 1, LENG
            CH = STRING(I:I)
            IF ( .NOT. UPCASE ) THEN
               CALL ZZCASE(CH,CTOUPP)
            ENDIF
            IF ( CH .NE. DICT(L:L) ) GOTO 60
            L = L + 1
   50    CONTINUE

         NUMBER = K
         GOTO 90000

   60    IF ( SORTED .AND. LLT(CH,DICT(L:L)) ) THEN
            GOTO 90000
         ELSE
            J = J + KEYLEN
         ENDIF
  100 CONTINUE
      GOTO 90000

C## E X I T
90000       RETURN

C## F O R M A T S:  NONE ARE DEFINED.
C##                 E N D         OF ZZSRCH.
                    END
