      INTEGER FUNCTION ZZRECL ( CPERLN, IPERLN, LPERLN, RPERLN )

C## A R G U M E N T S:
                      INTEGER  CPERLN, IPERLN, LPERLN, RPERLN

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION: NEEDED (SEE CONVRT).
C
C               IGNORE LINES BEGINNING WITH  "C!!!!" .
C
C               THIS VERSION IS IN   S I N G L E   PRECISION.
C!!!!           THIS VERSION IS IN   D O U B L E   PRECISION.
C
C               SYSTEM  DEPENDENCE: SYSTEM ROUTINE FOR DIRECT
C                                   ACCESS UNFORMATTED RECORD LENGTH
C
C             THIS VERSION IS FOR  SUN4
C
C>RCS $HEADER: RECL.GL,V 2.1 91/11/22 11:45:23 BUCKLEY EXP $
C>RCS $LOG:     RECL.GL,V $
C>RCS REVISION 2.1  91/11/22  11:45:23  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 2.0  90/07/16  14:39:15  BUCKLEY
C>RCS ADDED LAHEY
C>RCS
C>RCS REVISION 1.9  89/06/30  13:30:18  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.3.1.1  89/05/20  13:46:30  BUCKLEY
C>RCS TEMP. TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.3  89/05/18  12:13:29  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:35:07  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM.
C>RCS
C>RCS REVISION 1.1  89/01/17  16:34:32  BUCKLEY
C>RCS INITIAL REVISION
C>RCS

C## D E S C R I P T I O N:
C
C     THIS ROUTINE USES FOUR INTEGER CONSTANTS NEEDED TO DETERMINE
C     THE LENGTH OF AN UNFORMATTED RECORD FOR READING AND WRITING
C     DIRECT ACCESS FILES. THE PROCESSOR IS ASSUMED, ACCORDING
C     TO THE FORTRAN STANDARD, TO WRITE UNFORMATTED RECORDS
C     IN "PROCESSOR DEFINED UNITS", I.E. IN PDU'S.
C
C     HERE WE MUST DEFINE FOUR CONSTANTS:
C
C        CHARS   THE NUMBER OF PDU'S NEEDED TO WRITE ONE CHARACTER;
C        INTS    THE NUMBER OF PDU'S NEEDED TO WRITE ONE INTEGER VALUE;
C        LOGS    THE NUMBER OF PDU'S NEEDED TO WRITE ONE LOGICAL VALUE;
C        REALS   THE NUMBER OF PDU'S NEEDED TO WRITE ONE REAL(DP) VALUE.
C
C     NOTE THAT IT MAY HAPPEN (PARTICULARLY WITH CHARACTER OR LOGICAL
C     DATA) THAT SEVERAL VALUES MAY FIT INTO ONE PDU. IN THIS CASE, SET
C     THE CONSTANT TO A NEGATIVE VALUE. FOR EXAMPLE, ON A CYBER, A PDU
C     IS ONE WORD AND 10 CHARACTERS FIT PER WORD. IN THIS CASE, CHARS
C     IS SET TO -10. BUT ON A VAX, A PDU IS ONE BYTE AND AN INTEGER
C     OCCUPIES 4 BYTES, SO INTS IS SET TO 4. NOTE THAT THE VALUES FOR
C     'REALS' WILL GENERALLY BE DIFFERENT FOR THE SINGLE AND DOUBLE
C     PRECISION VERSIONS ON THE SAME MACHINE.
C
C     ON ENTRY, THE FOUR ARGUMENTS INDICATE HOW MANY VALUES OF EACH OF
C     THE FOUR BASIC TYPES ARE REQUIRED TO FIT IN ONE DIRECT ACCESS
C     UNFORMATTED RECORD. THIS ROUTINE WILL DETERMINE THE MINIMUM RECORD
C     LENGTH NEEDED TO SATISFY ALL FOUR REQUIREMENTS. THAT VALUE WILL BE
C     RETURNED AS THE VALUE OF THE FUNCTION ZZRECL.
C
C     IT WILL THEN *RETURN* IN EACH OF THE FOUR ARGUMENTS THE *ACTUAL*
C     NUMBER OF EACH OF THESE WHICH CAN FIT IN THE RECORD OF THE SIZE
C     DETERMINED.
C
C     N.B. **** THIS ROUTINE ASSUMES *NO MIXING* OF DATA TYPES ON
C               ANY ONE RECORD WHEN USING DIRECT ACCESS UNFORMATTED I/O.
C               THUS EACH TIME A RECORD IS WRITTEN, IT CONTAINS *ONLY*
C               CHARACTER DATA, OR *ONLY* INTEGER DATA, OR *ONLY* REAL
C               DATA, OR *ONLY* LOGICAL DATA.   ANY MIXING WOULD
C               TOTALLY DESTROY ANY HOPE OF PORTABILITY TO SOME SYSTEMS.
C
C## E N T R Y   P O I N T S: THE NATURAL ENTRY ZZRECL.
C## S U B R O U T I N E S:   ABS, MAX   ... INTRINSIC
C
C## P A R A M E T E R S:

      INTEGER      CHARS,     INTS,     LOGS,     REALS
      PARAMETER (  CHARS = 1, INTS = 4, LOGS = 4, REALS = 4 )
C!!!! PARAMETER (  CHARS = 1, INTS = 4, LOGS = 4, REALS = 8 )

C## L O C A L   D E C L:
                        INTEGER  N

C## S A V E:                 NONE SELECTED.
C## E Q U I V A L E N C E S: NONE ARE DEFINED.
C## C O M M O N:             NONE IS DEFINED.
C## D A T A:                 NONE ARE SET.
C##                                                E X E C U T I O N
C##                                                E X E C U T I O N
      ZZRECL = 1

      IF ( CHARS .LT. 0 ) THEN
         N = ABS(CHARS)
         N = ( CPERLN + N - 1 ) / N
      ELSE
         N = CPERLN * CHARS
      ENDIF

      ZZRECL = MAX ( ZZRECL, N )

      IF ( INTS .LT. 0 ) THEN
         N = ABS(INTS)
         N = ( IPERLN + N - 1 ) / N
      ELSE
         N = IPERLN * INTS
      ENDIF

      ZZRECL = MAX ( ZZRECL, N )

      IF ( LOGS .LT. 0 ) THEN
         N = ABS(LOGS)
         N = ( LPERLN + N - 1 ) / N
      ELSE
         N = LPERLN * LOGS
      ENDIF

      ZZRECL = MAX ( ZZRECL, N )

      IF ( REALS .LT. 0 ) THEN
         N = ABS(REALS)
         N = ( RPERLN + N - 1 ) / N
      ELSE
         N = RPERLN * REALS
      ENDIF

      ZZRECL = MAX ( ZZRECL, N )

C## E X I T
90000      RETURN

C## F O R M A T S:  NONE ARE DEFINED.
C##                 E N D         OF ZZRECL.
                    END
