      SUBROUTINE BBLNIR ( FUNCNM, N,  X,  FX, DECRF, G, ACC, STATUS,
     -                     INNER, D, XX, GG, H, HDIM, IW, RW, DW     )

C## A R G U M E N T S:
                      EXTERNAL    FUNCNM, INNER
                      INTEGER   N, HDIM, STATUS, IW(*)

                      REAL             X(N),G(N),D(N),XX(N),GG(N),H(*)
C!!!!                 DOUBLE PRECISION X(N),G(N),D(N),XX(N),GG(N),H(*)

                      REAL              FX, ACC, DECRF
C!!!!                 DOUBLE PRECISION  FX, ACC, DECRF

                      DOUBLE PRECISION DW(*), INNER, FUNCNM
                      REAL             RW(*)

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION: NEEDED (SEE CONVRT).
C
C               IGNORE LINES BEGINNING WITH  "C!!!!" .
C
C               THIS VERSION IS IN   S I N G L E   PRECISION.
C!!!!           THIS VERSION IS IN   D O U B L E   PRECISION.
C
C               SYSTEM  DEPENDENCE:                      NONE.
C
C>RCS $HEADER: LNIR.F,V 2.4 91/12/16 11:31:53 BUCKLEY EXP $
C>RCS $LOG:     LNIR.F,V $
C>RCS REVISION 2.4  91/12/16  11:31:53  BUCKLEY
C>RCS MINOR FIX FOR TOMS.
C>RCS
C>RCS REVISION 2.3  91/11/22  11:30:00  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 2.2  90/08/06  16:24:49  BUCKLEY
C>RCS ADDED TEST THAT ALL ARGUMENTS/PARAMETERS VALID.
C>RCS
C>RCS REVISION 2.1  90/07/31  10:43:08  BUCKLEY
C>RCS ADDED REVISED BLAS.
C>RCS
C>RCS REVISION 2.0  90/07/17  14:58:51  BUCKLEY
C>RCS MINOR FIX TO REMOVE UNUSED DBLE AND RD
C>RCS .,
C>RCS
C>RCS REVISION 1.9  89/06/30  13:51:01  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.3  89/05/18  12:39:19  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:55:28  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM.
C>RCS
C>RCS REVISION 1.1  89/01/17  16:54:28  BUCKLEY
C>RCS INITIAL REVISION
C>RCS
C
C## D E S C R I P T I O N:
C
C---GENERAL COMMENTS.
C
C       THE CALLING SEQUENCE IS DESCRIBED BELOW.  THE PURPOSE OF THE
C     ALGORITHM IS TO FIND AN ESTIMATE OF A LOCAL MINIMUM OF A GIVEN
C     NONLINEAR FUNCTION  F  OF  N  REAL VARIABLES  X(1),...,X(N).
C     THE PROGRAM USES ONE OF TWO METHODS:  A  QUASI-NEWTON ALGORITHM
C     OR A VARIABLE STORAGE CONJUGATE GRADIENT ALGORITHM. THIS CODE
C     IS INTENDED FOR PROBLEMS WITH MODERATE TO LARGE N, BUT IT WILL
C     ALSO WORK VERY WELL FOR SMALL N.
C
C       THE PROGRAM IS AN EXTENSION OF THE ROUTINE  CONMIN  PUBLISHED
C     EARLIER BY SHANNO AND PHUA (SEE TOMS, DEC 1980, VOL. 6, NO. 4 ).
C     THE QUASI-NEWTON PART OF OUR CODE IS LOGICALLY EQUIVALENT TO THE
C     QUASI-NEWTON PART OF CONMIN, ALTHOUGH IT APPEARS SOMEWHAT DIFF-
C     ERENT BECAUSE WE HAVE USED THE SUPERIOR CODE AVAILABLE WITH
C     FORTRAN 77.  IT PRODUCES IDENTICAL RESULTS.  IF SUFFICIENT
C     STORAGE IS AVAILABLE, THE QUASI-NEWTON METHOD WILL BE USED.
C     THIS IS NOT TRUE IN  CONMIN, AND MORE INFORMATION IS AVAILABLE
C     BELOW: SEE "METH" IN THE SECTION ABOUT ENTRY POINT VARIABLES.
C
C       THE CONJUGATE GRADIENT METHOD IS DESCRIBED IN THE PAPER
C     "QN-LIKE VARIABLE STORAGE CONJUGATE GRADIENTS", WHICH HAS
C     APPEARED IN MATHEMATICAL PROGRAMMING.  IT IS THIS PART OF THE
C     CODE WHICH IS THE REAL CONTRIBUTION OF THIS PROGRAM.  IT IS
C     INTENDED TO BE A CONJUGATE GRADIENT CODE WHOSE PERFORMANCE WILL
C     IMPROVE AS THE STORAGE PROVIDED TO THE ROUTINE IS INCREASED.
C
C---ALGORITHM DESCRIPTION.
C
C       HERE WE DESCRIBE THOSE DETAILS WHICH WILL AID IN UNDERSTANDING
C     SUBSEQUENT COMMENTS.  FURTHER DETAILS SHOULD BE OBTAINED FROM
C     THE PAPER. ONLY THE CONJUGATE GRADIENT PART OF THE CODE WILL BE
C     DISCUSSED HERE AS IT IS THE ORIGINAL CONTRIBUTION.
C
C       THE ALGORITHM STARTS FROM AN INITIAL POINT  X[0], WHICH MUST BE
C     GIVEN. THE INITIAL SEARCH PROCEEDS ALONG A DIRECTION  D[1] TO
C     X[1]. WE REFER TO  D[1] AS A RESTART STEP, AND TO X[1] AS A
C     RESTART POINT.  THE ALGORITHM IS IN TWO PARTS: A QUASI-NEWTON
C     PART AND A CONJUGATE GRADIENT PART.  LET  X[R]  DENOTE A RESTART
C     POINT (OF WHICH THE FIRST IS X[1]).  AT A RESTART POINT, A QUASI-
C     NEWTON UPDATE IS CALCULATED, SAY H[1], WHICH IS AN UPDATE OF H[0]
C     (NORMALLY THE IDENTITY), AND THE CURRENT POINT IS RELABELLED AS
C     X[1] (IF IT ISN'T ALREADY). THE UPDATE MATRIX IS SAVED BY STORING
C     2 VECTORS AND 2 SCALARS.  THE POINT  X[R]  MARKS THE START OF THE
C     QUASI-NEWTON PART.
C
C       AT EACH SUBSEQUENT POINT X[2],X[3],..., A NEW UPDATE IS FORMED,
C     NAMELY  H[2],H[3],..., AND A NEW SEARCH DIRECTION IS FORMED AS
C     D[I+1] = - H[I]*G[I].  EACH UPDATE MATRIX  H[I] IS DEFINED AS AN
C     UPDATE OF THE PREVIOUS MATRIX  H[I-1] AND H[I] IS SAVED BY STOR-
C     ING AN ADDITIONAL  2  VECTORS AND  2  SCALARS. WHEN THE UPDATE
C     TERMS WHICH HAVE BEEN STORED HAVE USED ALL OF THE STORAGE WHICH
C     IS AVAILABLE, WE END THE QUASI-NEWTON PART. THUS THE QUASI-NEWTON
C     PART EXTENDS FROM  X[1]  TO  X[M+1], ASSUMING THAT THERE IS ROOM
C     FOR  M  UPDATE TERMS.  UPON REACHING  X[M+1], WE SWITCH TO THE
C     CONJUGATE GRADIENT  PART.
C
C       THE CG PART CONTINUES IN MUCH THE SAME WAY, WITH  DIRECTIONS
C     D[I+1] = -H[I]*G[I]. THE DIFFERENCE IS THAT AT EACH STEP, THE
C     UPDATE MATRIX  H[I]  (FOR I>M) IS DEFINED AS AN UPDATE OF  H[M],
C     AND INDEED  H[I] IS NEITHER STORED NOR EXPLICITLY CALCULATED.
C     WHETHER ONE IS IN THE  QUASI-NEWTON PART OR CONJUGATE GRADIENT
C     PART ALSO HAS RAMIFICATIONS IN THE STRATEGY EMPLOYED IN THE
C     LINE SEARCH.  THIS IS EXPLAINED IN THE  MATHEMATICAL PROGRAMMING
C     PAPER AND IN THE CODE.
C
C       THE CG PART CONTINUES UNTIL IT IS DECIDED TO DO A RESTART.
C     SUPPOSE THAT WE HAVE JUST COMPLETED THE LINE SEARCH TO REACH
C     A POINT  X[I].  IN CERTAIN CIRCUMSTANCES, WHICH ARE EXPLAINED
C     IN THE PAPER AND BELOW, WE WILL DECLARE  X[I] TO BE A RESTART
C     POINT, IN WHICH CASE WE WILL REFER TO IT AS  X[R], AND IN FACT
C     WE WILL RELABEL IT AS  X[1].  THE STEP LEADING TO  X[R] WILL
C     BE REFERRED TO AS A RESTART STEP.  NOTE THAT THE INITIAL STEP
C     FROM  X[0] ALONG  D[1] IS THE FIRST RESTART STEP, AND  X[1]
C     IS THE FIRST RESTART POINT.  UPON DECLARING  X[R] TO BE A
C     RESTART POINT, WE DECLARE  THE  CG PART ENDED, AND WE START
C     THE QN PART AGAIN.
C
C---CALLING SEQUENCE. ( THE SECTION "REVERSE COMMUNICATION" BELOW
C                        EXPLAINS SOME EXTENSIONS TO THE CALL.   )
C
C     ON ENTRY TO BBLNIR:
C
C       FUNCNM  THE NAME OF THE EVALUATION SUBROUTINE WHICH DEFINES
C               THE FUNCTION TO BE MINIMIZED. A SUBROUTINE TO
C               EVALUATE THE FUNCTION MUST BE PROVIDED AND IT
C               MUST HAVE THE SAME CALLING SEQUENCE AS IN THE
C               EXAMPLE PROVIDED AND AS EXPLAINED IN ZZEVAL.
C
C       N       THE PROBLEM DIMENSION, I.E. THE NUMBER OF VARIABLES
C               IN THE PROBLEM.  BOTH X AND  G  MUST THEREFORE BE
C               OF DIMENSION  N.
C
C       X       A VECTOR OF LENGTH  N  WHICH CONTAINS AN INITIAL
C               GUESS AT THE MINIMUM.  THUS ON ENTRY  X  IS THE
C               VECTOR REFERRED TO AS  X[0].
C
C       FX, G   THESE MAY BE REQUIRED ON INPUT, ACCORDING TO THE
C               VALUE OF STATUS, BELOW.
C
C       DECRF   THIS MAY BE AN ESTIMATE OF THE EXPECTED DECREASE IN
C               THE FUNCTION VALUE.  IF SUCH A VALUE IS NOT KNOWN,
C               THEN DECRF MAY BE SET TO BE < 0 AND IT WILL BE IGNORED.
C               IT CAN HOWEVER BE VERY HELPFUL TO HAVE AN ESTIMATE
C               OF !F(X0)-F(X*)!, WHERE X0 IS THE INITIAL POINT AND
C               F(X*) IS THE FUNCTION VALUE AT THE MINIMUM X*. NOTE
C               THAT IT IS OFTEN POSSIBLE TO ESTIMATE DECRF WITHOUT
C               KNOWLEDGE OF X*. IN PARTICULAR, IF F(X*) IS EXPECTED
C               TO BE 0, THEN DECR MAY BE SET TO ZERO AND F(X0) WILL
C               BE USED AS AN ESTIMATE OF THE EXPECTED REDUCTION IN F.
C
C       ACC     THE ACCURACY DESIRED IN THE FINAL ESTIMATE OF THE
C               MINIMUM. SEE  ZZTERM  FOR MORE INFORMATION.
C
C       STATUS  THIS IS A CODE TO INDICATE THE ROUTINE'S STATUS
C               ON ENTRY AND EXIT. THE CODE IS AN INTEGER VALUE. THE
C               VALUES NORMALLY USED ARE GIVEN BELOW THE NAME USED
C               FOR THE CODE. THE INTEGER VALUES MAY BE CHANGED BY
C               USING THE ENTRY POINT BBLIDF BELOW. ON ENTRY, WE HAVE:
C
C         = NORMFG  THIS IS JUST LIKE THE CASE STATUS=NORMAL, EXCEPT
C           (-1)    THAT IT INDICATES THAT, UPON ENTRY TO BBLNIR,
C                   THE FUNCTION AND GRADIENT VALUES AT THE INITIAL
C                   POINT X ARE ALREADY AVAILABLE.
C         = NORMAL  AN "ORDINARY" CALL. MINIMIZE THE FUNCTION AND
C           (0)     CALL ZZEVAL WHEN FUNCTION AND/OR GRADIENT
C                   VALUES ARE REQUIRED.
C         = RCSTRT  THIS IS AN INITIAL CALL INDICATING THAT REVERSE
C           (1)     COMMUNICATION IS TO BE USED; SEE BELOW.
C         = RCRPT   THIS IS A SECONDARY CALL WITH REVERSE COMMUNI-
C           (2)     CATION; SEE BELOW, AS WELL AS STATUS=RCNOFG.
C         = RCNOFG  THIS IS ALSO A SECONDARY CALL WITH REVERSE
C           (3)     COMMUNICATION, BUT IT INDICATES THAT THE MAIN
C                   ROUTINE WAS UNABLE TO PROVIDE THE DESIRED FUNCTION
C                   AND/OR GRADIENT VALUE.
C
C       HDIM    THIS IS AN INTEGER VALUE GIVING THE NUMBER OF LOCA-
C               TIONS OF STORAGE AVAILABLE IN  H. IN THE DEFAULT
C               CASE (SEE METH BELOW), THIS WILL DETERMINE THE
C               METHOD USED.  IF HDIM IS LARGE ENOUGH, A QUASI-
C               NEWTON METHOD WILL BE USED. OTHERWISE, A CONJUGATE
C               GRADIENT METHOD WILL BE USED WITH AS MANY UPDATES
C               BEING STORED AS IS POSSIBLE.
C
C     TEMPORARY WORK AREAS:
C
C       D, XX, GG, H
C
C       IW   NOTE THAT THE THREE ARRAYS  IW, RW AND DW ARE NOT
C       RW   TOUCHED BY THE MINIMIZATION ALGORITHM. THEY ARE PROVIDED
C       DW   TO FACILITATE COMMUNICATION BETWEEN THE USERS CALLING
C            ROUTINE AND THE FUNCTION EVALUATION ROUTINE WHICH THE
C            USER MUST ALSO PROVIDE.  THERE IS ONE VECTOR PROVIDED
C            OF EACH BASIC NUMERIC TYPE. THE AVAILABILITY OF THESE
C            ARRAYS MAY OFTEN PRECLUDE THE NECESSITY OF USING
C            REVERSE COMMUNICATION.  THEY ARE PROVIDED THEREFORE IN
C            THE CALLING SEQUENCE OF THE USER FUNCTION EVALUATION
C            ROUTINE, AND WILL BE PASSED BOTH IN AND BACK WITHOUT
C            CHANGE BY THE MINIMIZATION ALGORITHM.
C
C      INNER THIS IS THE NAME OF THE DOUBLE PRECISION FUNCTION FOR
C            COMPUTING  INNER PRODUCTS. SEE THE COMMENTS IN BBMULT.
C
C     UPON EXIT FROM BBLNIR:
C
C       X       THE FINAL ESTIMATE OF THE MINIMUM WHICH WAS FOUND,
C               PROVIDED THAT STATUS IS ZERO. IF STATUS IS NOT
C               ZERO, THE VALUES IN X, FX AND G  MAY BE UNRELIABLE.
C
C       FX      THE FUNCTION VALUE AT THE FINAL ESTIMATE  X.
C
C       G       THE GRADIENT VALUE AT THE FINAL ESTIMATE  X.
C
C       STATUS  AGAIN, THE INTEGER IS THE INTEGER CODE NORMALLY USED
C               UNLESS REDEFINED VIA THE ENTRY BBLSDF.
C
C          = DONE   NORMAL TERMINATION: AN ACCURATE SOLUTION APPEARS TO
C            (0)    HAVE BEEN FOUND.
C          = NOSTOR EXECUTION NEVER BEGAN BECAUSE THERE WAS INSUFFICIENT
C            (-1)   STORAGE ALLOCATED. THE MINIMUM REQUIREMENT FOR HDIM
C                   IS 0. SEE BBVSCG AND "METH" BELOW.
C          = IPMIN  THE INITIAL FX OR G WAS A CRITICAL POINT.
C            (-2)
C          = IPUNDF THE INITIAL FX OR G WAS UNDEFINED.
C            (-3)
C          = BDMETH EXECUTION NEVER BEGAN BECAUSE AN INVALID METHOD WAS
C            (-4)   SPECIFIED.  THIS WOULD NEVER HAPPEN IN NORMAL USE.
C          = LSFAIL THE LINE SEARCH FAILED. THIS IS PROBABLY BECAUSE TOO
C            (-5)   HIGH AN ACCURACY REQUIREMENT WAS GIVEN FOR THE
C                   MACHINE IN USE, OR BECAUSE THE FUNCTION AND/OR
C                   GRADIENT EVALUATIONS ARE INCORRECTLY CODED. THIS
C                   EXIT IS MORE LIKELY WHEN FINITE DIFFERENCES
C                   ARE BEING USED TO CALCULATE DERIVATIVES.
C          = NODESC A NON-DESCENT SEARCH DIRECTION WAS GENERATED. THIS
C            (-6)   CAN ONLY BE DUE TO ROUNDOFF AND THE CAUSE IS
C                   POSSIBLY THE SAME AS FOR STATUS  = LSFAIL.
C          = XSFUNC EXECUTION HALTED WHEN MORE THAN THE ALLOWED NUMBER
C            (-7)   OF FUNCTION EVALUATIONS WAS ATTEMPTED.
C          = PSBACK THE PASS-THROUGH CALL WAS SUCCESSFUL
C            (-8)
C          = RABORT AN ABORT WAS REQUESTED BY THE FUNCTION EVALUATION
C            (-9)   ROUTINE.
C          = RCXX   THESE ARE USED FOR REVERSE COMMUNICATION; SEE BELOW.
C
C---REVERSE COMMUNICATION:
C
C      IN SOME APPLICATIONS IT MAY NOT BE APPROPRIATE TO OBTAIN
C      FUNCTION VALUES BY CALLING THE ROUTINE ZZEVAL. BEFORE CONCLUDING
C      THIS HOWEVER, ONE SHOULD READ THE COMMENTS ABOVE ON THE ARRAYS
C      IW, RW AND DW.
C
C      IN THE CASE THAT THOSE ARRAYS ARE NOT APPROPRIATE, AN ALTERNATIVE
C      IS TO USE REVERSE COMMUNICATION.  THE ARGUMENTS TO BBLNIR HAVE
C      THE SAME MEANINGS AS ABOVE, WITH THE FOLLOWING MODIFICATIONS.
C
C      1. ON THE INITIAL CALL TO BBLNIR, STATUS MUST BE SET TO RCSTRT,
C         AND FX  AND  G MUST CONTAIN THE VALUE OF THE FUNCTION AND
C         GRADIENT AT THE POINT  X  WHICH IS SPECIFIED AS THE STARTING
C         POINT FOR THE MINIMIZATION.
C
C      2. WHEN  BBVSCG REQUIRES FURTHER FUNCTION AND GRADIENT VALUES,
C         IT WILL RETURN TO THE CALLING PROGRAM WITH
C           STATUS = RCF(1), RCFG(2) OR RCG(3)
C         WITH  X  CONTAINING A SET OF  N COORDINATES.  IN THIS CASE,
C         THE CALLING PROGRAM MUST OBTAIN THE VALUE OF THE FUNCTION
C         AND/OR THE GRADIENT AT THE SPECIFIED POINT  X, AND THEN CALL
C         BBVSCG AGAIN WITH THESE VALUES IN FX AND G.  NONE OF THE OTHER
C         PARAMETERS MUST BE ALTERED EXCEPT THAT  STATUS MUST
C         TO SET TO RCRPT OR TO RCNOFG  BEFORE CALLING BBVSCG AGAIN.
C         AGAIN, THE INTEGER CODES MAY BE CHANGED BY CALLING AN ENTRY
C         POINT BBLSDF BEFORE USING BBLNIR.
C
C      3. EXECUTION OF BBVSCG WILL TERMINATE AS USUAL, AND ANY VALUE
C         OF STATUS OTHER THAN RCF, RCFG OR RCG ON RETURN MUST BE
C         TAKEN AS A SIGNAL TO QUIT.
C
C      NOTE THAT BBLNIR IS NORMALLY CALLED VIA BBVSCG, AND RETURN
C      TO THE MAIN ROUTINE IS THEREFORE ALSO THROUGH BBVSCG. THAT IS
C      NO PROBLEM, FOR BBVSCG WILL CHECK FOR THE USE OF REVERSE
C      COMMUNICATION.  IF BBLNIR IS BEING CALLED DIRECTLY BY THE USER,
C      ONE MUST BE CAREFUL TO DO ALL INITIALIZATION BEFORE THE FIRST
C      CALL TO BBLNIR, EVEN IF ONE IS USING REVERSE COMMUNICATION.
C
C---I/O.
C
C     INPUT:
C
C          THERE IS NO INPUT REQUIRED.  ALL INFORMATION NEEDED BY THE
C        ROUTINE IS TAKEN FROM THE CALLING SEQUENCE OR FROM THE ENTRY
C        POINT CALL TO  BBLSET.
C
C     OUTPUT:
C
C          THE CURRENT VERSION IS SET UP TO PRINT THE INITIAL GUESS
C        X[0]  AND THE SOLUTION. ALL OUTPUT IS ON UNIT 6.
C
C          IF IT IS DESIRED, THIS OUTPUT MAY BE DELETED OR MORE
C        EXTENSIVE OUTPUT MAY BE OBTAINED.  THE BASIC CONTROL IS DONE
C        IN THE ROUTINE ZZPRNT AND MAY BE ALTERED BY USING THE ENTRY
C        POINT  ZZP1ST INTO ZZPRNT. SEE THE EXTERNAL DOCUMENTATION
C        AND THE LISTING OF ZZPRNT.
C
C          OTHER OUTPUT MAY BE OBTAINED BY TURNING ON VARIOUS TRACES
C        AS IS DESCRIBED LATER IN THIS LISTING.
C
C---IMPLEMENTATION NOTES.
C
C     1. THE ROUTINE USES A MACHINE DEPENDENT CONSTANT EPS. THIS IS
C        DETERMINED BY CALLING THE ROUTINE ZZMPAR.  CONSULT THAT
C        ROUTINE FOR MORE INFORMATION.
C        THE ONLY OTHER MACHINE DEPENDENCE IS IN THE USE OF A TIMING
C        ROUTINE.  THIS IS ISOLATED IN  ZZSECS WHICH CAN BE EASILY
C        ALTERED OR REMOVED.
C
C     2. BOTH SINGLE AND DOUBLE PRECISION VERSIONS ARE SUPPLIED. THIS
C        VERSION IS IN ONE SPECIFIC PRECISION.  TO GET THE ALTERNATE
C        PRECISION, USE THE PROGRAM CONVERT AND CHANGE FROM MODE
C        "A" TO MODE "B".  ALTERNATELY, IF YOU HAVE A GOOD EDITOR,
C        LOOK FOR LINES BEGINNING "C!!!!" AND INTERCHANGE ALL BUT THE
C        FIRST 5 CHARACTERS OF THOSE LINES WITH THE CORRESPONDING
C        CHARACTERS OF THE IMMEDIATELY PRECEDING LINE.
C
C     3. THERE ARE A NUMBER OF CONTROL PARAMETERS WHICH ARE INITIALIZED
C        IN DATA STATEMENTS BELOW, BUT WHICH CAN BE CHANGED BY
C        CALLING THE ENTRY POINT  BBLSET WITH NEW VALUES.  ALL HAVE
C        DEFAULT VALUES AND THERE IS NO NEED TO CHANGE ANY OF THEM.
C        PERSONS WISHING TO EXPERIMENT WITH THE CODE MAY CHANGE THEM
C        IF DESIRED, SO THEY ARE EXPLAINED BELOW. SUCH CHANGES ARE
C        NOT RECOMMENDED UNLESS YOU ARE VERY FAMILIAR WITH THE METHOD.
C
C     4. ALL OUTPUT IN ON UNIT  6.  IF THAT IS NOT SATISFACTORY, THAT
C        MAY BE CHANGED.  THE UNIT IS DEFINED IN THE ROUTINE ZZPRNT AND
C        MORE INFORMATION MAY BE OBTAINED FROM THE LISTING OF ZZPRNT.
C
C     5. WHEN DEVELOPING THIS CODE, IT WAS FOUND USEFUL TO INCLUDE
C        SOME ABILITY TO TRACE PARTS OF THE CODE WITH SOME APPROPRIATE
C        OUTPUT.  THIS IS STILL IN THE CODE, BUT IT IS TURNED OFF. TO
C        TURN IT ON, SET ALL OR SOME OF THE TRACE PARAMETERS  TR1,...,
C        TR10 TO .TRUE. . THEY ARE CURRENTLY DEFAULTED TO .FALSE.
C        THEY MAY BE CHANGED THROUGH THE ENTRY POINT BBLSET.
C
C     6. PERHAPS THE CHOICE OF LANGUAGE SHOULD BE JUSTIFIED. FIRST, I
C        THINK IT IS IMPERATIVE, IF FORTRAN IS TO BE CHOSEN, THAT THE
C        1977  DIALECT BE USED. THE JUSTIFICATION FOR THE USE OF THE
C        '77 STRUCTURED STATEMENTS IS NOW PART OF ALMOST ANY COMPUTING
C        SCIENCE CURRICULUM. THE CURRENT VERSION OF THE CODE HAS BEEN
C        STRUCTURED TO FACILITATE CONVERSION TO THE NEW STANDARD
C        (FORTRAN 88) CURRENTLY BEING PROPOSED BY ISO/IEC JCT1/SC22/WG5.
C
C     7. I DID NOT WRITE THIS CODE IN PASCAL, FIRST, BECAUSE PASCAL IS
C        STILL NOT AS UNIVERSAL AS FORTRAN, AND SECOND, BECAUSE OF A
C        NUMBER OF SERIOUS SHORTCOMINGS IN THE STANDARD LANGUAGE WHICH
C        ARE QUITE RELEVANT WHEN PROVIDING GENERAL PURPOSE SOFTWARE
C        (SEE GROGONO, PROGRAMMING IN PASCAL, ED. 1, SECTION 10.5).
C        PL/I WAS NEVER CONSIDERED, AND APL IS A NON-STARTER WHEN IT
C        COMES TO SOFTWARE SUCH AS THIS. ALGOL 68 WOULD HAVE BEEN
C        NICE BUT IT IS NOT WIDELY USED.  IN THE FUTURE EITHER
C        ADA OR THE NEXT FORTRAN STANDARD WOULD HAVE MADE BETTER
C        ALTERNATIVES BECAUSE OF THEIR FEATURES DESIGNED
C        SPECIFICALLY FOR SOFTWARE DEVELOPMENT.
C
C     8. THE CODE CONTAINS A NUMBER OF DECISION VARIABLES, I.E. THOSE
C        SET THROUGH BBLSET.  THESE HAVE A DEFINITE EFFECT ON THE
C        EXECUTION OF THE CODE AND WERE USED FOR THE EXPERIMENTAL
C        TESTING DOCUMENTED IN THE PAPER DESCRIBING THE ALGORITHM.
C        IT COULD BE SUGGESTED THAT THESE SHOULD BE REMOVED FOR A
C        PUBLICATION VERSION, AND TO SOME EXTENT I WOULD  AGREE WITH
C        THAT. HOWEVER, I HAVE NOT REMOVED THEM, AND I WOULD LIKE TO
C        GIVE THE FOLLOWING JUSTIFICATION:
C
C        (A) SINCE THE CODE REQUIRES O(MN) OPERATIONS FOR EACH
C        ITERATION, THE REMOVAL OF A FEW LOGICAL DECISIONS WOULD
C        HAVE A NEGLIGIBLE EFFECT ON THE EXECUTION SPEED.
C
C        (B) THE USER NEED NOT BE CONCERNED WITH ANY OF THE POSSIBLE
C        CHOICES, FOR DEFAULT VALUES ARE PROVIDED FOR ALL OF THEM.
C
C        (C) SOME PEOPLE MIGHT CHOOSE TO EXPERIMENT WITH THE CODE,
C        AND THAT WOULD BE GREATLY FACILITATED BY LEAVING IT AS IT IS.
C
C     9. WHERE THE EFFECT ON EXECUTION SPEED IS NOT LIKELY TO BE
C        SIGNIFICANT, I HAVE OFTEN OPTED FOR CODING IN A FASHION
C        WHICH GIVES THE GREATEST CLARITY TO THE CODE, RATHER THAN
C        SEEKING THE SLICKEST OR QUICKEST WAY. FOR EXAMPLE, THE USE
C        OF LOGICALS SUCH AS MAXPAS (IN BBLINS) COULD EASILY BE
C        ELIMINATED, BUT I THINK THE CODE AS IT IS IS PARTICULARLY
C        CLEAR.  ALSO NOTE THAT WITH AN OPTIMIZING COMPILER, WRITING
C        THE CODE AS IT IS SHOULD HAVE NO EFFECT AT ALL ON EXECUTION
C        SPEED. IN FACT, WITHIN LOOPS (SUCH AS DO 3200 IN BBUPDT)
C        I HAVE QUITE DELIBERATELY WRITTEN THEM WITH FULL AND RE-
C        PEATED SUBSCRIPT REFERENCES IN ORDER TO GIVE A GOOD OPTI-
C        MIZING COMPILER THE BEST OPPORTUNITY TO GENERATE EFFICIENT
C        CODE. FINALLY, NOTE THAT THE TRACE REFERRED TO ABOVE (IN 5)
C        WILL ALSO HAVE LITTLE EFFECT ON EXECUTION SPEED AS LONG
C        AS IT IS TURNED OFF.
C
C     10. THE ROUTINES ZZPRNT, ZZTERM AND ZZPRNT ARE NOT CENTRAL TO
C        THE MINIMIZATION PROCESS. THEY PERFORM CERTAIN USEFUL
C        AUXILIARY TASKS, AND HAVE CERTAIN FACILITIES WHICH SOME
C        USERS MAY WISH TO TAKE ADVANTAGE OF. THERE IS SOME PRICE
C        TO HAVING THESE SEPARATE ROUTINES, BUT IT IS AGAIN SMALL
C        COMPARED TO THE OVERALL COMPUTATION. THEY CAN EASILY BE
C        REMOVED IF THAT IS FELT TO BE ESSENTIAL.
C
C     11. COMMON WAS USED IN MANY PLACES IN AN EARLY VERSION OF
C        THIS ROUTINE IN ORDER TO AVOID UNNECESSARILY LONG CALLING
C        SEQUENCES. THERE ARE SOME WHO OBJECT TO THE USE OF COMMON,
C        AND THERE IS ONE INSTALLATION WHERE THE USE OF COMMON IS
C        (I HAVE BEEN TOLD) ESSENTIALLY FORBIDDEN, SO THE CURRENT
C        VERSION USES NO COMMON.  INSTEAD, ENTRY POINTS, WHICH ARE
C        PART OF THE STANDARD FOR FORTRAN 77, ARE USED TO AVOID THE
C        UNPLEASANTNESS OF LONG CALLS. NOTE THOUGH THAT THE CODE IS
C        STRUCTURED SO THAT IT CAN BE USED IN MOST INSTANCES WITHOUT
C        ANY NEED TO BE AWARE OF THIS FACT.
C
C---THE ENTRY POINT  B B L S E T :
C
C      ( METH, QUADIN, ALPIS1, SCGAMM,                 ...INTEGERS
C       HTEST, UPDATT,
C          RO,   BETA,                                 ...REALS
C       FQUAD, SCDIAG, SHANNO, FROMRS, FORCER,         ...LOGICALS
C         RELF,   RELG,
C         TRU, STRACE  )                               ...TRACES
C
C     THE FOLLOWING VARIABLES ARE PARAMETERS WHICH AFFECT EXECUTION OF
C     THE ALGORITHM.  THESE CONTROL PARAMETERS HAVE DEFAULT VALUES WHICH
C     CAN BE CHANGED BY CALLING THE ENTRY POINT BBLSET WITHIN THIS
C     ROUTINE BBLNIR.  THERE SHOULD NORMALLY BE NO NEED TO CHANGE
C     ANY OF THESE PARAMETERS, SINCE ALL HAVE DEFAULTS DEFINED IN
C     THE DATA SECTION BELOW. THESE ARE FOR EXPERIMENTAL PURPOSES.
C     THE VALUES IN ( ) ARE THE DEFAULT VALUES.
C
C ...INTEGERS
C
C     METH   = -3  USE THE ORDINARY CG ALGORITHM WITH M=0.
C     (0)    = -2  USE THE QN ALGORITHM. CHECK STORAGE IS SUFFICIENT.
C            = -1  USE THE CG ALGORITHM WITH AS MANY UPDATE TERMS AS ARE
C                  AVAILABLE, BUT AT MOST N.
C            =  0  USE THE QN ALGORITHM IF THERE IS ENOUGH STORAGE;
C                  OTHERWISE USE A CG ALGORITHM WITH AS MANY UPDATE
C                  TERMS AS ARE AVAILABLE. THIS IS THE ONLY CASE NEEDED;
C                  THE OTHER CASES ARE FOR EXPERIMENTAL PURPOSES.
C            >  0  USE THE CG ALGORITHM WITH THE NUMBER OF TERMS SPECI-
C                  FIED BY METH. IF THIS IS MORE THAN THE NUMBER AVAIL-
C                  ABLE, USE THE MAXIMUM POSSIBLE. MORE THAN N TERMS
C                  MAY BE USED.  IF METH IS SET TO BE >= 10000 ( SEE
C                  SPECQN ), THIS IS TREATED AS A SPECIAL CASE, AND
C                  CERTAIN SPECIAL STATEGIES ARE FOLLOWED.  THIS CASE
C                  IS JUST FOR EXPERIMENTAL PURPOSES.  SEE METH = -3 TO
C                  SPECIFY  NO UPDATES.
C
C     QUADIN  THIS DETERMINES IN WHAT CIRCUMSTANCES A QUADRATIC
C       (2)   INTERPOLATION MUST BE DONE BEFORE A LINE SEARCH CAN
C             BE DEEMED COMPLETE. THE FUNDAMENTAL IDEA IS THAT A
C             QUADRATIC INTERPOLATION MUST BE DONE ON LINE SEARCHES
C             IN CONJUGATE GRADIENT METHODS.
C
C           = 0  QUAD. INT. FORCED ON EVERY STEP.
C           = 1  QUAD. INT. FORCED ON D[M+1] AND LATER STEPS.
C           = 2  QUAD. INT. FORCED ON D[M+2] AND LATER STEPS.
C           = 3  QUAD. INT. FORCED ON D[M+3] AND LATER STEPS.
C           > 3  QUAD. INT. IS NEVER FORCED.
C
C     ALPIS1  THIS DETERMINES IN WHAT CIRCUMSTANCES A LINE SEARCH
C      (1)    IS BEGUN WITH THE STEP OF LENGTH 1, I.E. WITH ALPHA = 1,
C             WHICH IS NORMALLY THE STRATEGY FOR QUASI-NEWTON
C             METHODS.
C
C         = 0 ALPHA = 1 IS NEVER USED INITIALLY.
C         = 1 ALPHA = 1 USED ON STEPS BEFORE D[M+1] (NOT INCLUSIVE)
C         = 2 ALPHA = 1 USED ON STEPS BEFORE D[M+2] (NOT INCLUSIVE)
C         = 3 ALPHA = 1 USED ON STEPS BEFORE D[M+3] (NOT INCLUSIVE)
C         > 3 ALPHA = 1 IS INITIAL CHOICE ON ALL STEPS.
C
C     STSTEP 1  THEN IMPLEMENT THE SCALING OF THE CONJUGATE GRADIENT
C      (2)      DIRECTIONS, WHICH IS REFLECTED IN THE INITIAL
C               CHOICE OF ALPHA, USING THE FORMULA GIVEN BY
C               FLETCHER AND USED IN HIS VA08.
C            2  THEN USE THE FORMULA APPEARING IN CONMIN AND USED
C               BY POWELL IN VA14.
C
C     SCGAMM  THE SO-CALLED GAMMA SCALING OF OREN AND SPEDICATO,
C       (1)   WHICH IS DESCRIBED BY SHANNO, MAY BE USED AT EACH UPDATE
C             STEP. THIS CAN IN FACT BE DONE ONLY IF THE BFGS
C             UPDATE IS BEING USED, I.E. IF BETA = 1. NO EXTRA
C             STORAGE IS NEEDED TO IMPLEMENT THIS SCALING.
C
C         = 0 THEN DO NOT USE THIS SCALING
C         = 1 THEN USE THIS JUST ON THE FIRST QN UPDATE.
C         = 2 THEN USE THIS FOR ALL QN UPDATES.
C
C     HTEST = 0  THEN DO NOT USE ANY RESTART TEST.
C      (1)  = 1  JUST USE POWELL'S SIMPLE TEST (I.E. H = I )
C           = 2  USE THE RESTART TEST WHICH INVOLVES THE MATRIX
C                     H AS DESCRIBED IN THE PAPER.
C
C    UPDATT = 1  USE THE SUM FORM OF UPDATING.
C           = 2  USE NOCEDAL'S PRODUCT FORM.
C           = 3  USE POWELL'S FACTORED FORM.
C
C ...REALS
C
C     RO      THIS IS THE PARAMETER OF THE SAME NAME FROM THE PAPER
C     (.2)    WHICH CONTROLS THE RESTART TEST, I.E. IF
C             TAU[I] > RO, A RESTART WILL BE DONE.
C
C     BETA    THIS IS THE SCALAR PARAMETER FOR THE BROYDEN UPDATE
C     (1.0)   FAMILY. IT IS DEFAULTED TO 1, SO THAT THE BFGS
C             UPDATE FORMULA IS OBTAINED.
C
C ...LOGICALS
C
C     FQUAD  TRUE  THEN THE APPLICATION OF QUADIN, AS DESCRIBED ABOVE,
C      (F)         IS DECIDED BY MONITORING WHETHER THE PART OF THE
C                  CODE WHICH DOES THE ACTUAL INTERPOLATION HAS BEEN
C                  ENTERED OR NOT.
C            FALSE THEN THE STRATEGY USED BY SHANNO IN CONMIN IS
C                  FOLLOWED, I.E. ANY COMPUTATION OF A NEW ALPHA COUNTS,
C                  WHICH MAY INCLUDE A NON-INTERPOLATION STEP. THIS
C                  IS IMPLEMENTED BY SIMPLY CHECKING NCALLS, AND INCRE-
C                  MENTING NCALLS EACH TIME THE FUNCTION IS EVALUATED.
C
C     DIAGNL TRUE  H0 IS TAKEN TO BE A DIAGONAL MATRIX WHICH IS AVAIL-
C       (F)        ABLE IN THE FIRST  N LOCATIONS OF THE ARRAY  H.
C                  NOTE THAT THIS INCREASES THE STORAGE REQUIREMENT
C                  FOR  H  BY  N  LOCATIONS.
C            FALSE OTHERWISE, H0 = I, AND IT IS OF COURSE NOT STORED.
C
C     SHANNO TRUE  THEN, IN THE CASE WHEN THERE IS EXACTLY ONE UPDATE,
C       (F)     MAKE SURE THAT THE DETAILS OF IMPLEMENTATION ARE EXACT-
C               LY THE SAME AS IN THE CONJUGATE GRADIENT SECTION OF
C               SHANNO'S CONMIN. THIS WILL OVERRIDE CERTAIN SETTINGS
C               OF THE OTHER PARAMETERS. IN FACT, THE SAME RESULTS
C               SHOULD BE OBTAINED BY SETTING THE OTHER PARAMETERS
C               APPROPRIATELY.
C
C            FALSE THEN IMPLEMENT ACCORDING TO THE LOGIC DEFINED HERE.
C
C     FROMRS TRUE  THEN A RESTART IS FORCED AFTER  N  STEPS FROM THE
C       (F)        LAST RESTART POINT X[R] (WHICH IS X[1]).
C            FALSE THEN A RESTART IS NOT FORCED UNTIL  N  STEPS HAVE
C                  BEEN DONE FROM THE BEGINNING OF THE CG PART,
C                  I.E. FROM  X[M+1].
C
C     FORCEF TRUE  THEN A RESTART IS FORCED AT THE END OF A STEEPEST
C       (T)        DESCENT STEP, I.E. THE STEP ALONG D[1] FROM
C                  X[0] IS ALWAYS CONSIDERED A RESTART STEP.
C                  NOTE THAT WHEN M=0 THIS RESULTS IN THE
C                  STEEPEST DESCENT ALGORITHM.
C            FALSE THEN SUCH A RESTART IS NOT FORCED. INSTEAD, THE
C                  STEP FROM  X[0] IS JUST CONSIDERED PART OF A
C                  CONJUGATE GRADIENT SEQUENCE (WITH H = H[0], WHICH
C                  IS NORMALLY  I), AND A RESTART IS DONE ONLY
C                  WHEN FORCED BY  N  STEPS HAVING BEEN TAKEN WITH
C                  NO RESTART, OR BY THE RESTART TEST. THIS MAKES
C                  THE INITIAL CYCLE LIKE THE M=0 CASE. NOTE
C                  THAT WHEN M=0 THIS RESULTS IN AN ORDINARY CG
C                  ALGORITHM, BUT IMPLEMENTED AS IN [1].
C
C     RELF   TRUE  THESE TWO VALUES DETERMINE WHETHER TERMINATION
C     RELG   TRUE  TESTS ARE RELATIVE TO THE INITIAL FUNCTION AND
C                  GRADIENT VALUES OR NOT. SEE ZZTERM FOR MORE
C                  INFORMATION.
C
C ...TRACES
C
C     TRU      THIS IS THE UNIT TO RECEIVE TRACE OUTPUT.  IT IS
C     (6)      IGNORED UNLESS SOME TRACE FLAGS ARE ON.
C
C     STRACE   THIS SETS THE 15 TRACE FLAGS TR1,...,TR15 WHICH ARE
C              EXPLAINED BELOW.
C
C---ENTRY POINT BBVGET ( CNTRST, M, CNTFOR ) .
C
C     THIS ENTRY POINT IS PROVIDED AS A MEANS OF RETURNING CERTAIN
C     STATISTICS ON THE EXECUTION OF BBLNIR WHICH MAY BE OF INTEREST.
C     THE FOLLOWING VALUES ARE AVAILABLE.
C
C       CNTRST   A COUNT OF THE NUMBER OF RESTARTS WHICH TOOK PLACE.
C       M        THE NUMBER OF UPDATE TERMS ACTUALLY USED.
C       CNTFOR   COUNT THE NUMBER OF RESTARTS FORCED BY HTEST.
C
C---TRACE FLAGS.
C
C     TR1  ARGUMENTS ON INPUT
C     TR2  INFORMATION RE STEP TYPES, EG QN VS CG.
C     TR3  LINE SEARCH:  EACH ALPHA USED.
C     TR4                LOGICAL FLAGS.
C     TR5                INTERMEDIATE REAL VALUES.
C     TR6                LOGICAL FLOW.
C     TR7  RESTART AND UPDATE INFORMATION.
C     TR8  INTERMEDIATE VALUES IN BBMULT AND BBLNIR.
C     TR9  POINT X AND DIRECTION D AT START OF EACH ITERATION.
C          (THIS OVERRIDES TR10=FALSE)
C     TR10 INCLUDE VECTORS WITH OUTPUT WHERE APPROPRIATE
C     TR11 POINT IN CUBIC SEARCH
C     TR12 CURRENTLY UNUSED.
C     TR13 CURRENTLY UNUSED.
C     TR14 CURRENTLY UNUSED.
C     TR15 CURRENTLY UNUSED.
C
C---SOME OF THE MORE IMPORTANT VARIABLES:
C
C     CT     COUNT ITERATIONS FROM THE LAST RESTART; THE RESTART
C              POINT IS COUNTED AS NUMBER 1.
C     LMSTQN A SPECIAL TEST CASE: CG METHOD WITH > N UPDATES, SO
C              VIRTUALLY QN METHOD. SOME SPECIAL CONSIDERATIONS.
C              IT IS SET TO TRUE IF METH >= 10000 ON ENTRY.
C     RSTEP  IF TRUE, THIS IS THE RESTART STEP; AT THE END OF THIS
C              STEP WE GET THE RESTART POINT X[R]. THIS WILL FORCE
C              A RESTART AND RETURN THE CODE TO THE "QN" PART.
C     LASTPT THE LAST POINT WHICH CAN BE REACHED BEFORE A RESTART
C              MUST BE FORCED BECAUSE OF THE NUMBER OF STEPS TAKEN.
C     STEEPD IF TRUE, THIS STEP IS IN A STEEPEST DESCENT DIRECTION.
C              THIS HAPPENS ONLY INITIALLY, OR IN THE CASE OF
C              NUMERICAL DIFFICULTIES OR WHEN M=0.
C     QNPART IF TRUE, THIS STEP IS IN THE QN PART OF THE ALGORITHM.
C              THUS QNPART IS TRUE FROM X[1] TO X[M+1].
C     CNTRST COUNT THE RESTARTS (FOR INFORMATION ONLY).
C     M      THIS IS THE MAXIMUM NUMBER OF UPDATE TERMS ALLOWED.
C     NCALLS THIS IS THE NUMBER OF FUNCTIONS EVALUATIONS DONE DURING
C              EACH LINE SEARCH.
C     NUPS   THIS COUNTS THE NUMBER OF QN UPDATES CURRENTLY STORED.
C     ONEUPD THIS IS TRUE IF M = 1.
C     ALPHA  THE LINE SEARCH STEP LENGTH.
C
C## E N T R Y   P O I N T S:
C
C     BBLNIR   ... THE NATURAL ENTRY POINT.
C     BBLSET   ... AN ENTRY TO ALTER CONTROL PARAMETERS.
C     BBVGET   ... AN ENTRY TO GET RESTART COUNTS.
C     BBLFDF   ... AN ENTRY TO REDEFINE THE EVALUATION CODES FOR ZZEVAL.
C     BBLIDF   ... AN ENTRY TO REDEFINE THE ENTRY STATUS CODES.
C     BBLRDF   ... AN ENTRY TO REDEFINE THE RETURN CODES FROM ZZEVAL.
C     BBLSDF   ... AN ENTRY TO REDEFINE EXIT STATUS CODES.
C
C## S U B R O U T I N E S:
C
C     ABS, MAX, MIN, ACOS        INTRINSIC FUNCTIONS.
C     FUNCNM, INNER   EXTERNAL PROCEDURES PASSED AS ARGUMENTS.
C
C     HERE, A NAME IN [..] IS AN ENTRY POINT IN THE GIVEN ROUTINE.
C
C     BBINIH           INITIAL DIAGONAL MATRIX
C     BBCUBC [BBSCUB]  CUBIC INTERPOLATION
C     BBLINS [BBSLNS]  LINE SEARCH LOOP
C     BBMULT [BBSMLT]  MATRIX VECTOR MULTIPLICATION WITH SUMS
C     BBNOCE [BBSNOC]  MATRIX VECTOR MULTIPLICATION WITH PRODUCTS
C     BBUPDT [BBSUPD]  UPDATE H
C
C     ZZEVAL,ZZPRNT,ZZTERM OPTIONAL, AS EXPLAINED IN "IMPLEMENTATION
C                            NOTES" ABOVE.
C
C     ZZMPAR               RETURNS MACHINE PRECISION.
C     ZZINNR, ZZNRM2       INNER PRODUCT, 2-NORM OF VECTOR(S)
C     ZZSECS (INDIRECT)    USED IN ZZEVAL AND ZZPRNT.
C
C## P A R A M E T E R S:

      INTEGER      SPECQN
      PARAMETER  ( SPECQN = 10000 )


      LOGICAL     DONORM,          NONORM
      PARAMETER ( DONORM = .TRUE., NONORM = .FALSE. )

      INTEGER     JUSTF,     BOTH,     JUSTG,      NOOP
      PARAMETER ( JUSTF = 1, BOTH = 0, JUSTG = -1, NOOP = 2 )

      LOGICAL     T,          F
      PARAMETER ( T = .TRUE., F = .FALSE. )

      CHARACTER*(*) TRUE,          QT,       FALSE,           QF
      PARAMETER (   TRUE = 'TRUE', QT = 'T', FALSE = 'FALSE', QF = 'F' )

      INTEGER     ITRUE,     IFALSE
      PARAMETER ( ITRUE = 1, IFALSE = 0 )

      REAL              RTRUE,        RFALSE
C!!!! DOUBLE PRECISION  RTRUE,        RFALSE
      PARAMETER      (  RTRUE = 1.D0, RFALSE = 0.D0 )

      INTEGER     GAMOFF,     GAMONE,     GAMALL
      PARAMETER ( GAMOFF = 0, GAMONE = 1, GAMALL = 2 )

      INTEGER     XEPS,     XSMALL,     XBIG
      PARAMETER ( XEPS = 1, XSMALL = 2, XBIG = 3 )
      REAL              ZERO,       ONE,       TWO,       THREE
C!!!! DOUBLE PRECISION  ZERO,       ONE,       TWO,       THREE
      PARAMETER (       ZERO = 0D0, ONE = 1D0, TWO = 2D0, THREE = 3D0)

      REAL              FOUR,       FIVE,      SIX,       SEVEN
C!!!! DOUBLE PRECISION  FOUR,       FIVE,      SIX,       SEVEN
      PARAMETER (       FOUR = 4D0, FIVE = 5D0,SIX = 6D0, SEVEN = 7D0)

      REAL              EIGHT,         NINE,          TEN
C!!!! DOUBLE PRECISION  EIGHT,         NINE,          TEN
      PARAMETER (       EIGHT = 8D0,   NINE = 9D0,    TEN = 10D0     )

      REAL              TENTH,         FIFTH,        HALF
C!!!! DOUBLE PRECISION  TENTH,         FIFTH,        HALF
      PARAMETER (       TENTH = .1D0,  FIFTH = .2D0, HALF = .5D0      )

      REAL              RPT9,        RPT8,        RD29
C!!!! DOUBLE PRECISION  RPT9,        RPT8,        RD29
      PARAMETER (       RPT9 = .9D0, RPT8 = .8D0, RD29 = 1D0/29D0 )
      REAL              R11,        R12,        R13,       R14
C!!!! DOUBLE PRECISION  R11,        R12,        R13,       R14
      PARAMETER (       R11 = 11D0, R12 = 12D0, R13 = 13D0,R14 = 14D0)

      REAL              R15,        R16,        R17,       R18
C!!!! DOUBLE PRECISION  R15,        R16,        R17,       R18
      PARAMETER (       R15 = 15D0, R16 = 16D0, R17 = 17D0,R18 = 18D0)

      REAL              R19,        R20,        R25,       R29
C!!!! DOUBLE PRECISION  R19,        R20,        R25,       R29
      PARAMETER (       R19 = 19D0, R20 = 20D0, R25 = 25D0,R29 = 29D0)

      REAL              R32,        R36,        R40,       R42
C!!!! DOUBLE PRECISION  R32,        R36,        R40,       R42
      PARAMETER (       R32 = 32D0, R36 = 36D0, R40 = 40D0,R42 = 42D0)

      REAL              R45,        R49
C!!!! DOUBLE PRECISION  R45,        R49
      PARAMETER (       R45 = 45D0, R49 = 49D0 )

      REAL              R50,        R56,        R84,       R90
C!!!! DOUBLE PRECISION  R50,        R56,        R84,       R90
      PARAMETER (       R50 = 50D0, R56 = 56D0, R84 = 84D0,R90 = 90D0)

      REAL              R100,            R180,           R200
C!!!! DOUBLE PRECISION  R100,            R180,           R200
      PARAMETER (       R100 = 100D0,    R180 = 180D0,   R200 = 200D0 )

      REAL              R256,            R360,           R400
C!!!! DOUBLE PRECISION  R256,            R360,           R400
      PARAMETER (       R256 = 256D0,    R360 = 360D0,   R400 = 400D0 )

      REAL              R600,            R681,           R991
C!!!! DOUBLE PRECISION  R600,            R681,           R991
      PARAMETER (       R600 = 600D0,    R681 = 681D0,   R991 = 991D0 )

      REAL              R1162,                 R2324
C!!!! DOUBLE PRECISION  R1162,                 R2324
      PARAMETER (       R1162 = 1162D0,        R2324 = 2324D0         )

      REAL              R10000,                R40000
C!!!! DOUBLE PRECISION  R10000,                R40000
      PARAMETER (       R10000 = 10000D0,      R40000 = 40000D0       )
C   THE RETURN CODES TO BE USED BY THE FUNCTION EVALUATION ROUTINE
C   TO INDICATE TO THE MINIMIZATION ROUTINE WHETHER OR NOT THE CALL
C   WAS SUCCESSFUL.

      INTEGER     COK,     CABORT,      CLIMIT
      PARAMETER ( COK = 0, CABORT = -1, CLIMIT = -2 )

      INTEGER     CNOF,      CNOG,      CNOFG
      PARAMETER ( CNOF = -3, CNOG = -4, CNOFG = -5 )

C--ON ENTRY:
      INTEGER     CNORML,     CRCSTR,     CRCRPT,     CRCNFG
      PARAMETER ( CNORML = 0, CRCSTR = 1, CRCRPT = 2, CRCNFG = 3 )

      INTEGER     CNRMFG,      CPSTHR
      PARAMETER ( CNRMFG = -1, CPSTHR = -2 )

C--ON EXIT:
      INTEGER     CDONE,     CRCF,     CRCFG,     CRCG
      PARAMETER ( CDONE = 0, CRCF = 1, CRCFG = 2, CRCG = 3 )

      INTEGER     CNSTOR,      CIPMIN,      CIPUNF,      CBDMTH
      PARAMETER ( CNSTOR = -1, CIPMIN = -2, CIPUNF = -3, CBDMTH = -4 )

      INTEGER     CLSFAL,      CNODSC,      CXSFNC,      CPSBCK
      PARAMETER ( CLSFAL = -5, CNODSC = -6, CXSFNC = -7, CPSBCK = -8  )

      INTEGER     CRABRT,      CUSERV
      PARAMETER ( CRABRT = -9, CUSERV = -10 )

      INTEGER     FLETCH,     SHNPOW
      PARAMETER ( FLETCH = 1, SHNPOW = 2 )

      INTEGER     BRZBR1,     BRZBR2,     BRZBR3,     BRZBR4
      PARAMETER ( BRZBR1 = 3, BRZBR2 = 4, BRZBR3 = 5, BRZBR4 = 6 )

       INTEGER     SUMFRM,     PRDFRM,     MJDFRM
       PARAMETER ( SUMFRM = 1, PRDFRM = 2, MJDFRM = 3 )

      LOGICAL      CMPALL
      PARAMETER  ( CMPALL = T )

      REAL             NERLY1
C!!!! DOUBLE PRECISION NERLY1
      PARAMETER (      NERLY1 = RPT9 )

C## L O C A L   D E C L:

C-----CONTROL PARAMETERS FOR ENTRY POINT BBLSET.

      INTEGER   METH, QUADIN, ALPIS1, SCGAMM,    TRU,  HTEST, UPDATT
      INTEGER  SMETH,  SQUAD, SALPH1, SSGAMM, STRACU, SHTEST, SUPDAT
      INTEGER STSTEP
      INTEGER SSTSTP

      REAL             RO, BETA, SRO, SBETA
C!!!! DOUBLE PRECISION RO, BETA, SRO, SBETA

      LOGICAL   FQUAD, DIAGNL, SHANNO, FORCEF, FROMRS
      LOGICAL  SFQUAD,  SDIAG, SSHANN, SFORCE, SFROMR
      LOGICAL    RELF,  SRELF,   RELG,  SRELG

      LOGICAL       TR1,  TR2,   TR3,  TR4,  TR5, TR6, TR7, TR8, TR9
      LOGICAL TR10, TR11, TR12, TR13, TR14, TR15
      LOGICAL STRACE(15), ANYTR

C-----CONTROLS FOR ENTRY POINTS BBLDDF, BBLIDF, BBLFDF, BBLRDF, BBLSDF.

      INTEGER SANAL, SDIFF, STEST, SFIRST

      INTEGER SDOF, SDOG, SDOFG, SNONE, DOF, DOG, DOFG, NONE

      INTEGER SNRMFG, SNORML, SRCSTR, SRCRPT, SRCNFG, SPSTHR
      INTEGER NORMFG, NORMAL, RCSTRT,  RCRPT, RCNOFG, PSTHRU

      INTEGER SDONE,  SRCF,   SRCFG,    SRCG, SNSTOR, SIPMIN, SPSBCK
      INTEGER DONE,   RCF,    RCFG,     RCG,  NOSTOR, IPMIN,  PSBACK
      INTEGER SIPUNF, SBDMTH, SLSFAL, SNODSC, SXSFNC, SRABRT, SUSERV
      INTEGER IPUNDF, BDMETH, LSFAIL, NODESC, XSFUNC, RABORT, USERV

      INTEGER SOK, SABORT, SLIMIT, SNOF, SNOG, SNOFG
      INTEGER  OK,  ABORT,  LIMIT,  NOF,  NOG,  NOFG

C-----GENERAL DECLARATIONS.

      INTEGER  BASE, CT, INCR, INSTAT, CASE, OTSTAT
      INTEGER  I, J, K, KJ, LASTPT, NCALLS, NUPS, STORAG

      LOGICAL STEEPD,   LESS, QNPART,  SCDIAG,  RSTEP, ONEUPD, IDENTY
      LOGICAL LMSTQN, LSDONE,     CG,  QNSTEP, TOOSML, FRSTRM, BAD
      LOGICAL FORCER, USESHN, FORCE1,   NOUPS,   COLD, QUADON, FIRST
      LOGICAL VALIDF,   TESTR, NOPRNT

      REAL             FP, FMIN, ALPHA, AP, DGLAST, DG0, ZZMPAR, ANGLE
C!!!! DOUBLE PRECISION FP, FMIN, ALPHA, AP, DGLAST, DG0, ZZMPAR, ANGLE
      REAL             DGP, DGAL, NRMD, NRMG, FLAST, EPS, ETA
C!!!! DOUBLE PRECISION DGP, DGAL, NRMD, NRMG, FLAST, EPS, ETA
      REAL             TP0, TP1, TP2, NRMX, ACOS, PI, RADS, WIDTH, DUMMY
C!!!! DOUBLE PRECISION TP0, TP1, TP2, NRMX, ACOS, PI, RADS, WIDTH, DUMMY
      REAL             STG, UTG, NU, SIGMA, GAMMA, MU
C!!!! DOUBLE PRECISION STG, UTG, NU, SIGMA, GAMMA, MU

C-----DECLARATIONS FOR COUNTS AT ENTRY POINT.

      INTEGER  M, CNTRST, MUPS, NRESTR, CNTFOR, NFORCE

C## S A V E:
C          ALL VARIABLES MUST BE SAVED DUE TO THE POSSIBLE USE OF
C          REVERSE COMMUNICATION.
      SAVE

C## C O M M O N:             NONE IS DEFINED.
C## D A T A:                 NONE ARE SET.

      DATA  METH   /0/, QUADIN /2/, ALPIS1 /2/, SCGAMM /1/, HTEST /1/
      DATA  UPDATT /1/, STSTEP /2/

      DATA  RO/ 0.2D0 /, BETA / 1.0D0 /

      DATA  FQUAD /F/, DIAGNL/F/, SHANNO/F/, FROMRS/F/, FORCEF/T/
      DATA  RELF  /T/, RELG  /T/

      DATA  TRU  /6/

      DATA  DOF/JUSTF/, DOG/JUSTG/, DOFG/BOTH/, NONE/NOOP/

      DATA  NORMFG/CNRMFG/, NORMAL/CNORML/, RCSTRT/CRCSTR/,
     -      RCRPT /CRCRPT/, RCNOFG/CRCNFG/, PSTHRU/CPSTHR/

      DATA  DONE  /CDONE/,  RCF   /CRCF/,   RCFG  /CRCFG/,  RCG/CRCG/
     -      NOSTOR/CNSTOR/, IPMIN /CIPMIN/, IPUNDF/CIPUNF/,
     -      BDMETH/CBDMTH/, LSFAIL/CLSFAL/, NODESC/CNODSC/,
     -      RABORT/CRABRT/, XSFUNC/CXSFNC/, USERV /CUSERV/,
     -      PSBACK/CPSBCK/

      DATA   OK/ COK/, ABORT/CABORT/, LIMIT/CLIMIT/
      DATA  NOF/CNOF/,  NOFG/CNOFG/,    NOG/CNOG/

      DATA   FIRST/T/
C##                                                E X E C U T I O N
C##                                                E X E C U T I O N
C-----DEFINE TWO STATEMENT FUNCTIONS.

      BAD() = CASE .EQ. ABORT .OR. CASE .EQ. LIMIT .OR. CASE .EQ. NOF
     -   .OR. CASE .EQ.  NOFG .OR. CASE .EQ.  NOG

      ANGLE(DUMMY) = RADS*ACOS(DUMMY)

C--------------------------------------

      OK     = DONE
      INSTAT = STATUS

      IF ( INSTAT .EQ. PSTHRU ) THEN
         CASE = NONE
         CALL ZZEVAL (FUNCNM, N, X, FX, G, CASE, IW, RW, DW )
         IF ( BAD() ) THEN
            OTSTAT = RABORT
         ELSE
            OTSTAT = PSBACK
         ENDIF
         NOPRNT = T
         GOTO 90000
      ENDIF

C>>>>>>>>>> P H A S E  0:  DESCRIBE PHASES.<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

C  THE CODE IS IN "PHASES".  THE FLOW IS FORWARD TO THE END IN EACH
C     PHASE. ALL PHASES ARE EXITED ONLY AT THE END OF THE PHASE AND
C     FLOW PROCEEDS TO THE START OF ANOTHER PHASE, OR IT EXITS  THE
C     ALGORITHM TO STATEMENT  90000.
C
C  THERE IS ONE EXCEPTION, A JUMP TO 92000 AND A RETURN IN PHASE VII
C     IF REVERSE COMMUNICATION IS BEING USED, ALONG WITH A REENTRY
C     FROM THE TOP OF PHASE I BACK TO CONTINUE FROM THE POINT OF EXIT
C     AT 2150.

C>>>>>>>>>> P H A S E  I:  INITIAL SET UP.<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

      IF ( ANYTR ) THEN
         WRITE ( TRU, * ) 'TRACE FLAGS', TR1,TR2,TR3,TR4,TR5,TR6,TR7,
     -                           TR8,TR9,TR10,TR11,TR12,TR13,TR14,TR15
      ENDIF

      IF ( FIRST ) THEN
         PI    = ACOS(-ONE)
         RADS  = R180/PI
         FIRST = F
      ENDIF

      NOPRNT = F

      IF ( INSTAT .EQ. RCRPT .OR. INSTAT .EQ. RCNOFG ) THEN

C        THIS IS A SUPPLEMENTARY CALL WITH REVERSE COMMUNICATION.

         OTSTAT = OK
         VALIDF = INSTAT .EQ. RCRPT
         GOTO 2150

      ENDIF

C     CHECK ALL PARAMETER SETTINGS VALID.

      OTSTAT = OK
      IF ( INSTAT .NE. NORMFG .AND. INSTAT .NE. NORMAL .AND.
     -     INSTAT .NE. RCSTRT                              ) THEN
         OTSTAT = 1 + OK
      ELSE IF ( N .LE. 1 ) THEN
         OTSTAT = 2 + OK
      ELSE IF ( ACC .LE. ZERO ) THEN
         OTSTAT = 3 + OK
      ELSE IF ( TRU .LE. 0 ) THEN
         OTSTAT = 4 + OK
      ELSE IF ( QUADIN .LT. 0 ) THEN
         OTSTAT = 5 + OK
      ELSE IF ( ALPIS1 .LT. 0 ) THEN
         OTSTAT = 6 + OK
      ELSE IF ( STSTEP .NE. 1 .AND. STSTEP .NE. 2 ) THEN
         OTSTAT = 7 + OK
      ELSE IF ( SCGAMM .LT. 0 .OR. SCGAMM .GT. 2 ) THEN
         OTSTAT = 8 + OK
      ELSE IF ( HTEST .LT. 0 .OR. HTEST .GT. 2 ) THEN
         OTSTAT = 9 + OK
      ELSE IF ( UPDATT .LT. 1 .OR. UPDATT .GT. 3 ) THEN
         OTSTAT = 10 + OK
      ENDIF

      IF ( OTSTAT .NE. OK ) THEN
         XX(1)  = OTSTAT - OK
         OTSTAT = USERV
         NOPRNT = T
         GOTO 90000
      ENDIF

C     INITIALIZE STATUS, CNTRST, ETC.

      CNTRST  = 0
      NFORCE  = 0
      SCDIAG  = DIAGNL
      EPS     = FIVE * ZZMPAR(XEPS)

C     ALLOW FOR DIAGONAL SCALING MATRIX H0.

      IF ( SCDIAG ) THEN
         BASE = N
      ELSE
         BASE = 0
      ENDIF

C     DETERMINE THE NUMBER OF UPDATES WHICH CAN BE STORED AND
C     DETERMINE STORAGE REQUIREMENTS. CHOOSE THE METHOD.

      LMSTQN = F
      STORAG = ( N*(N+1) ) / 2

      IF ( UPDATT .EQ. SUMFRM ) THEN
         INCR = 2*N + 2
      ELSE IF ( UPDATT .EQ. PRDFRM ) THEN
         INCR = 2*N + 1
      ELSE IF ( UPDATT .EQ. MJDFRM ) THEN
         INCR = 4*N + 1
         BASE = BASE + 2*N
      ENDIF

      M  = (HDIM - BASE) / INCR

      IF ( METH .EQ.  0 ) THEN
         IF ( HDIM .GE. STORAG ) THEN
            CG  = F
            M   = -1
         ELSE
            CG  = T
            M   = MIN ( M, N )
         ENDIF
      ELSE IF ( METH .EQ. -3 ) THEN
         CG = T
         M  = 0
      ELSE IF ( METH .EQ. -2 ) THEN
         CG = F
         M   = -1
         IF ( HDIM .LT. STORAG ) THEN
            NOPRNT = T
            OTSTAT = NOSTOR
         ENDIF
      ELSE IF ( METH .EQ. -1 ) THEN
         CG = T
         M  = MIN ( M, N )
      ELSE IF ( METH .GT.  0 ) THEN
         CG = T
         M  = MIN ( M, METH )
         IF ( METH .GE. SPECQN ) LMSTQN = T
      ELSE
         NOPRNT = T
         OTSTAT = BDMETH
         M   = -1
      ENDIF

      IF ( CG ) THEN
         NOUPS  = M .EQ. 0
         ONEUPD = M .EQ. 1
         USESHN = SHANNO .AND. ONEUPD .AND. UPDATT .EQ. SUMFRM
      ELSE
         ONEUPD = F
         USESHN = T
      ENDIF

      IF ( HDIM .LT. BASE ) THEN
         NOPRNT = T
         OTSTAT = NOSTOR
      ENDIF

C     INITIALIZE  FIXED ARGUMENTS INTO SUBROUTINES.

      CALL BBSLNS (  M, QUADIN, TRU, CG, USESHN, LMSTQN, FQUAD,
     -             TR4, TR5,    TR6, ACC                      )
C
      CALL BBSMLT ( TR8, TR10, SCDIAG, SCGAMM, TRU, BASE, INCR, BETA )
      CALL BBSNOC ( TR8, TR10, SCDIAG, SCGAMM, TRU, BASE, INCR       )
      CALL BBSCUB ( TR11, TRU )
      CALL BBSMJD ( TR8, TR10, TRU)

      CALL BBSUPD (  M,   BASE,   INCR, SCGAMM,
     -              CG, SCDIAG, USESHN, FROMRS, TR7, TR2, TR10, TRU)

      IF ( OTSTAT .EQ. OK .AND. INSTAT .EQ. NORMAL ) THEN

C        GET INITIAL FUNCTION VALUE (UNLESS REVERSE COMMUNICATION).

         CASE = DOFG
         CALL ZZEVAL (FUNCNM, N, X, FX, G, CASE, IW, RW, DW )
         IF ( BAD() ) THEN
            IF      ( CASE .EQ. LIMIT ) THEN
               OTSTAT = XSFUNC
            ELSE IF ( CASE .EQ. ABORT ) THEN
               OTSTAT = RABORT
            ELSE
               NOPRNT = T
               OTSTAT = IPUNDF
            ENDIF
         ENDIF

      ENDIF

      IF ( OTSTAT .EQ. OK ) THEN

         NRMG = INNER ( N, G, G, DONORM, IW, RW, DW )

         IF (TR8 .AND. .NOT. TR1)
     -                   WRITE (TRU,*) ' [LNIR] NORM OF G->', NRMG

C        INITIALIZE THE TERMINATION TESTS.

         IF ( RELF ) THEN
            FP = FX
         ELSE
            FP = ONE
         ENDIF

         IF ( RELG) THEN
            DGP = NRMG
         ELSE
            DGP = ONE
         ENDIF

         CALL ZZTINT ( FP, DGP )

         IF ( TR1 ) THEN
            WRITE (TRU,99999)  N, HDIM, ACC, INSTAT
            IF      ( DECRF .EQ. ZERO ) THEN
               WRITE (TRU,99997)  FX
            ELSE IF ( DECRF .LT. ZERO ) THEN
               WRITE (TRU,99996)  DECRF
            ELSE
               WRITE (TRU,99995)  DECRF
            ENDIF
            WRITE (TRU,99994)
     -           METH, QUADIN, ALPIS1,STSTEP,SCGAMM,HTEST,UPDATT,
     -           RO,BETA,
     -           FQUAD, SCDIAG, SHANNO,FROMRS, FORCEF,RELF,RELG,
     -           LMSTQN, CG, USESHN, ONEUPD,
     -           EPS,FP,DGP
            IF ( CG ) THEN
               WRITE (TRU,99992) M
            ELSE
               WRITE (TRU,99993) STORAG
            ENDIF

            IF ( INSTAT .EQ. RCSTRT .OR. INSTAT .EQ. NORMFG )
     -               WRITE(TRU,99998)  FX, NRMG
         ENDIF

C        TEST IF THE INITIAL POINT IS THE MINIMIZER.

         FRSTRM = T

         CALL ZZTERM ( FRSTRM, N, FX, G, X, X, ACC, LESS )

         IF ( LESS ) OTSTAT = IPMIN

      ENDIF

      IF ( OTSTAT .NE. OK ) THEN
         GOTO 90000
      ENDIF

C>>>>>>>>>> P H A S E  II:  "COLD START" WITH STEEPEST DESCENT.<<<<<<<<<

C     CALCULATE THE INITIAL SEARCH DIRECTION. DG0 IS THE CURRENT
C     DIRECTIONAL DERIVATIVE OF F ALONG D, WHILE NRMG IS THE NORM OF G.
C
C     INITIALIZE CT, WHICH IS USED TO DETERMINE WHETHER A BEALE
C     RESTART SHOULD BE DONE. I.E. A RESTART MUST BE FORCED AFTER
C     N STEPS WITHOUT ONE (EXCEPT IN THE SPECIAL CASE "LMSTQN"). INIT-
C     IALIZE STEEPD, WHICH INDICATES THAT THE CURRENT SEARCH DIRECTION
C     IS A NEGATIVE GRADIENT DIRECTION. THE CURRENT POINT IS X[0].

   20 STEEPD = T
      COLD   = T
      CT     = 0

      IF ( CG ) THEN
         LASTPT = N
         NUPS   = 0
         QNPART = F
      ENDIF

      CALL ZZPRNT ( N, X, FX, G, NRMG, 1 )

      CALL BBINIH  ( N, X, G, H, NRMG, IDENTY, SCDIAG, UPDATT,
     -                                 INNER, IW, RW, DW )

C     GET INITIAL SEARCH DIRECTION.

      IF ( .NOT. CG ) THEN
         CALL ZZCOPY ( N, G, 1, D, 1 )
      ELSE IF ( UPDATT .EQ. SUMFRM ) THEN
         CALL BBMULT(H, G, D, N, NUPS, T, IDENTY, INNER, IW, RW, DW )
      ELSE IF ( UPDATT .EQ. PRDFRM ) THEN
         CALL BBNOCE( H, G, D, N, CT, M, IDENTY, GG, INNER,IW,RW,DW)
      ELSE IF ( UPDATT .EQ. MJDFRM ) THEN
         CALL BBPOWL(H, G, D, N, NUPS, M, IDENTY, SCDIAG,INNER,IW,RW,DW)
      ENDIF
      CALL ZZSCAL ( N, -ONE, D, 1 )

      NRMD = INNER ( N, D, D, DONORM, IW, RW, DW )
      DG0  = INNER ( N, D, G, NONORM, IW, RW, DW )

C>>>>>>>>>> P H A S E  III: START ITERATION ALONG D[CT].<<<<<<<<<<<<<<<<

C     BEGIN THE MAJOR ITERATION LOOP. NCALLS IS USED TO GUARANTEE THAT
C     AT LEAST TWO POINTS HAVE BEEN TRIED WHEN METH=CG (SEE FQUAD).
C     FMIN IS THE CURRENT FUNCTION VALUE. FORCE A RESTART AFTER
C     N STEPS. OUTPUT (IF DESIRED) AT START OF EACH ITERATION.

 1600 FMIN   = FX
      NCALLS = 0
      NRMX   = MAX ( ONE, REAL(INNER (N,X,X,DONORM,IW,RW,DW)) )
C!!!! NRMX   = MAX ( ONE,      INNER (N,X,X,DONORM,IW,RW,DW)  )
      QUADON = F

      IF ( TR8 ) WRITE (TRU,*) ' [LNIR] NORM OF X->', NRMX
      IF ( TR9 ) WRITE (TRU,*) ' [LNIR] X->',X
      IF ( TR8 ) WRITE (TRU,*) ' [LNIR] NORM OF D->', NRMD
      IF ( TR9 ) WRITE (TRU,*) ' [LNIR] D->',D

C     SET CT TO THE INDEX OF THE POINT TO WHICH THE SEARCH WILL LEAD.
C             = THE INDEX OF THE CURRENT SEARCH DIRECTION.

      CT = CT + 1

C>>>>>>>>>> P H A S E  IV: INITIALIZE ALPHA FOR LINE SEARCH.<<<<<<<<<<<<

      LSDONE = F
      IF ( TR4 ) WRITE(TRU,*) ' [LNIR] START LS->'
      IF ( TR4 ) WRITE(TRU,*) ' CT,QNPART,LMSTQN,STEEPD,COLD,USESHN->',
     -                          CT,QNPART,LMSTQN,STEEPD,COLD,USESHN

      IF ( TR5 ) THEN
         IF ( ABS(DG0) .LE. NRMG*NRMD ) THEN
            WRITE(TRU,*) ' [LNIR] ANGLE OF D TO -G->',
     -                   ANGLE(-DG0/(NRMG*NRMD)) ,' DEGREES'
         ELSE
            WRITE(TRU,*) ' [LNIR] WARNING...ON ANGLE OF D TO -G'//
     -                   ' WE HAVE DG0 > NRMG*NRMD ->', DG0,NRMG*NRMD
         ENDIF
      ENDIF

      IF  ( COLD  ) THEN

         IF ( TR6 ) WRITE(TRU,*) ' [LNIR] FIRST CASE ALPHA.'

C        --FIRST ITERATION. SCALE STEP TO ONE. USE ESTIMATE DECRF.

         IF      ( DECRF .EQ. ZERO ) THEN
            TP1 = TWO * ABS(FX) / NRMG
         ELSE IF ( DECRF .GT. ZERO ) THEN
            TP1 = TWO * DECRF  / NRMG
         ELSE
            TP1 = ONE
         ENDIF

         IF ( CG .AND. SCDIAG ) THEN
            ALPHA = TP1
         ELSE
            ALPHA = TP1 / NRMG
         ENDIF

      ELSE IF ( CG ) THEN

         IF ( USESHN ) THEN

            IF ( CT .EQ. M+1 ) THEN
               IF ( TR6 ) WRITE(TRU,*) ' [LNIR] ALPHA IS ONE.'
               ALPHA = ONE
            ELSE
               IF ( TR6 ) WRITE(TRU,*) ' [LNIR] SHANNO SCALE ALPHA.'
               ALPHA = ALPHA * ( DGLAST / DG0 )
            ENDIF

         ELSE

            QNSTEP =          .NOT. NOUPS
     -               .AND. ( ALPIS1 .GT. 0          )
     -               .AND. (  CT    .LT. M + ALPIS1 )

            FORCE1 = LMSTQN .OR. QNSTEP .OR. ( ALPIS1 .GT. 3 )

            IF ( FORCE1 ) THEN

               IF ( TR6 ) WRITE(TRU,*) ' [LNIR] FORCE ALPHA TO 1.'

               ALPHA = ONE

            ELSE

               IF      ( STSTEP .EQ. FLETCH ) THEN
                  IF (TR6) WRITE(TRU,*) ' [LNIR] FLETCHER SCALE ALPHA.'
                  ALPHA = ALPHA * TWO * (FX - FLAST) / (DG0)
               ELSE IF ( STSTEP .EQ. SHNPOW ) THEN
                  IF (TR6)WRITE(TRU,*) ' [LNIR] SH./POW. SCALE ALPHA'
                  ALPHA = ALPHA * (DGLAST / DG0)
               ENDIF

            ENDIF
         ENDIF

      ELSE

C        THIS IS THE QN CASE.
         ALPHA = ONE

      ENDIF
      IF (TR6)WRITE(TRU,*) ' [LNIR] END OF PHASE IV, ALPHA = ',ALPHA

C>>>>>>>>>> P H A S E  V: INITIALIZE LINE SEARCH.<<<<<<<<<<<<<<<<<<<<<<<

C     THE LINE SEARCH FITS A CUBIC TO FX AND DGAL, THE FUNCTION AND ITS
C     DERIVATIVE AT ALPHA, AND TO FP AND DGP, THE FUNCTION AND ITS DERI-
C     VATIVE AT THE PREVIOUS TRIAL POINT AP, WHERE THE DERIVATIVES ARE
C     ALONG D.  INITIALIZE AP, FP AND DGP.

      AP  = ZERO
      FP  = FMIN
      DGP = DG0

C     SAVE THE CURRENT DERIVATIVE ALONG D AND THE FUNCTION VALUE TO
C     SCALE THE INITIAL STEP ALONG THE NEXT SEARCH VECTOR.

      DGLAST = DG0
      FLAST  = FMIN

C     STORE THE CURRENT X AND G.

      CALL ZZCOPY ( N, X, 1, XX, 1 )
      CALL ZZCOPY ( N, G, 1, GG, 1 )

C     THIS NEXT LITTLE LOOP AVOIDS THE POSSIBILITY OF A
C     RIDICULOUSLY SMALL VALUE FOR ALPHA.

 1900 IF ( FX+ ALPHA*DG0 .LT. FX + NERLY1*ALPHA*DG0 ) THEN
         WIDTH = ALPHA
      ELSE
         ALPHA = TWO * ALPHA
         GOTO 1900
      ENDIF


C>>>>>>>>>> P H A S E  VI: TEST FOR LINE SEARCH FAILURE.<<<<<<<<<<<<<<<<

 2000 CONTINUE

      IF ( TR3 ) WRITE(TRU,*) ' [LNIR] LS ALPHA->',ALPHA

      IF ( TR5 ) WRITE(TRU,*) ' [LNIR] VALUES: AP,FP,DGP,DGLAST,DG0,'
     -                     //'FLAST,FMIN,NRMD->'
      IF ( TR5 ) WRITE(TRU,*) AP,FP,DGP,DGLAST,DG0,FLAST,FMIN,NRMD

      IF ( USESHN ) THEN
         TOOSML = ALPHA * NRMD .LE. EPS
      ELSE
         TOOSML = WIDTH * NRMD .LE. EPS * NRMX
      ENDIF

      IF ( TOOSML ) THEN

C        THIS IS AN ABNORMALLY SMALL STEP. TEST IF THE DIRECTION
C        IS A GRADIENT DIRECTION. IF NOT, TRY ONE BEFORE ABORTING
C        THE RUN; I.E. DO A TOTAL RESTART FROM SCRATCH UNLESS THIS
C        STEP IS ALREADY A STEEPEST DESCENT STEP FROM A COLD START.

         IF ( TR6 ) WRITE(TRU,*) ' [LNIR] ALPHA TOO SMALL.'
         IF ( TR8 ) WRITE(TRU,*) ' [LNIR] EPS,WIDTH->', EPS,WIDTH

         IF ( COLD ) THEN
            OTSTAT = LSFAIL
            GOTO 90000
         ELSE
            GOTO 20
         ENDIF

      ENDIF

C>>>>>>>>>> P H A S E  VII: LINE SEARCH LOOP.<<<<<<<<<<<<<<<<<<<<<<<<<<<

C     LSDONE IS SET TO TRUE WHEN THE LINE SEARCH IS DEEMED COMPLETE.
C     EACH LOOP DETERMINES A NEW VALUE FOR ALPHA AND RETURNS TO 2000
C     UNLESS THE SEARCH HAS BEEN DEEMED COMPLETE.

C     COMPUTE THE NEW TRIAL POINT.

      CALL ZZCOPY ( N, XX, 1, X, 1 )
      CALL ZZAXPY ( N, ALPHA, D, 1, X, 1 )

C     EVALUATE THE FUNCTION AT THE TRIAL POINT.

      IF ( INSTAT .EQ. RCSTRT .OR. INSTAT .EQ. RCRPT
     -                        .OR. INSTAT .EQ. RCNOFG ) THEN

C        EXIT FOR REVERSE COMMUNICATION. (RE-ENTRY WILL BE TO 2150)

         NOPRNT = T
         OTSTAT = RCFG
         GOTO 90000

      ELSE

         CASE   = DOFG
         VALIDF = T
         CALL ZZEVAL (FUNCNM, N, X, FX, G, CASE, IW, RW, DW )
         IF ( BAD() ) THEN
            IF      ( CASE .EQ. LIMIT ) THEN
               OTSTAT = XSFUNC
            ELSE IF ( CASE .EQ. ABORT ) THEN
               OTSTAT = RABORT
            ELSE
               VALIDF = F
            ENDIF
         ENDIF

      ENDIF

 2150 IF ( OTSTAT .EQ. OK ) THEN

         NCALLS = NCALLS + 1

C        COMPUTE THE DIRECTIONAL DERIVATIVE OF F ALONG D AT ALPHA.

         DGAL = INNER ( N, D, G, NONORM, IW, RW, DW )
         NRMG = INNER ( N, G, G, DONORM, IW, RW, DW )

         IF ( TR5 ) WRITE (TRU,*) ' [LNIR] NORM OF G->', NRMG

         IF ( TR5 ) THEN
            IF ( ABS(DGAL) .LE. NRMG*NRMD ) THEN
               WRITE(TRU,*) ' [LNIR] ANGLE OF D TO -G->',
     -                   ANGLE(-DGAL/(NRMG*NRMD)) ,' DEGREES'
            ELSE
               WRITE(TRU,*) ' [LNIR] WARNING...ON ANGLE OF D TO -G'//
     -                   ' WE HAVE DGAL > NRMG*NRMD ->', DGAL,NRMG*NRMD
            ENDIF
         ENDIF

         IF (TR5) WRITE(TRU,*)' [LNIR] SEARCH: ALPHA,NRMD,EPS,FX->',
     -                                         ALPHA,NRMD,EPS,FX
         IF (TR10 .AND. TR5) WRITE(TRU,*) ' [LNIR] X->', X

         CALL BBLINS ( ALPHA, FX, DGAL, VALIDF, FMIN, DGLAST, AP,  FP,
     -     DGP, WIDTH, NOUPS, LSDONE, CT, NCALLS, QUADON, UPDATT )

         IF ( .NOT. LSDONE ) THEN
C           CHECK POINTS NOT ACTUALLY IDENTICAL FROM ROUNDOFF.
            DO 2500 I = 1,N
               TP0 = XX(I) + ALPHA*D(I)
               IF ( TP0 .NE. XX(I) .AND. TP0 .NE. X(I) ) THEN
                  GOTO 2600
               ENDIF
 2500       CONTINUE
C           IF IDENTICAL, THEN FORCE TERMINATION WITH ERROR.
            WIDTH = ZERO
 2600       GOTO 2000
         ENDIF

      ELSE
         GOTO 90000
      ENDIF

C     FLOW CONTINUES TO PHASE VIII IF THE LINE SEARCH IS DONE
C     OR RETURNS TO 2000 IF NOT.

C>>>>>>>>>> P H A S E  VIII: TERMINATION TEST.<<<<<<<<<<<<<<<<<<<<<<<<<<

      FRSTRM = F

      CALL ZZTERM ( FRSTRM, N, FX, G, X, XX, ACC, LESS )

      IF ( TR7 ) WRITE(TRU,*) ' [LNIR] TERM? LESS->',LESS

      IF ( .NOT. LESS ) THEN
         CALL ZZPRNT ( N, X, FX, G, NRMG, 1 )
      ELSE
         GOTO 90000
      ENDIF

C>>>>>>>>>> P H A S E  IX: TEST IF RESTART NEEDED.<<<<<<<<<<<<<<<<<<<<<<

C     SEARCH CONTINUES. SET D(CT)=ALPHA*D(CT), SO THE FULL STEP VECTOR
C     S IS IN  D.  ALSO COMPUTE NRMG.

      CALL ZZSCAL ( N, ALPHA, D, 1 )

C     CHECK IF A RESTART IS TO BE FORCED.

      FORCER = CG .AND. UPDATT .EQ. SUMFRM
     -            .AND. ( .NOT. LMSTQN )
     -            .AND. ( (CT .GT. LASTPT) .OR. (STEEPD .AND. FORCEF) )

      IF (TR7)WRITE(TRU,*) ' [LNIR] FORCER, CT,LASTPT,STEEPD,FORCEF->',
     -                              FORCER, CT,LASTPT,STEEPD,FORCEF

      IF      ( CG .AND. UPDATT .EQ. SUMFRM ) THEN

C        DETERMINE WHICH PART OF THE ALGORITHM WE ARE IN
C        FOR NEXT STEP.

         QNPART =      ( FORCER .AND.  M .NE. 0   )
     -            .OR. ( QNPART .AND. CT .LE. M   )

         TESTR  = .NOT. QNPART  .AND. CT .GT. M+1

      ELSE IF  ( CG .AND. UPDATT .EQ. PRDFRM ) THEN

         QNPART = T

      ELSE IF  ( CG .AND. UPDATT .EQ. MJDFRM ) THEN
         QNPART = T
      ENDIF

      IF ( FORCER ) THEN

         RSTEP  = T

      ELSE IF
     -       ( CG .AND. UPDATT .EQ. SUMFRM
     -            .AND. (TESTR)
     -            .AND. HTEST .NE. 0       ) THEN

         IF ( TR7 ) WRITE(TRU,*) ' [LNIR] CG PART: RESTART?'

C        MUST BE IN   CG SEQUENCE, SO MUST CHECK IF
C        RESTART IS NEEDED ACCORDING TO POWELL CRITERION.  CAN APPLY
C        IN METRIC DEFINED BY  H  OR BY  I; I.E.  USING  G'*H*G, OR
C        G'*G.  COMPUTE VALUES FOR RESTART TEST.

         IF ( HTEST .EQ. 2  .AND. .NOT. USESHN ) THEN

C           POWELL'S TEST WITH H AS CURRENTLY DEFINED.
C           USE XX AS TEMPORARY STORAGE FOR H*G.

            CALL BBMULT (H, G, XX, N, NUPS, T, IDENTY, INNER, IW, RW,DW)

            TP1 = INNER ( N, XX, GG, NONORM, IW, RW, DW )
            TP2 = INNER ( N, XX, G,  NONORM, IW, RW, DW )
         ELSE

C           THE ORDINARY TEST; ESSENTIALLY POWELL'S TEST WITH H = I .

            TP1 = INNER ( N, G,  GG, NONORM, IW, RW, DW )

            TP2 = NRMG**2

         ENDIF

         IF ( TR7 ) WRITE(TRU,*) ' [LNIR] RESTART IF TP1(',TP1,
     -                           ') > RO*TP2 (',RO*TP2,')'

C        SET RESTART FLAG IF TAU[CT] > RO; NOTE THAT TAU = TP1/TP2
C        BUT THE TEST IS DONE WITHOUT THE DIVIDE.

         RSTEP = ABS(TP1) .GT. ABS(RO*TP2)

         IF ( RSTEP ) NFORCE = NFORCE + 1

      ELSE

         IF ( TR7 ) WRITE (TRU,*) ' [LNIR] NO RESTART TEST.'
         RSTEP = F

      ENDIF

C>>>>>>>>>> P H A S E  X: UPDATE FOR NEXT STEP.<<<<<<<<<<<<<<<<<<<<<<<<<

C     WE NOW CALL A ROUTINE TO UPDATE H FROM ITS VALUE AT
C     THE LAST POINT TO ITS VALUE AT THE POINT WHICH WE HAVE
C     JUST REACHED AT THE END OF THIS LINE SEARCH. THE DETAILS
C     OF THE UPDATING ARE IN BBUPDT. NOTE THAT, IN THE CG CASE,
C     THE NEGATIVE OF THE NEXT SEARCH DIRECTION MUST ALSO BE
C     RETURNED.

      CALL ZZAXPY  ( N, -ONE, G, 1, GG, 1 )
      CALL ZZSCAL  ( N, -ONE,       GG, 1 )
      ETA = INNER ( N, D, GG, NONORM, IW, RW, DW )

      CALL BBUPDT (N, G, D, XX, GG, H, ETA, CT, CNTRST, LASTPT,
     -            IDENTY, NUPS, STEEPD,  RSTEP, QNPART, ALPHA,
     -            STG, UTG, NU, UPDATT, INNER, IW,RW,DW)

C>>>>>>>>>> P H A S E   XI:  COMPUTE NEW DIRECTION.<<<<<<<<<<<<<<<<<<<<<

      IF  ( CG ) THEN

C        FIRST GET THE NEGATIVE OF THE NEW SEARCH DIRECTION INTO XX.

         IF ( RSTEP ) THEN
             CALL BBMULT ( H, G, XX, N, NUPS, CMPALL, IDENTY,
     -                     INNER, IW, RW, DW )

         ELSE IF ( UPDATT .EQ. SUMFRM ) THEN

C            NOTE THAT U=H*Y IS IN XX FROM UPDATE.
C            COMPUTE H^*G BY PUTTING  H*G INTO GG AND THEN WORKING IN
C            THE NEW UPDATE TERM. THIS MUST BE DONE SEPARATELY SINCE THE
C            NEW UPDATE MAY NOT BE SAVED. NOTE THAT THIS IS NOT AN INIT-
C            IAL STEP, SO WE ONLY DO THE GAMMA SCALING IF SCGAMM=GAMALL.

             CALL BBMULT (H, G, GG, N, NUPS, T, IDENTY, INNER, IW,RW,DW)

             IF ( QNPART ) THEN
                 CALL ZZCOPY ( N, GG, 1, XX, 1 )
             ELSE
                 IF ( SCGAMM .EQ. GAMALL ) THEN
                    SIGMA = ( TWO*STG/ETA) - (UTG/NU)
                    MU    = -STG/NU
                    GAMMA =  ETA/NU
                 ELSE
                    SIGMA = ( (ONE + NU/ETA)*STG - UTG ) / ETA
                    MU    = -STG/ETA
                    GAMMA = ONE
                 ENDIF
C                          NOW COMPUTE  H^*G INTO XX.
                 CALL ZZSCAL ( N, MU,           XX, 1 )
                 CALL ZZAXPY ( N, SIGMA,  D, 1, XX, 1 )
                 CALL ZZAXPY ( N, GAMMA, GG, 1, XX, 1 )

             ENDIF

         ELSE IF ( UPDATT .EQ. PRDFRM ) THEN
             CALL BBNOCE ( H, G, XX, N, CT, M, IDENTY, GG,
     -                     INNER, IW, RW, DW )
         ELSE IF ( UPDATT .EQ. MJDFRM ) THEN
             CALL BBPOWL ( H, G, XX, N, NUPS, M, IDENTY, SCDIAG,
     -                     INNER, IW, RW, DW )
         ENDIF

         CALL ZZCOPY ( N, XX, 1, D, 1 )
         CALL ZZSCAL ( N, -ONE,  D, 1 )

C        CALCULATE THE DERIVATIVE DG0 ALONG THE NEW SEARCH VECTOR D.

         DG0  = INNER ( N, D, G, NONORM, IW, RW, DW )
         NRMD = INNER ( N, D, D, DONORM, IW, RW, DW )

         IF ( TR7 ) WRITE(TRU,*) ' [LNIR] NEW D USING CG.'

      ELSE

C        QN CASE:  CALCULATE THE NEW SEARCH DIRECTION D(CT+1) = -H!*G
C        AND THE DIRECTIONAL DERIVATIVE DG0 = D'G OF F ALONG D.
C        H! IS IN H.

         DO 8000 K=1,N

            TP0 = ZERO
            KJ  = K

            DO 7600 J=1,K-1
               TP0 = TP0 - H(KJ)*G(J)
               KJ  = KJ + (N-J)
 7600       CONTINUE

            DO 7800 J=K,N
               TP0 = TP0 - H(KJ)*G(J)
               KJ  = KJ  + 1
 7800       CONTINUE

            D(K) = TP0

 8000    CONTINUE

         NRMD = INNER ( N, D, D, DONORM, IW, RW, DW )

         DG0 = ZERO

         DO 8200 K = 1,N
            DG0 = DG0 + G(K)*D(K)
 8200    CONTINUE

      ENDIF
C            ...FOR THE COMPUTATION OF D.

C     TEST FOR A DOWNHILL DIRECTION.

      IF ( DG0 .GE. ZERO ) THEN
         IF ( ANYTR ) THEN
            WRITE (TRU,*) ' [LNIR] ***FAILING*** NONDOWNHILL DIRECTION!'
            WRITE (TRU,*) '        ***DG0->',DG0,'***'
         ENDIF
         OTSTAT = NODESC
      ELSE
         STEEPD = NOUPS .AND. RSTEP
      ENDIF

      IF ( OTSTAT .NE. OK ) THEN
         GOTO 90000
      ELSE
         COLD = F
         GOTO 1600
      ENDIF

C## E N T R Y  BBLSET:
      ENTRY BBLSET ( SMETH,  SQUAD, SALPH1, SSTSTP, SSGAMM, SHTEST,
     -              SUPDAT,  SRO,   SBETA,
     -              SFQUAD,  SDIAG, SSHANN, SFROMR, SFORCE,
     -               SRELF,  SRELG,
     -              STRACU, STRACE                                    )
      METH   = SMETH
      QUADIN = SQUAD
      ALPIS1 = SALPH1
      STSTEP = SSTSTP
      SCGAMM = SSGAMM
      HTEST  = SHTEST
      UPDATT = SUPDAT
      RO     = SRO
      BETA   = SBETA
      FQUAD  = SFQUAD
      DIAGNL = SDIAG
      SHANNO = SSHANN
      FROMRS = SFROMR
      FORCEF = SFORCE
      RELF = SRELF
      RELG = SRELG
      TRU    = STRACU
      TR1  = STRACE( 1)
      TR2  = STRACE( 2)
      TR3  = STRACE( 3)
      TR4  = STRACE( 4)
      TR5  = STRACE( 5)
      TR6  = STRACE( 6)
      TR7  = STRACE( 7)
      TR8  = STRACE( 8)
      TR9  = STRACE( 9)
      TR10 = STRACE(10)
      TR11 = STRACE(11)
      TR12 = STRACE(12)
      TR13 = STRACE(13)
      TR14 = STRACE(14)
      TR15 = STRACE(15)
      ANYTR=      TR1  .OR. TR2  .OR. TR3  .OR. TR4  .OR. TR5
     -       .OR. TR6  .OR. TR7  .OR. TR8  .OR. TR9  .OR. TR10
     -       .OR. TR11 .OR. TR12 .OR. TR13 .OR. TR14 .OR. TR15
      RETURN

C## E N T R Y  BBLDDF:
C                    SET CODES FOR DERIVATIVE EVALUATION MODES.

      ENTRY  BBLDDF ( SANAL, SDIFF, STEST, SFIRST )

      CALL   ZZEDDF ( SANAL, SDIFF, STEST, SFIRST )
      CALL   BBDVAL ( SANAL )
      RETURN

C## E N T R Y  BBLFDF:
C                    SET CODES FOR FUNCTION/GRADIENT EVALUATION CHOICES
C                    *PASSED TO* FUNCTION EVALUATION ROUTINE.
      ENTRY  BBLFDF ( SDOF, SDOG, SDOFG, SNONE )

      DOF  = SDOF
      DOG  = SDOG
      DOFG = SDOFG
      NONE = SNONE
      CALL   ZZEFDF ( DOF, DOG, DOFG, NONE )
      RETURN

C## E N T R Y  BBLIDF:
C                     SET VALUES FOR STATUS *PASSED INTO* BBLNIR.

      ENTRY  BBLIDF ( SNRMFG, SNORML, SRCSTR, SRCRPT, SRCNFG, SPSTHR )
      NORMFG = SNRMFG
      NORMAL = SNORML
      RCSTRT = SRCSTR
      RCRPT  = SRCRPT
      RCNOFG = SRCNFG
      PSTHRU = SPSTHR
      CALL BBVIDF  ( SNRMFG, SNORML, SRCSTR, SRCRPT, SRCNFG, SPSTHR )
      RETURN

C## E N T R Y  BBLSDF:
C                     SET VALUES FOR STATUS *RETURNED BY* BBLNIR.

      ENTRY  BBLSDF ( SDONE,  SRCF,   SRCFG,    SRCG, SNSTOR, SIPMIN,
     -        SIPUNF, SBDMTH, SLSFAL, SNODSC, SXSFNC, SRABRT, SUSERV,
     -        SPSBCK )
      DONE   = SDONE
      RCF    = SRCF
      RCFG   = SRCFG
      RCG    = SRCG
      NOSTOR = SNSTOR
      IPMIN  = SIPMIN
      IPUNDF = SIPUNF
      BDMETH = SBDMTH
      LSFAIL = SLSFAL
      NODESC = SNODSC
      XSFUNC = SXSFNC
      RABORT = SRABRT
      USERV  = SUSERV
      PSBACK = SPSBCK
      CALL   BBVSDF ( SDONE,  SRCF,   SRCFG,    SRCG, SNSTOR, SIPMIN,
     -        SIPUNF, SBDMTH, SLSFAL, SNODSC, SXSFNC, SRABRT, SUSERV,
     -        SPSBCK )
      RETURN

C## E N T R Y  BBLRDF:

C     SET VALUES FOR CODES *RETURNED BY* FUNCTION EVALUATION ROUTINE.

      ENTRY  BBLRDF ( SOK, SABORT, SLIMIT, SNOF, SNOG, SNOFG )
      OK    = SOK
      ABORT = SABORT
      LIMIT = SLIMIT
      NOF   = SNOF
      NOG   = SNOG
      NOFG  = SNOFG
      CALL   ZZERDF ( SOK, SABORT, SLIMIT, SNOF, SNOG, SNOFG )
      RETURN

C## E N T R Y  BBVGET:
                     ENTRY  BBVGET ( NRESTR, MUPS, CNTFOR )
      NRESTR = CNTRST
      IF ( CG ) THEN
          MUPS   = M
      ELSE
          MUPS   = -1
      ENDIF
      CNTFOR = NFORCE
      RETURN

C## E X I T

90000 IF ( .NOT. NOPRNT ) CALL ZZPRNT ( N, X, FX, G, NRMG, -1 )
      STATUS = OTSTAT
      RETURN

C## F O R M A T S:

99999 FORMAT ( ' **** BBLNIR ENTERED AND INITIALIZATION COMPLETE ****'/
     -         /
     -         ' DIMENSION  = ', I5, T40,
     -         ' MEMORY AVAILABLE IS ', I7/
     -         ' ACCURACY REQUESTED = ', G15.7, T40,
     -         ' STATUS ON ENTRY IS ', I2                           )
99998 FORMAT ( ' ON ENTRY, VALUES WERE DEFINED FOR FX AS ',G25.17/
     -         '               AND FOR THE NORM OF G  AS ',G25.8     )
99997 FORMAT ( ' EXPECTED REDUCTION IN F EQUALS INITIAL FUNCTION',
     -         ' VALUE OF ',G15.7 )
99996 FORMAT ( ' EXPECTED REDUCTION IN F IS UNKNOWN (DECRF=',G8.1,')')
99995 FORMAT ( ' EXPECTED REDUCTION IN F IS ',G15.7 )
99994 FORMAT ( ' INTEGER CONTROL SETTINGS  METH  QUADIN ALPIS1 STSTEP',
     -         ' SCGAMM HTEST  UPDATT'/
     -         '                       ', 7I7/
     -         ' REAL CONTROL VALUES  RO = ', G15.7, ' BETA = ',G15.7/
     -         ' LOGICAL CONTROL VALUES   FQUAD  SCDIAG SHANNO FROMRS'/
     -         '                       ', 4L7 /
     -         '                          FORCEF RELF   RELG '/
     -         '                       ', 3L7 /
     -         /
     -         ' THE FOLLOWING HAVE BEEN SET DURING INITIALIZATION ' /
     -         ' LMSTQN (',L1,'); CG (', L1,'); USESHN (',L1,
     -         '); ONEUPD (',L1,')'/
     -         ' MACHINE RELATIVE ACCURACY EPS = ', E8.2/
     -         ' TERMINATION RELATIVE TO ', G14.7,'(F); ',G14.7,'(G)' )
99993 FORMAT ( ' STORAGE OF ', I6, ' SUFFICIENT; USING QN ALGORITHM.' /)
99992 FORMAT ( ' STORAGE LIMITED; USING ', I3, ' UPDATES.' /)

C##                 E N D         OF BBLNIR.
                    END
